/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorTileEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExcavatorLubricationHandler
implements LubricatedHandler.ILubricationHandler<ExcavatorTileEntity> {
    private static Vector3i size = new Vector3i(3, 6, 3);
    private static final ResourceLocation TEXTURE = new ResourceLocation("immersivepetroleum", "textures/models/lube_pipe.png");
    private static Supplier<IPModel> pipes_normal;
    private static Supplier<IPModel> pipes_mirrored;

    @Override
    public Vector3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(World world, ExcavatorTileEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        TileEntity center = world.func_175625_s(wheelPos);
        if (center instanceof BucketWheelTileEntity) {
            BucketWheelTileEntity wheel = (BucketWheelTileEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                wheel = (BucketWheelTileEntity)wheel.master();
            }
            return wheel.active;
        }
        return false;
    }

    @Override
    public TileEntity isPlacedCorrectly(World world, AutoLubricatorTileEntity lubricator, Direction facing) {
        ExcavatorTileEntity master;
        BlockPos target = lubricator.func_174877_v().func_177972_a(facing);
        TileEntity te = world.func_175625_s(target);
        if (te instanceof ExcavatorTileEntity && (master = (ExcavatorTileEntity)((ExcavatorTileEntity)te).master()) != null) {
            Direction dir;
            Direction direction = dir = master.getIsMirrored() ? master.getFacing().func_176746_e() : master.getFacing().func_176735_f();
            if (dir == facing) {
                return master;
            }
        }
        return null;
    }

    @Override
    public void lubricate(World world, int ticks, ExcavatorTileEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        TileEntity center = world.func_175625_s(wheelPos);
        if (center instanceof BucketWheelTileEntity) {
            BucketWheelTileEntity wheel = (BucketWheelTileEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                wheel = (BucketWheelTileEntity)wheel.master();
            }
            if (!world.field_72995_K && ticks % 4 == 0) {
                int consumed = (Integer)IEServerConfig.MACHINES.excavator_consumption.get();
                int extracted = mbte.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    mbte.energyStorage.extractEnergy(extracted, false);
                    wheel.rotation = (float)((double)wheel.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get() / 4.0);
                }
            } else {
                wheel.rotation = (float)((double)wheel.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get() / 4.0);
            }
        }
    }

    @Override
    public void spawnLubricantParticles(World world, AutoLubricatorTileEntity lubricator, Direction facing, ExcavatorTileEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.func_176734_d();
        float location = world.field_73012_v.nextFloat();
        boolean flip = f.func_176740_k() == Direction.Axis.Z ^ facing.func_176743_c() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 1.2f;
        float zO = -0.5f;
        float yO = 0.5f;
        if (location > 0.5f) {
            xO = 0.9f;
            yO = 0.8f;
            zO = 1.75f;
        }
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.func_174877_v().func_177958_n() + (f.func_176740_k() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.func_174877_v().func_177956_o() + yO;
        float z = (float)lubricator.func_174877_v().func_177952_p() + (f.func_176740_k() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.field_73012_v.nextFloat();
            BlockState n = IPContent.Fluids.lubricant.block.func_176223_P();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, n), (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(World world, ExcavatorTileEntity mbte) {
        if (!mbte.isDummy()) {
            BlockPos pos = mbte.func_174877_v().func_177967_a(mbte.getFacing(), 4).func_177967_a(mbte.getIsMirrored() ? mbte.getFacing().func_176735_f() : mbte.getFacing().func_176746_e(), 2);
            Direction f = mbte.getIsMirrored() ? mbte.getFacing().func_176746_e() : mbte.getFacing().func_176735_f();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, ExcavatorTileEntity mbte, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrix.func_227861_a_(0.0, -1.0, 0.0);
        BlockPos offset = mbte.func_174877_v().func_177973_b((Vector3i)lubricator.func_174877_v());
        matrix.func_227861_a_((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.func_227861_a_(-1.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                matrix.func_227863_a_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                matrix.func_227861_a_(0.0, 0.0, -2.0);
                break;
            }
            case EAST: {
                matrix.func_227861_a_(0.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                matrix.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrix.func_227861_a_(-1.0, 0.0, -2.0);
                break;
            }
        }
        IPModel model = null;
        if (mbte.getIsMirrored()) {
            if (pipes_mirrored == null) {
                pipes_mirrored = IPModels.getSupplier("excavator_lubepipes_mirrored");
            }
            model = pipes_mirrored.get();
        } else {
            if (pipes_normal == null) {
                pipes_normal = IPModels.getSupplier("excavator_lubepipes_normal");
            }
            model = pipes_normal.get();
        }
        if (model != null) {
            model.func_225598_a_(matrix, buffer.getBuffer(model.func_228282_a_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

