/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import dev.ftb.mods.ftbchunks.integration.StaticMapIcon;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointMapIcon
extends StaticMapIcon {
    public final Waypoint waypoint;
    public Icon outsideIcon;
    public double distance;
    public int alpha;

    public WaypointMapIcon(Waypoint w) {
        super(new Vector3d((double)w.x + 0.5, (double)w.y + 0.5, (double)w.z + 0.5));
        this.waypoint = w;
        this.outsideIcon = Icon.EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        if (outsideVisibleArea) {
            double d = mapType.isMinimap() ? this.waypoint.minimapDistance : this.waypoint.inWorldDistance;
            if (!(distanceToPlayer <= d)) return false;
        }
        if (!mapType.isWorldIcon()) return true;
        if (!(distanceToPlayer >= 0.5)) return false;
        return true;
    }

    @Override
    public boolean isIconOnEdge(MapType mapType, boolean outsideVisibleArea) {
        return !outsideVisibleArea;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.string(this.waypoint.name);
        super.addTooltip(list);
    }

    @Override
    public boolean mousePressed(LargeMapScreen screen, MouseButton button) {
        if (super.mousePressed(screen, button)) {
            return true;
        }
        if (button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent(this.waypoint.name), this.icon, () -> {}));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.rename"), Icons.CHAT, () -> {
                StringConfig config = new StringConfig();
                config.defaultValue = "";
                config.value = this.waypoint.name;
                config.onClicked(MouseButton.LEFT, b -> {
                    if (b) {
                        this.waypoint.name = (String)config.value;
                        this.waypoint.dimension.saveData = true;
                    }
                    screen.openGui();
                });
            }));
            if (this.waypoint.type.canChangeColor) {
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent("Change Color"), Icons.COLOR_RGB, () -> {
                    int r = this.waypoint.color >> 16 & 0xFF;
                    int g = this.waypoint.color >> 8 & 0xFF;
                    int b = this.waypoint.color >> 0 & 0xFF;
                    float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
                    Color4I col = Color4I.hsb((float)(hsb[0] + 0.083333336f), (float)hsb[1], (float)hsb[2]);
                    this.waypoint.color = col.rgba();
                    this.waypoint.dimension.saveData = true;
                    this.icon = Icon.EMPTY;
                    this.outsideIcon = Icon.EMPTY;
                    this.checkIcon();
                    ((ContextMenuItem)contextMenu.get((int)0)).icon = this.icon;
                }).setCloseMenu(false));
            }
            contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent(this.waypoint.hidden ? "Show" : "Hide"), Icons.BEACON, () -> {
                this.waypoint.hidden = !this.waypoint.hidden;
                this.waypoint.dimension.saveData = true;
                ((ContextMenuItem)contextMenu.get((int)0)).title = new StringTextComponent(this.waypoint.hidden ? "Show" : "Hide");
                screen.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.remove"), Icons.REMOVE, () -> {
                this.waypoint.dimension.getWaypoints().remove(this.waypoint);
                this.waypoint.dimension.saveData = true;
                RefreshMinimapIconsEvent.trigger();
                screen.regionPanel.refreshWidgets();
            }));
            screen.openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(LargeMapScreen screen, Key key) {
        if (super.keyPressed(screen, key)) {
            return true;
        }
        if (key.is(261)) {
            this.waypoint.dimension.getWaypoints().remove(this.waypoint);
            this.waypoint.dimension.saveData = true;
            RefreshMinimapIconsEvent.trigger();
            screen.regionPanel.refreshWidgets();
            return true;
        }
        return false;
    }

    public void checkIcon() {
        if (this.icon == Icon.EMPTY || this.outsideIcon == Icon.EMPTY) {
            Color4I tint = Color4I.rgb((int)this.waypoint.color).withAlpha(this.waypoint.hidden ? 130 : 255);
            this.icon = this.waypoint.type.icon.withTint(tint);
            this.outsideIcon = this.waypoint.type.outsideIcon.withTint(tint);
        }
    }

    @Override
    public void draw(MapType mapType, MatrixStack stack, int x, int y, int w, int h, boolean outsideVisibleArea) {
        this.checkIcon();
        (outsideVisibleArea || mapType.isWorldIcon() ? this.outsideIcon : this.icon).draw(stack, x, y, w, h);
        if (!outsideVisibleArea && mapType.isWorldIcon()) {
            Minecraft mc = Minecraft.func_71410_x();
            String ds = MathHelper.func_76143_f((double)MathUtils.dist((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c, (double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226278_cu_(), (double)mc.field_71439_g.func_226281_cx_())) + " m";
            int nw = mc.field_71466_p.func_78256_a(this.waypoint.name);
            int dw = mc.field_71466_p.func_78256_a(ds);
            Color4I.DARK_GRAY.withAlpha(200).draw(stack, x + (w - nw) / 2 - 2, y - 14, nw + 4, 12);
            Color4I.DARK_GRAY.withAlpha(200).draw(stack, x + (w - dw) / 2 - 2, y + 18, dw + 4, 12);
            mc.field_71466_p.func_238405_a_(stack, this.waypoint.name, (float)x + (float)(w - nw) / 2.0f, (float)y - 12.0f, -1);
            mc.field_71466_p.func_238405_a_(stack, ds, (float)x + (float)(w - dw) / 2.0f, (float)y + 20.0f, -1);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
        }
    }
}

