/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChunkLoaderUtil {
    @CapabilityInject(value=ChunkTracker.class)
    public static Capability<ChunkTracker> TRACKER_CAPABILITY;

    public static void register() {
        CapabilityManager.INSTANCE.register(ChunkTracker.class, (Capability.IStorage)new Capability.IStorage<ChunkTracker>(){

            public CompoundNBT writeNBT(Capability<ChunkTracker> capability, ChunkTracker instance, Direction side) {
                return instance.write();
            }

            public void readNBT(Capability<ChunkTracker> capability, ChunkTracker instance, Direction side, INBT nbt) {
                instance.read((CompoundNBT)nbt);
            }
        }, ChunkTracker::new);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        final LazyOptional tracker = LazyOptional.of(() -> new ChunkTracker((ServerWorld)world));
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<INBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == TRACKER_CAPABILITY ? tracker.cast() : LazyOptional.empty();
            }

            public INBT serializeNBT() {
                return TRACKER_CAPABILITY.writeNBT(tracker.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                TRACKER_CAPABILITY.readNBT(tracker.orElse(null), null, nbt);
            }
        });
        e.addListener(() -> ((LazyOptional)tracker).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !(e.world instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)e.world;
        ServerChunkProvider chunkProvider = world.func_72863_F();
        int tickSpeed = world.func_82736_K().func_223592_c(GameRules.field_223610_m);
        if (tickSpeed > 0) {
            world.getCapability(TRACKER_CAPABILITY).ifPresent(tracker -> {
                for (ChunkPos pos : ((ChunkTracker)tracker).chunks.keySet()) {
                    if (chunkProvider.field_217237_a.func_219097_a(pos, false).count() != 0L) continue;
                    world.func_217441_a(world.func_212866_a_(pos.field_77276_a, pos.field_77275_b), tickSpeed);
                }
            });
        }
    }

    public static class ChunkTracker {
        private final ServerWorld world;
        private final Map<ChunkPos, List<BlockPos>> chunks = new HashMap<ChunkPos, List<BlockPos>>();

        public ChunkTracker(ServerWorld world) {
            this.world = world;
        }

        public ChunkTracker() {
            this.world = null;
        }

        public void add(ChunkPos chunk, BlockPos loader) {
            if (this.chunks.containsKey(chunk) && this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (!this.chunks.containsKey(chunk)) {
                this.chunks.put(chunk, new LinkedList());
                this.world.func_217458_b(chunk.field_77276_a, chunk.field_77275_b, true);
            }
            this.chunks.get(chunk).add(loader);
        }

        public void remove(ChunkPos chunk, BlockPos loader) {
            if (!this.chunks.containsKey(chunk) || !this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (this.chunks.get(chunk).size() == 1) {
                this.world.func_217458_b(chunk.field_77276_a, chunk.field_77275_b, false);
                this.chunks.remove(chunk);
            } else {
                this.chunks.get(chunk).remove(loader);
            }
        }

        public CompoundNBT write() {
            CompoundNBT compound = new CompoundNBT();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                CompoundNBT chunkTag = new CompoundNBT();
                chunkTag.func_74772_a("chunk", entry.getKey().func_201841_a());
                LongArrayNBT blocks = new LongArrayNBT(entry.getValue().stream().map(BlockPos::func_218275_a).collect(Collectors.toList()));
                chunkTag.func_218657_a("blocks", (INBT)blocks);
                compound.func_218657_a(entry.getKey().field_77276_a + ";" + entry.getKey().field_77275_b, (INBT)chunkTag);
            }
            return compound;
        }

        public void read(CompoundNBT compound) {
            for (String key : compound.func_150296_c()) {
                CompoundNBT chunkTag = compound.func_74775_l(key);
                ChunkPos chunk = new ChunkPos(chunkTag.func_74763_f("chunk"));
                LongArrayNBT blocks = (LongArrayNBT)chunkTag.func_74781_a("blocks");
                Arrays.stream(blocks.func_197652_h()).mapToObj(BlockPos::func_218283_e).forEach(pos -> this.add(chunk, (BlockPos)pos));
            }
        }
    }
}

