/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.EntityTypes;
import mtr.Items;
import mtr.RegistryClient;
import mtr.block.BlockTactileMap;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.RenderAPGGlass;
import mtr.render.RenderBoatNode;
import mtr.render.RenderClock;
import mtr.render.RenderPIDS;
import mtr.render.RenderPSDTop;
import mtr.render.RenderRailwaySign;
import mtr.render.RenderRouteSign;
import mtr.render.RenderSignalLight;
import mtr.render.RenderSignalSemaphore;
import mtr.render.RenderStationNameEntrance;
import mtr.render.RenderStationNameTall;
import mtr.render.RenderStationNameWall;
import mtr.render.RenderTrains;
import mtr.sound.LoopingSoundInstance;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;

public class MTRClient
implements IPacket {
    private static boolean isReplayMod;
    private static boolean isVivecraft;
    private static float gameTick;
    private static float lastPlayedTrainSoundsTick;
    private static int tick;
    private static long startSampleMillis;
    private static float startSampleGameTick;
    private static float gameTickTest;
    private static int skipTicks;
    private static int lastSkipTicks;
    public static final int TICKS_PER_SPEED_SOUND = 4;
    public static final LoopingSoundInstance TACTILE_MAP_SOUND_INSTANCE;
    private static final int SAMPLE_MILLIS = 1000;

    public static void init() {
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.APG_DOOR);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.APG_GLASS);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.APG_GLASS_END);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.CLOCK);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_CIO);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_CKT);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_HEO);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_MOS);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_PLAIN);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_SHM);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_STAINED);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_STW);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_TSH);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.GLASS_FENCE_WKS);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.LOGO);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_INDENTED);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_NA_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_NA_1_INDENTED);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_NA_2);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_NA_2_INDENTED);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_UK_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PLATFORM_UK_1_INDENTED);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_DOOR_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_GLASS_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_GLASS_END_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_DOOR_2);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_GLASS_2);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.PSD_GLASS_END_2);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.RAIL_NODE);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.RUBBISH_BIN_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.SIGNAL_LIGHT_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), Blocks.STATION_COLOR_STAINED_GLASS);
        RegistryClient.registerBlockRenderType(RenderType.func_228645_f_(), (Block)Blocks.STATION_COLOR_STAINED_GLASS_SLAB);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.STATION_NAME_TALL_BLOCK);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.STATION_NAME_TALL_WALL);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_BARRIER_ENTRANCE_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_BARRIER_EXIT_1);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_MACHINE);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_PROCESSOR);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_PROCESSOR_ENTRANCE);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_PROCESSOR_EXIT);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TICKET_PROCESSOR_ENQUIRY);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TRAIN_ANNOUNCER);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TRAIN_CARGO_LOADER);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TRAIN_CARGO_UNLOADER);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TRAIN_REDSTONE_SENSOR);
        RegistryClient.registerBlockRenderType(RenderType.func_228643_e_(), Blocks.TRAIN_SCHEDULE_SENSOR);
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_20, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_20_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_40, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_40_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_60, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_60_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_80, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_80_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_120, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_120_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_160, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_160_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_200, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_200_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_300, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_300_ONE_WAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_PLATFORM, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_SIDING, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_TURN_BACK, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_REMOVER, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_WHITE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_ORANGE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_MAGENTA, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIGHT_BLUE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_YELLOW, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIME, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_PINK, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_GRAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIGHT_GRAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_CYAN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_PURPLE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BLUE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BROWN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_GREEN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_RED, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BLACK, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_WHITE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_ORANGE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_MAGENTA, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIGHT_BLUE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_YELLOW, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIME, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_PINK, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_GRAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIGHT_GRAY, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_CYAN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_PURPLE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BLUE, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BROWN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_GREEN, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_RED, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BLACK, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_9, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_3, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_5, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_7, "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_9, "pos");
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_SMALL_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 12, 1.0f, 15.0f, 16.0f, 14.0f, 14, false, false, true, 0xFF9900, 0xFF9900));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_MEDIUM_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 12, -15.0f, 15.0f, 16.0f, 30.0f, 46, false, false, true, 0xFF9900, 0xFF9900));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_LARGE_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 16, -15.0f, 15.0f, 16.0f, 46.0f, 46, false, false, true, 0xFF9900, 0xFF9900));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.BOAT_NODE_TILE_ENTITY, RenderBoatNode::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.CLOCK_TILE_ENTITY, RenderClock::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PSD_TOP_TILE_ENTITY, RenderPSDTop::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.APG_GLASS_TILE_ENTITY, RenderAPGGlass::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_1_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 1, 1.0f, 3.25f, 6.0f, 2.5f, 30, true, false, false, 0xFF9900, 0xFF9900));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_2_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 3, 1.5f, 7.5f, 6.0f, 6.5f, 29, true, true, false, 0xFF9900, 0xFF9900));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_3_TILE_ENTITY, dispatcher -> new RenderPIDS((TileEntityRendererDispatcher)dispatcher, 2, 2.5f, 7.5f, 6.0f, 6.5f, 27, true, false, false, 0xFF9900, 0x33CC00, 1.25f, true));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_2_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_2_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_3_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_3_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_4_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_4_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_5_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_5_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_6_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_6_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_7_EVEN_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_7_ODD_TILE_ENTITY, RenderRailwaySign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_STANDING_LIGHT_TILE_ENTITY, RenderRouteSign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_STANDING_METAL_TILE_ENTITY, RenderRouteSign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_WALL_LIGHT_TILE_ENTITY, RenderRouteSign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_WALL_METAL_TILE_ENTITY, RenderRouteSign::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_1, dispatcher -> new RenderSignalLight((TileEntityRendererDispatcher)dispatcher, true, false, -16776961));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_2, dispatcher -> new RenderSignalLight((TileEntityRendererDispatcher)dispatcher, false, false, -16776961));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_3, dispatcher -> new RenderSignalLight((TileEntityRendererDispatcher)dispatcher, true, true, -16711936));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_4, dispatcher -> new RenderSignalLight((TileEntityRendererDispatcher)dispatcher, false, true, -16711936));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_SEMAPHORE_1, dispatcher -> new RenderSignalSemaphore((TileEntityRendererDispatcher)dispatcher, true));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_SEMAPHORE_2, dispatcher -> new RenderSignalSemaphore((TileEntityRendererDispatcher)dispatcher, false));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_ENTRANCE_TILE_ENTITY, RenderStationNameEntrance::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_TALL_BLOCK_TILE_ENTITY, RenderStationNameTall::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_TALL_WALL_TILE_ENTITY, RenderStationNameTall::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_WALL_TILE_ENTITY, RenderStationNameWall::new);
        RegistryClient.registerEntityRenderer(EntityTypes.SEAT, RenderTrains::new);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_ANDESITE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BEDROCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BIRCH_WOOD);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BONE_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_QUARTZ_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_STONE_BRICKS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CLAY);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COAL_ORE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COBBLESTONE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE_POWDER);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CRACKED_STONE_BRICKS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DARK_PRISMARINE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DIORITE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_GRAVEL);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_IRON_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_METAL);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PLANKS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_ANDESITE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_DIORITE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_PILLAR);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BRICKS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_PILLAR);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_QUARTZ);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_STONE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SNOW_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STAINED_GLASS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE_BRICKS);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_WOOL);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_ANDESITE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_BEDROCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_BIRCH_WOOD_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_BONE_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CHISELED_QUARTZ_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CHISELED_STONE_BRICKS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CLAY_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_COAL_ORE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_COBBLESTONE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CONCRETE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CONCRETE_POWDER_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_CRACKED_STONE_BRICKS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_DARK_PRISMARINE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_DIORITE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_GRAVEL_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_IRON_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_METAL_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_PLANKS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_POLISHED_ANDESITE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_POLISHED_DIORITE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_PURPUR_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_PURPUR_PILLAR_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_QUARTZ_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_QUARTZ_BRICKS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_QUARTZ_PILLAR_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_SMOOTH_QUARTZ_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_SMOOTH_STONE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_SNOW_BLOCK_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_STAINED_GLASS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_STONE_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_STONE_BRICKS_SLAB);
        RegistryClient.registerBlockColors((Block)Blocks.STATION_COLOR_WOOL_SLAB);
        RegistryClient.registerBlockColors(Blocks.STATION_NAME_TALL_BLOCK);
        RegistryClient.registerBlockColors(Blocks.STATION_NAME_TALL_WALL);
        RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLE);
        RegistryClient.registerNetworkReceiver(PACKET_CHUNK_S2C, packet -> PacketTrainDataGuiClient.receiveChunk(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_DASHBOARD_SCREEN, packet -> PacketTrainDataGuiClient.openDashboardScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_PIDS_CONFIG_SCREEN, packet -> PacketTrainDataGuiClient.openPIDSConfigScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_ARRIVAL_PROJECTOR_CONFIG_SCREEN, packet -> PacketTrainDataGuiClient.openArrivalProjectorConfigScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_RAILWAY_SIGN_SCREEN, packet -> PacketTrainDataGuiClient.openRailwaySignScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_TICKET_MACHINE_SCREEN, packet -> PacketTrainDataGuiClient.openTicketMachineScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_TRAIN_SENSOR_SCREEN, packet -> PacketTrainDataGuiClient.openTrainSensorScreenS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_RESOURCE_PACK_CREATOR_SCREEN, packet -> PacketTrainDataGuiClient.openResourcePackCreatorScreen(Minecraft.func_71410_x()));
        RegistryClient.registerNetworkReceiver(PACKET_ANNOUNCE, packet -> PacketTrainDataGuiClient.announceS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_GENERATE_PATH, packet -> PacketTrainDataGuiClient.generatePathS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_CREATE_RAIL, packet -> PacketTrainDataGuiClient.createRailS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_CREATE_SIGNAL, packet -> PacketTrainDataGuiClient.createSignalS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_NODE, packet -> PacketTrainDataGuiClient.removeNodeS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_RAIL, packet -> PacketTrainDataGuiClient.removeRailConnectionS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_SIGNALS, packet -> PacketTrainDataGuiClient.removeSignalsS2C(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_STATION, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.STATIONS, ClientData.DATA_CACHE.stationIdMap, (id, transportMode) -> new Station((long)id), false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_PLATFORM, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.PLATFORMS, ClientData.DATA_CACHE.platformIdMap, null, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_SIDING, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.SIDINGS, ClientData.DATA_CACHE.sidingIdMap, null, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_ROUTE, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.ROUTES, ClientData.DATA_CACHE.routeIdMap, Route::new, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_DEPOT, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.DEPOTS, ClientData.DATA_CACHE.depotIdMap, Depot::new, false));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_STATION, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.STATIONS, ClientData.DATA_CACHE.stationIdMap, (id, transportMode) -> new Station((long)id), true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_PLATFORM, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.PLATFORMS, ClientData.DATA_CACHE.platformIdMap, null, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_SIDING, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.SIDINGS, ClientData.DATA_CACHE.sidingIdMap, null, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_ROUTE, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.ROUTES, ClientData.DATA_CACHE.routeIdMap, Route::new, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_DEPOT, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.func_71410_x(), packet, ClientData.DEPOTS, ClientData.DATA_CACHE.depotIdMap, Depot::new, true));
        RegistryClient.registerNetworkReceiver(PACKET_WRITE_RAILS, packet -> ClientData.writeRails(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAINS, packet -> ClientData.updateTrains(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_TRAINS, packet -> ClientData.deleteTrains(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAIN_PASSENGERS, packet -> ClientData.updateTrainPassengers(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packet -> ClientData.updateTrainPassengerPosition(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_RAIL_ACTIONS, packet -> ClientData.updateRailActions(Minecraft.func_71410_x(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_SCHEDULE, packet -> ClientData.updateSchedule(Minecraft.func_71410_x(), packet));
        BlockTactileMap.TileEntityTactileMap.updateSoundSource = TACTILE_MAP_SOUND_INSTANCE::setPos;
        BlockTactileMap.TileEntityTactileMap.onUse = pos -> {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station != null) {
                IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.welcome_station_cjk", "gui.mtr.welcome_station", 1, IGui.textOrUntitled(station.name)));
            }
        };
        Config.getPatreonList();
        Config.refreshProperties();
        RegistryClient.registerPlayerJoinEvent(player -> {
            Config.refreshProperties();
            isReplayMod = player.getClass().toGenericString().toLowerCase().contains("replaymod");
            try {
                Class.forName("org.vivecraft.main.VivecraftMain");
                isVivecraft = true;
            }
            catch (Exception ignored) {
                isVivecraft = false;
            }
            System.out.println(isReplayMod ? "Running in Replay Mod mode" : "Not running in Replay Mod mode");
            System.out.println(isVivecraft ? "Vivecraft detected" : "Vivecraft not detected");
        });
    }

    public static boolean isReplayMod() {
        return isReplayMod;
    }

    public static boolean isVivecraft() {
        return isVivecraft;
    }

    public static float getGameTick() {
        return gameTick;
    }

    public static void incrementGameTick() {
        long millis;
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        gameTickTest += lastFrameDuration;
        if (isReplayMod || tick == 0) {
            gameTick += lastFrameDuration;
        }
        if (++tick >= skipTicks) {
            tick = 0;
        }
        if ((millis = System.currentTimeMillis()) - startSampleMillis >= 1000L) {
            skipTicks = Math.round((gameTickTest - startSampleGameTick) * 50.0f / (float)(millis - startSampleMillis));
            startSampleMillis = millis;
            startSampleGameTick = gameTickTest;
            if (skipTicks != lastSkipTicks) {
                System.out.println("Tick skip updated to " + skipTicks);
            }
            lastSkipTicks = skipTicks;
        }
        ClientData.tick();
    }

    public static float getLastFrameDuration() {
        return isReplayMod ? 0.33333334f : Minecraft.func_71410_x().func_193989_ak();
    }

    public static boolean canPlaySound() {
        if (gameTick - lastPlayedTrainSoundsTick >= 4.0f) {
            lastPlayedTrainSoundsTick = gameTick;
        }
        return gameTick == lastPlayedTrainSoundsTick && !Minecraft.func_71410_x().func_147113_T();
    }

    static {
        gameTick = 0.0f;
        lastPlayedTrainSoundsTick = 0.0f;
        TACTILE_MAP_SOUND_INSTANCE = new LoopingSoundInstance("tactile_map_music");
    }

    @FunctionalInterface
    public static interface RegisterItemModelPredicate {
        public void accept(String var1, Item var2, String var3);
    }
}

