/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import mtr.EntityTypes;
import mtr.MTR;
import mtr.MTRClient;
import mtr.client.CustomResources;
import mtr.item.ItemBlockEnchanted;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.DeferredRegisterHolder;
import mtr.mappings.ForgeUtilities;
import mtr.mappings.RegistryUtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mtr")
public class MTRForge {
    private static final DeferredRegisterHolder<Item> ITEMS = new DeferredRegisterHolder("mtr", Registry.field_239714_o_);
    private static final DeferredRegisterHolder<Block> BLOCKS = new DeferredRegisterHolder("mtr", Registry.field_239711_l_);
    private static final DeferredRegisterHolder<TileEntityType<?>> BLOCK_ENTITY_TYPES = new DeferredRegisterHolder("mtr", Registry.field_239667_E_);
    private static final DeferredRegisterHolder<EntityType<?>> ENTITY_TYPES = new DeferredRegisterHolder("mtr", Registry.field_239713_n_);
    private static final DeferredRegisterHolder<SoundEvent> SOUND_EVENTS = new DeferredRegisterHolder("mtr", Registry.field_239708_i_);

    public MTRForge() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ForgeUtilities.renderTickAction(MTRClient::incrementGameTick);
            ForgeUtilities.registerEntityRenderer(EntityTypes.SEAT, RenderTrains::new);
            MinecraftForge.EVENT_BUS.register(ForgeUtilities.RenderTick.class);
        });
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeUtilities.registerModEventBus("mtr", eventBus);
        eventBus.register(MTRModEventBus.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> eventBus.register(ForgeUtilities.RegisterEntityRenderer.class));
        MTR.init(MTRForge::registerItem, MTRForge::registerBlock, MTRForge::registerBlock, MTRForge::registerEnchantedBlock, MTRForge::registerBlockEntityType, MTRForge::registerEntityType, MTRForge::registerSoundEvent);
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        ENTITY_TYPES.register();
        SOUND_EVENTS.register();
    }

    private static void registerItem(String path, Item item) {
        ITEMS.register(path, () -> item);
    }

    private static void registerBlock(String path, Block block) {
        BLOCKS.register(path, () -> block);
    }

    private static void registerBlock(String path, Block block, ItemGroup itemGroup) {
        MTRForge.registerBlock(path, block);
        ITEMS.register(path, () -> new BlockItem(block, new Item.Properties().func_200916_a(itemGroup)));
    }

    private static void registerEnchantedBlock(String path, Block block, ItemGroup itemGroup) {
        MTRForge.registerBlock(path, block);
        ITEMS.register(path, () -> new ItemBlockEnchanted(block, new Item.Properties().func_200916_a(itemGroup)));
    }

    private static <T extends BlockEntityMapper> void registerBlockEntityType(String path, TileEntityType<T> blockEntityType) {
        BLOCK_ENTITY_TYPES.register(path, () -> blockEntityType);
    }

    private static <T extends Entity> void registerEntityType(String path, EntityType<T> entityType) {
        ENTITY_TYPES.register(path, () -> entityType);
    }

    private static void registerSoundEvent(String path, SoundEvent soundEvent) {
        SOUND_EVENTS.register(path, () -> soundEvent);
    }

    private static class MTRModEventBus {
        private MTRModEventBus() {
        }

        @SubscribeEvent
        public static void onClientSetupEvent(FMLClientSetupEvent event) {
            MTRClient.init();
            RegistryUtilitiesClient.registerTextureStitchEvent(textureAtlas -> {
                if (textureAtlas.func_229223_g_().func_110623_a().equals("textures/atlas/blocks.png")) {
                    CustomResources.reload(Minecraft.func_71410_x().func_195551_G());
                }
            });
        }
    }
}

