/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class BlockArrivalProjectorBase
extends HorizontalBlock
implements EntityBlockMapper {
    public BlockArrivalProjectorBase() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 5).func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityArrivalProjectorBase) {
                ((TileEntityArrivalProjectorBase)entity).syncData();
                PacketTrainDataGuiServer.openArrivalProjectorConfigScreenS2C((ServerPlayerEntity)player, pos);
            }
        });
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction side = ctx.func_196000_l();
        if (side != Direction.UP && side != Direction.DOWN) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)side.func_176734_d());
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 1.0, facing);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public static class TileEntityArrivalProjectorBase
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> platformIds = new HashSet<Long>();
        private static final String KEY_PLATFORM_IDS = "platform_ids";

        public TileEntityArrivalProjectorBase(TileEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundNBT compoundTag) {
            long[] platformIdsArray;
            for (long platformId : platformIdsArray = compoundTag.func_197645_o(KEY_PLATFORM_IDS)) {
                this.platformIds.add(platformId);
            }
        }

        @Override
        public void writeCompoundTag(CompoundNBT compoundTag) {
            compoundTag.func_202168_c(KEY_PLATFORM_IDS, new ArrayList<Long>(this.platformIds));
        }

        public Set<Long> getPlatformIds() {
            return this.platformIds;
        }

        public void setData(Set<Long> platformIds) {
            this.platformIds.clear();
            this.platformIds.addAll(platformIds);
            this.func_70296_d();
            this.syncData();
        }
    }
}

