/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.Items;
import mtr.block.IBlock;
import mtr.mappings.HorizontalBlockWithSoftLanding;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public abstract class BlockEscalatorBase
extends HorizontalBlockWithSoftLanding
implements IBlock {
    public static final EnumProperty<EnumEscalatorOrientation> ORIENTATION = EnumProperty.func_177709_a((String)"orientation", EnumEscalatorOrientation.class);

    protected BlockEscalatorBase() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_226896_b_());
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (this.getSideDirection(state) == direction && !newState.func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return (BlockState)state.func_206870_a(ORIENTATION, (Comparable)((Object)this.getOrientation((IBlockReader)world, pos, state)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext collisionContext) {
        EnumEscalatorOrientation orientation = this.getOrientation(world, pos, state);
        if (orientation == EnumEscalatorOrientation.SLOPE || orientation == EnumEscalatorOrientation.TRANSITION_TOP) {
            return VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 8.0, 0.0, 16.0, 15.0, 8.0, (Direction)IBlock.getStatePropertySafe(state, field_185512_D)));
        }
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return state;
    }

    public Item func_199767_j() {
        return Items.ESCALATOR;
    }

    public ItemStack func_185473_a(IBlockReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((IItemProvider)this.func_199767_j());
    }

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected final EnumEscalatorOrientation getOrientation(IBlockReader world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        BlockPos posAhead = pos.func_177972_a(facing);
        BlockPos posBehind = pos.func_177967_a(facing, -1);
        boolean isAhead = state.func_203425_a(world.func_180495_p(posAhead).func_177230_c());
        boolean isAheadUp = state.func_203425_a(world.func_180495_p(posAhead.func_177984_a()).func_177230_c());
        boolean isBehind = state.func_203425_a(world.func_180495_p(posBehind).func_177230_c());
        boolean isBehindDown = state.func_203425_a(world.func_180495_p(posBehind.func_177977_b()).func_177230_c());
        if (isAhead && isBehind) {
            return EnumEscalatorOrientation.FLAT;
        }
        if (isAheadUp && isBehindDown) {
            return EnumEscalatorOrientation.SLOPE;
        }
        if (isAheadUp && isBehind) {
            return EnumEscalatorOrientation.TRANSITION_BOTTOM;
        }
        if (isAhead && isBehindDown) {
            return EnumEscalatorOrientation.TRANSITION_TOP;
        }
        if (isBehind) {
            return EnumEscalatorOrientation.LANDING_TOP;
        }
        return EnumEscalatorOrientation.LANDING_BOTTOM;
    }

    @Override
    private Direction getSideDirection(BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        return IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT ? facing.func_176735_f() : facing.func_176746_e();
    }

    protected static enum EnumEscalatorOrientation implements IStringSerializable
    {
        LANDING_BOTTOM("landing_bottom"),
        LANDING_TOP("landing_top"),
        FLAT("flat"),
        SLOPE("slope"),
        TRANSITION_BOTTOM("transition_bottom"),
        TRANSITION_TOP("transition_top");

        private final String name;

        private EnumEscalatorOrientation(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

