/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockEscalatorBase;
import mtr.block.BlockEscalatorSide;
import mtr.block.IBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockEscalatorStep
extends BlockEscalatorBase {
    public static final BooleanProperty DIRECTION = BooleanProperty.func_177716_a((String)"direction");

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (direction == Direction.UP && !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockEscalatorSide)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, newState, world, pos, posFrom);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.func_177972_a(IBlock.getSideDirection(state)));
        }
        super.func_176208_a(world, pos, state, player);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        BlockEscalatorBase.EnumEscalatorOrientation orientation = (BlockEscalatorBase.EnumEscalatorOrientation)((Object)IBlock.getStatePropertySafe(state, ORIENTATION));
        if (orientation == BlockEscalatorBase.EnumEscalatorOrientation.FLAT || orientation == BlockEscalatorBase.EnumEscalatorOrientation.TRANSITION_BOTTOM) {
            return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
        }
        return VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)super.func_220071_b(state, world, pos, context), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    public void func_196262_a(BlockState state, World level, BlockPos pos, Entity entity) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        boolean direction = (Boolean)IBlock.getStatePropertySafe(state, DIRECTION);
        float speed = 0.1f;
        switch (facing) {
            case NORTH: {
                entity.func_70024_g(0.0, 0.0, direction ? (double)-0.1f : (double)0.1f);
                break;
            }
            case EAST: {
                entity.func_70024_g(direction ? (double)0.1f : (double)-0.1f, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                entity.func_70024_g(0.0, 0.0, direction ? (double)0.1f : (double)-0.1f);
                break;
            }
            case WEST: {
                entity.func_70024_g(direction ? (double)-0.1f : (double)0.1f, 0.0, 0.0);
                break;
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean direction = (Boolean)IBlock.getStatePropertySafe(state, DIRECTION) == false;
            Direction blockFacing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            this.update(world, pos, blockFacing, direction);
            this.update(world, pos, blockFacing.func_176734_d(), direction);
            BlockPos sidePos = pos.func_177972_a(IBlock.getSideDirection(state));
            if (this.isStep(world, sidePos)) {
                BlockEscalatorStep block = (BlockEscalatorStep)world.func_180495_p(sidePos).func_177230_c();
                block.update(world, sidePos, blockFacing, direction);
                block.update(world, sidePos, blockFacing.func_176734_d(), direction);
            }
        });
    }

    @Override
    public boolean softenLanding() {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, DIRECTION, ORIENTATION, SIDE});
    }

    private void update(World world, BlockPos pos, Direction offset, boolean direction) {
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)DIRECTION, (Comparable)Boolean.valueOf(direction)));
        BlockPos offsetPos = pos.func_177972_a(offset);
        if (this.isStep(world, offsetPos)) {
            this.update(world, offsetPos, offset, direction);
        }
        if (this.isStep(world, offsetPos.func_177984_a())) {
            this.update(world, offsetPos.func_177984_a(), offset, direction);
        }
        if (this.isStep(world, offsetPos.func_177977_b())) {
            this.update(world, offsetPos.func_177977_b(), offset, direction);
        }
    }

    private boolean isStep(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockEscalatorStep;
    }
}

