/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.block.IBlock;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockNode
extends HorizontalBlock {
    public final TransportMode transportMode;
    public static final BooleanProperty FACING = BooleanProperty.func_177716_a((String)"facing");
    public static final BooleanProperty IS_22_5 = BooleanProperty.func_177716_a((String)"is_22_5");
    public static final BooleanProperty IS_45 = BooleanProperty.func_177716_a((String)"is_45");
    public static final BooleanProperty IS_CONNECTED = BooleanProperty.func_177716_a((String)"is_connected");

    public BlockNode(TransportMode transportMode) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(2.0f).func_226896_b_());
        this.transportMode = transportMode;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)IS_22_5, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)IS_45, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        int quadrant = RailAngle.getQuadrant(ctx.func_195990_h());
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Boolean.valueOf(quadrant % 8 >= 4))).func_206870_a((Property)IS_45, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).func_206870_a((Property)IS_22_5, (Comparable)Boolean.valueOf(quadrant % 2 >= 1))).func_206870_a((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        RailwayData railwayData;
        if (!world.field_72995_K && (railwayData = RailwayData.getInstance(world)) != null) {
            railwayData.removeNode(pos);
            PacketTrainDataGuiServer.removeNodeS2C(world, pos);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        return (Boolean)IBlock.getStatePropertySafe(state, IS_CONNECTED) != false ? Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0) : VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, IS_22_5, IS_45, IS_CONNECTED});
    }

    public static void resetRailNode(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockNode) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static float getAngle(BlockState state) {
        return (float)((Boolean)IBlock.getStatePropertySafe(state, FACING) != false ? 0 : 90) + ((Boolean)IBlock.getStatePropertySafe(state, IS_22_5) != false ? 22.5f : 0.0f) + (float)((Boolean)IBlock.getStatePropertySafe(state, IS_45) != false ? 45 : 0);
    }

    public static class TileEntityBoatNode
    extends BlockEntityMapper {
        public TileEntityBoatNode(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.BOAT_NODE_TILE_ENTITY, pos, state);
        }
    }

    public static class BlockBoatNode
    extends BlockNode
    implements EntityBlockMapper {
        public BlockBoatNode() {
            super(TransportMode.BOAT);
        }

        public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
            if (state.func_196955_c((IWorldReader)world, pos)) {
                return state;
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
            BlockPos posBelow = pos.func_177977_b();
            return (world.func_204610_c(posBelow).func_206886_c() != Fluids.field_204541_a || world.func_180495_p(posBelow).func_185904_a() == Material.field_151588_w) && world.func_204610_c(pos).func_206886_c() == Fluids.field_204541_a;
        }

        @Override
        public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
            return new TileEntityBoatNode(pos, state);
        }
    }
}

