/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class BlockPIDSBase
extends HorizontalBlock
implements EntityBlockMapper {
    public BlockPIDSBase() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 5));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockPos otherPos = pos.func_177972_a((Direction)IBlock.getStatePropertySafe(state, field_185512_D));
            TileEntity entity1 = world.func_175625_s(pos);
            TileEntity entity2 = world.func_175625_s(otherPos);
            if (entity1 instanceof TileEntityBlockPIDSBase && entity2 instanceof TileEntityBlockPIDSBase) {
                ((TileEntityBlockPIDSBase)entity1).syncData();
                ((TileEntityBlockPIDSBase)entity2).syncData();
                PacketTrainDataGuiServer.openPIDSConfigScreenS2C((ServerPlayerEntity)player, pos, otherPos, ((TileEntityBlockPIDSBase)entity1).getMaxArrivals());
            }
        });
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (IBlock.getStatePropertySafe(state, field_185512_D) == direction && !newState.func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction direction = ctx.func_195992_f().func_176734_d();
        return IBlock.isReplaceable(ctx, direction, 2) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        if (facing == Direction.SOUTH || facing == Direction.WEST) {
            IBlock.onBreakCreative(world, player, pos.func_177972_a(facing));
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.field_72995_K) {
            Direction direction = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            world.func_180501_a(pos.func_177972_a(direction), (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction.func_176734_d()), 3);
            world.func_195593_d(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
            TileEntity entity1 = world.func_175625_s(pos);
            TileEntity entity2 = world.func_175625_s(pos.func_177972_a(direction));
            if (entity1 instanceof TileEntityBlockPIDSBase && entity2 instanceof TileEntityBlockPIDSBase) {
                System.arraycopy(((TileEntityBlockPIDSBase)entity1).messages, 0, ((TileEntityBlockPIDSBase)entity2).messages, 0, Math.min(((TileEntityBlockPIDSBase)entity1).messages.length, ((TileEntityBlockPIDSBase)entity2).messages.length));
            }
        }
    }

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public static abstract class TileEntityBlockPIDSBase
    extends BlockEntityClientSerializableMapper {
        private final String[] messages = new String[this.getMaxArrivals()];
        private final boolean[] hideArrival = new boolean[this.getMaxArrivals()];
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_HIDE_ARRIVAL = "hide_arrival";

        public TileEntityBlockPIDSBase(TileEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundNBT compoundTag) {
            for (int i = 0; i < this.getMaxArrivals(); ++i) {
                this.messages[i] = compoundTag.func_74779_i(KEY_MESSAGE + i);
                this.hideArrival[i] = compoundTag.func_74767_n(KEY_HIDE_ARRIVAL + i);
            }
        }

        @Override
        public void writeCompoundTag(CompoundNBT compoundTag) {
            for (int i = 0; i < this.getMaxArrivals(); ++i) {
                compoundTag.func_74778_a(KEY_MESSAGE + i, this.messages[i] == null ? "" : this.messages[i]);
                compoundTag.func_74757_a(KEY_HIDE_ARRIVAL + i, this.hideArrival[i]);
            }
        }

        public void setData(String[] messages, boolean[] hideArrival) {
            System.arraycopy(messages, 0, this.messages, 0, Math.min(messages.length, this.messages.length));
            System.arraycopy(hideArrival, 0, this.hideArrival, 0, Math.min(hideArrival.length, this.hideArrival.length));
            this.func_70296_d();
            this.syncData();
        }

        public String getMessage(int index) {
            if (index >= 0 && index < this.getMaxArrivals()) {
                if (this.messages[index] == null) {
                    this.messages[index] = "";
                }
                return this.messages[index];
            }
            return "";
        }

        public boolean getHideArrival(int index) {
            if (index >= 0 && index < this.getMaxArrivals()) {
                return this.hideArrival[index];
            }
            return false;
        }

        protected abstract int getMaxArrivals();
    }
}

