/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDAPGGlassBase;
import mtr.block.IBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public abstract class BlockPSDAPGGlassEndBase
extends BlockPSDAPGGlassBase {
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_LEFT = EnumProperty.func_177709_a((String)"touching_left", EnumPSDAPGGlassEndSide.class);
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_RIGHT = EnumProperty.func_177709_a((String)"touching_right", EnumPSDAPGGlassEndSide.class);

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        BlockState superState = super.func_196271_a(state, direction, newState, world, pos, posFrom);
        if (superState.func_177230_c() == Blocks.field_150350_a) {
            return superState;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        EnumPSDAPGGlassEndSide touchingLeft = this.getSideEnd(world, pos, facing.func_176735_f());
        EnumPSDAPGGlassEndSide touchingRight = this.getSideEnd(world, pos, facing.func_176746_e());
        return (BlockState)((BlockState)superState.func_206870_a(TOUCHING_LEFT, (Comparable)((Object)touchingLeft))).func_206870_a(TOUCHING_RIGHT, (Comparable)((Object)touchingRight));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape superShape = super.func_220053_a(state, world, pos, context);
        int height = this.isAPG() && IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER ? 9 : 16;
        boolean leftAir = IBlock.getStatePropertySafe(state, TOUCHING_LEFT) == EnumPSDAPGGlassEndSide.AIR;
        boolean rightAir = IBlock.getStatePropertySafe(state, TOUCHING_RIGHT) == EnumPSDAPGGlassEndSide.AIR;
        return BlockPSDAPGGlassEndBase.getEndOutlineShape(superShape, state, height, 4, leftAir, rightAir);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, HALF, SIDE_EXTENDED, TOUCHING_LEFT, TOUCHING_RIGHT});
    }

    private EnumPSDAPGGlassEndSide getSideEnd(IWorld world, BlockPos pos, Direction offset) {
        BlockPos checkPos = pos.func_177972_a(offset);
        if (world.func_180495_p(checkPos).func_177230_c() instanceof BlockPSDAPGDoorBase) {
            return EnumPSDAPGGlassEndSide.DOOR;
        }
        if (world.func_180495_p(checkPos).func_177230_c() instanceof BlockPSDAPGBase) {
            return EnumPSDAPGGlassEndSide.NONE;
        }
        return EnumPSDAPGGlassEndSide.AIR;
    }

    public static VoxelShape getEndOutlineShape(VoxelShape baseShape, BlockState state, int height, int thickness, boolean leftAir, boolean rightAir) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        if (facing == Direction.NORTH && leftAir || facing == Direction.SOUTH && rightAir) {
            baseShape = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)height, (double)16.0));
        }
        if (facing == Direction.EAST && leftAir || facing == Direction.WEST && rightAir) {
            baseShape = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)thickness));
        }
        if (facing == Direction.SOUTH && leftAir || facing == Direction.NORTH && rightAir) {
            baseShape = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)Block.func_208617_a((double)(16 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0));
        }
        if (facing == Direction.WEST && leftAir || facing == Direction.EAST && rightAir) {
            baseShape = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)(16 - thickness), (double)16.0, (double)height, (double)16.0));
        }
        return baseShape;
    }

    public static enum EnumPSDAPGGlassEndSide implements IStringSerializable
    {
        AIR("air"),
        DOOR("door"),
        NONE("none");

        private final String name;

        private EnumPSDAPGGlassEndSide(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

