/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.Items;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockPSDTop
extends HorizontalBlock
implements EntityBlockMapper,
IBlock {
    private static final float PERSISTENT_OFFSET = 7.5f;
    public static final float PERSISTENT_OFFSET_SMALL = 0.46875f;
    public static final EnumProperty<EnumDoorLight> DOOR_LIGHT = EnumProperty.func_177709_a((String)"door_light", EnumDoorLight.class);
    public static final BooleanProperty AIR_LEFT = BooleanProperty.func_177716_a((String)"air_left");
    public static final BooleanProperty AIR_RIGHT = BooleanProperty.func_177716_a((String)"air_right");
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.func_177719_a((String)"propagate_property", (int)0, (int)3);
    public static final EnumProperty<EnumPersistent> PERSISTENT = EnumProperty.func_177709_a((String)"persistent", EnumPersistent.class);

    public BlockPSDTop() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151677_p).func_235861_h_().func_200943_b(2.0f).func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingItem(world, player, item -> {
            if (item == Items.BRUSH) {
                world.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)ARROW_DIRECTION));
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176746_e(), (Property)ARROW_DIRECTION, 1);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176735_f(), (Property)ARROW_DIRECTION, 1);
            } else {
                boolean shouldBePersistent = IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE;
                this.setState(world, pos, shouldBePersistent);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176746_e(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176735_f(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
            }
        }, null, Items.BRUSH, net.minecraft.item.Items.field_151097_aZ);
    }

    private void setState(World world, BlockPos pos, boolean shouldBePersistent) {
        Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDGlassEnd) {
            if (shouldBePersistent) {
                world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a(PERSISTENT, (Comparable)((Object)(blockBelow instanceof BlockPSDDoor ? EnumPersistent.ARROW : (blockBelow instanceof BlockPSDGlass ? EnumPersistent.ROUTE : EnumPersistent.BLANK)))));
            } else {
                world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a(PERSISTENT, (Comparable)((Object)EnumPersistent.NONE)));
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return state;
    }

    public Item func_199767_j() {
        return Items.PSD_GLASS_1;
    }

    public ItemStack func_185473_a(IBlockReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((IItemProvider)this.func_199767_j());
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockDown instanceof BlockPSDAPGBase) {
            blockDown.func_176208_a(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), player);
            world.func_175656_a(pos.func_177977_b(), net.minecraft.block.Blocks.field_150350_a.func_176223_P());
        }
        super.func_176208_a(world, pos, state, player);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (direction == Direction.DOWN && IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE && !(newState.func_177230_c() instanceof BlockPSDAPGBase)) {
            return net.minecraft.block.Blocks.field_150350_a.func_176223_P();
        }
        return BlockPSDTop.getActualState((IBlockReader)world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        VoxelShape baseShape = IBlock.getVoxelShapeByDirection(0.0, IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE ? 0.0 : 7.5, 0.0, 16.0, 16.0, 6.0, (Direction)IBlock.getStatePropertySafe(state, field_185512_D));
        boolean airLeft = (Boolean)IBlock.getStatePropertySafe(state, AIR_LEFT);
        boolean airRight = (Boolean)IBlock.getStatePropertySafe(state, AIR_RIGHT);
        if (airLeft || airRight) {
            return BlockPSDAPGGlassEndBase.getEndOutlineShape(baseShape, state, 16, 6, airLeft, airRight);
        }
        return baseShape;
    }

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DOOR_LIGHT, field_185512_D, SIDE_EXTENDED, AIR_LEFT, AIR_RIGHT, ARROW_DIRECTION, PERSISTENT});
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityPSDTop(pos, state);
    }

    public static BlockState getActualState(IBlockReader world, BlockPos pos) {
        BlockState oldState;
        EnumDoorLight doorLight = EnumDoorLight.NONE;
        Direction facing = null;
        IBlock.EnumSide side = null;
        boolean airLeft = false;
        boolean airRight = false;
        BlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        Block blockBelow = stateBelow.func_177230_c();
        if (blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlassEnd) {
            if (blockBelow instanceof BlockPSDDoor) {
                doorLight = (Integer)IBlock.getStatePropertySafe(stateBelow, BlockPSDDoor.OPEN) > 0 ? EnumDoorLight.ON : EnumDoorLight.OFF;
                side = (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE));
            } else {
                side = (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE_EXTENDED));
            }
            if (blockBelow instanceof BlockPSDGlassEnd) {
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_LEFT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airLeft = true;
                }
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_RIGHT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airRight = true;
                }
            }
            facing = (Direction)IBlock.getStatePropertySafe(stateBelow, field_185512_D);
        }
        BlockState newState = (BlockState)((BlockState)((BlockState)((oldState = world.func_180495_p(pos)).func_177230_c() instanceof BlockPSDTop ? oldState : Blocks.PSD_TOP.func_176223_P()).func_206870_a(DOOR_LIGHT, (Comparable)((Object)doorLight))).func_206870_a((Property)AIR_LEFT, (Comparable)Boolean.valueOf(airLeft))).func_206870_a((Property)AIR_RIGHT, (Comparable)Boolean.valueOf(airRight));
        if (facing != null) {
            newState = (BlockState)newState.func_206870_a((Property)field_185512_D, (Comparable)facing);
        }
        if (side != null) {
            newState = (BlockState)newState.func_206870_a((Property)SIDE_EXTENDED, (Comparable)((Object)side));
        }
        return newState;
    }

    public static enum EnumPersistent implements IStringSerializable
    {
        NONE("none"),
        ARROW("arrow"),
        ROUTE("route"),
        BLANK("blank");

        private final String name;

        private EnumPersistent(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static class TileEntityPSDTop
    extends BlockEntityMapper {
        public TileEntityPSDTop(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.PSD_TOP_TILE_ENTITY, pos, state);
        }
    }

    public static enum EnumDoorLight implements IStringSerializable
    {
        ON("on"),
        OFF("off"),
        NONE("none");

        private final String name;

        private EnumDoorLight(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

