/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockAPGDoor;
import mtr.block.BlockAPGGlass;
import mtr.block.BlockAPGGlassEnd;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class BlockPlatform
extends HorizontalBlock {
    private final boolean isIndented;
    public static final EnumProperty<EnumDoorType> DOOR_TYPE = EnumProperty.func_177709_a((String)"door_type", EnumDoorType.class);
    public static final IntegerProperty SIDE = IntegerProperty.func_177719_a((String)"side", (int)0, (int)4);

    public BlockPlatform(AbstractBlock.Properties settings, boolean isIndented) {
        super(settings);
        this.isIndented = isIndented;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(DOOR_TYPE, (Comparable)((Object)EnumDoorType.NONE)));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        return this.getActualState((IBlockReader)world, pos, state);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (this.isIndented) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            return VoxelShapes.func_197872_a((VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 0.0, 6.0, 16.0, 13.0, 16.0, facing), (VoxelShape)Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        }
        return super.func_220053_a(state, world, pos, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, DOOR_TYPE, SIDE});
    }

    private BlockState getActualState(IBlockReader world, BlockPos pos, BlockState state) {
        int side;
        EnumDoorType doorType;
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        BlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        Block blockAbove = stateAbove.func_177230_c();
        if (blockAbove instanceof BlockPSDDoor || blockAbove instanceof BlockPSDGlass || blockAbove instanceof BlockPSDGlassEnd) {
            doorType = EnumDoorType.PSD;
            facing = (Direction)IBlock.getStatePropertySafe(stateAbove, field_185512_D);
        } else if (blockAbove instanceof BlockAPGDoor || blockAbove instanceof BlockAPGGlass || blockAbove instanceof BlockAPGGlassEnd) {
            doorType = EnumDoorType.APG;
            facing = (Direction)IBlock.getStatePropertySafe(stateAbove, field_185512_D);
        } else {
            doorType = EnumDoorType.NONE;
        }
        boolean aboveIsDoor = blockAbove instanceof BlockPSDAPGDoorBase;
        BlockState stateLeftAbove = world.func_180495_p(pos.func_177984_a().func_177972_a(facing.func_176735_f()));
        boolean leftAboveIsDoor = stateLeftAbove.func_177230_c() instanceof BlockPSDAPGDoorBase;
        BlockState stateRightAbove = world.func_180495_p(pos.func_177984_a().func_177972_a(facing.func_176746_e()));
        boolean rightAboveIsDoor = stateRightAbove.func_177230_c() instanceof BlockPSDAPGDoorBase;
        if (aboveIsDoor && rightAboveIsDoor) {
            side = 2;
        } else if (aboveIsDoor && leftAboveIsDoor) {
            side = 3;
        } else if (rightAboveIsDoor) {
            side = 1;
            facing = (Direction)IBlock.getStatePropertySafe(stateRightAbove, field_185512_D);
        } else if (leftAboveIsDoor) {
            side = 4;
            facing = (Direction)IBlock.getStatePropertySafe(stateLeftAbove, field_185512_D);
        } else {
            side = 0;
        }
        return (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a(DOOR_TYPE, (Comparable)((Object)doorType))).func_206870_a((Property)SIDE, (Comparable)Integer.valueOf(side));
    }

    private static enum EnumDoorType implements IStringSerializable
    {
        NONE("none"),
        PSD("psd"),
        APG("apg");

        private final String name;

        private EnumDoorType(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

