/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockRailwaySign
extends HorizontalBlock
implements EntityBlockMapper,
IBlock {
    public final int length;
    public final boolean isOdd;
    public static final float SMALL_SIGN_PERCENTAGE = 0.75f;

    public BlockRailwaySign(int length, boolean isOdd) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 15));
        this.length = length;
        this.isOdd = isOdd;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockPos checkPos;
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            Direction hitSide = hit.func_216354_b();
            if ((hitSide == facing || hitSide == facing.func_176734_d()) && (checkPos = this.findEndWithDirection(world, pos, hitSide.func_176734_d(), false)) != null) {
                PacketTrainDataGuiServer.openRailwaySignScreenS2C((ServerPlayerEntity)player, checkPos);
            }
        });
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        boolean isNext;
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        boolean bl = isNext = direction == facing.func_176746_e() || state.func_203425_a(Blocks.RAILWAY_SIGN_MIDDLE) && direction == facing.func_176735_f();
        if (isNext && !(newState.func_177230_c() instanceof BlockRailwaySign)) {
            return net.minecraft.block.Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction facing = ctx.func_195992_f();
        return IBlock.isReplaceable(ctx, facing.func_176746_e(), this.getMiddleLength() + 2) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing) : null;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        BlockPos checkPos = this.findEndWithDirection(world, pos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative(world, player, checkPos);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.field_72995_K) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            for (int i = 1; i <= this.getMiddleLength(); ++i) {
                world.func_180501_a(pos.func_177967_a(facing.func_176746_e(), i), (BlockState)Blocks.RAILWAY_SIGN_MIDDLE.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing), 3);
            }
            world.func_180501_a(pos.func_177967_a(facing.func_176746_e(), this.getMiddleLength() + 1), (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing.func_176734_d()), 3);
            world.func_195593_d(pos, net.minecraft.block.Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        if (state.func_203425_a(Blocks.RAILWAY_SIGN_MIDDLE)) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 7.0, 16.0, 12.0, 9.0, facing);
        }
        int xStart = this.getXStart();
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)xStart - 0.75, 0.0, 7.0, 16.0, 12.0, 9.0, facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection(xStart - 2, 0.0, 7.0, (double)xStart - 0.75, 16.0, 9.0, facing);
        return VoxelShapes.func_197872_a((VoxelShape)main, (VoxelShape)pole);
    }

    public String func_149739_a() {
        return "block.mtr.railway_sign";
    }

    public void func_190948_a(ItemStack itemStack, IBlockReader blockGetter, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.railway_sign_length", new Object[]{this.length}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        if (this == Blocks.RAILWAY_SIGN_MIDDLE) {
            return null;
        }
        return new TileEntityRailwaySign(this.length, this.isOdd, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public int getXStart() {
        switch (this.length % 4) {
            default: {
                return this.isOdd ? 8 : 16;
            }
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: 
        }
        return this.isOdd ? 12 : 4;
    }

    private int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    private BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        int i = 0;
        while (true) {
            BlockPos checkPos;
            BlockState checkState;
            if ((checkState = world.func_180495_p(checkPos = startPos.func_177967_a(direction.func_176735_f(), i))).func_177230_c() instanceof BlockRailwaySign) {
                Direction facing = (Direction)IBlock.getStatePropertySafe(checkState, field_185512_D);
                if (!checkState.func_203425_a(Blocks.RAILWAY_SIGN_MIDDLE) && (facing == direction || allowOpposite && facing == direction.func_176734_d())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static class TileEntityRailwaySign
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> selectedIds;
        private final String[] signIds;
        private static final String KEY_SELECTED_IDS = "selected_ids";
        private static final String KEY_SIGN_LENGTH = "sign_length";

        public TileEntityRailwaySign(int length, boolean isOdd, BlockPos pos, BlockState state) {
            super(TileEntityRailwaySign.getType(length, isOdd), pos, state);
            this.signIds = new String[length];
            this.selectedIds = new HashSet<Long>();
        }

        @Override
        public void readCompoundTag(CompoundNBT compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.func_197645_o(KEY_SELECTED_IDS)).forEach(this.selectedIds::add);
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.func_74779_i(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId;
            }
        }

        @Override
        public void writeCompoundTag(CompoundNBT compoundTag) {
            compoundTag.func_202168_c(KEY_SELECTED_IDS, new ArrayList<Long>(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.func_74778_a(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public void setData(Set<Long> selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll(selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.func_70296_d();
            this.syncData();
        }

        public Set<Long> getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }

        private static TileEntityType<?> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_2_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_2_EVEN_TILE_ENTITY;
                }
                case 3: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_3_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_3_EVEN_TILE_ENTITY;
                }
                case 4: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_4_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_4_EVEN_TILE_ENTITY;
                }
                case 5: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_5_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_5_EVEN_TILE_ENTITY;
                }
                case 6: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_6_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_6_EVEN_TILE_ENTITY;
                }
                case 7: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_7_ODD_TILE_ENTITY : BlockEntityTypes.RAILWAY_SIGN_7_EVEN_TILE_ENTITY;
                }
            }
            return null;
        }
    }

    public static enum SignType {
        ARROW_LEFT("arrow", true, false),
        ARROW_RIGHT("arrow", true, true),
        ARROW_UP("arrow_up", true, false),
        ARROW_DOWN("arrow_down", true, false),
        ARROW_UP_LEFT("arrow_up_left", true, false),
        ARROW_UP_RIGHT("arrow_up_left", true, true),
        ARROW_DOWN_LEFT("arrow_down_left", true, false),
        ARROW_DOWN_RIGHT("arrow_down_left", true, true),
        ARROW_TURN_BACK_LEFT("arrow_turn_back", true, false),
        ARROW_TURN_BACK_RIGHT("arrow_turn_back", true, true),
        EXIT_1("exit_1", false, false),
        EXIT_2("exit_2", true, false),
        EXIT_3("exit_3", true, false),
        ESCALATOR("escalator", true, false),
        ESCALATOR_FLIPPED("escalator", true, true),
        STAIRS_UP("stairs_up", true, false),
        STAIRS_UP_FLIPPED("stairs_up", true, true),
        STAIRS_DOWN_FLIPPED("stairs_down", true, true),
        STAIRS_DOWN("stairs_down", true, false),
        LIFT_1("lift_1", true, false),
        LIFT_2("lift_2", true, false),
        WHEELCHAIR("wheelchair", true, false),
        TOILET("toilets", false, false),
        FEMALE("female", true, false),
        MALE("male", true, false),
        TRAIN("train", true, false),
        TRAIN_OLD("train_old", true, false),
        AIRPORT_EXPRESS("airport_express", true, false),
        LIGHT_RAIL_1("light_rail_1", true, false),
        LIGHT_RAIL_2("light_rail_2", false, false),
        LIGHT_RAIL_3("light_rail_3", true, false),
        LIGHT_RAIL_4("light_rail_4", false, false),
        XRL_1("xrl_1", true, false),
        XRL_2("xrl_2", true, false),
        SP1900("sp1900", true, false),
        YELLOW_HEAD_1("yellow_head_1", true, false),
        YELLOW_HEAD_2("yellow_head_2", false, false),
        BOAT("boat", true, false),
        CROSS("cross", true, false),
        LOGO("logo", false, false),
        EXIT_LETTER("exit_letter", true, false, true),
        EXIT_LETTER_FLIPPED("exit_letter", true, true, true),
        ESCALATOR_TO_CONCOURSE_UP("escalator", "escalator_to_concourse_up", true, true, false, true, 0),
        ESCALATOR_TO_CONCOURSE_UP_FLIPPED("escalator", "escalator_to_concourse_up", true, false, true, true, 0),
        ESCALATOR_TO_CONCOURSE_DOWN("escalator", "escalator_to_concourse_down", true, false, false, true, 0),
        ESCALATOR_TO_CONCOURSE_DOWN_FLIPPED("escalator", "escalator_to_concourse_down", true, true, true, true, 0),
        PLATFORM("platform", true, false, true),
        PLATFORM_FLIPPED("platform", true, true, true),
        LINE("line", true, false, true),
        LINE_FLIPPED("line", true, true, true),
        LIFT_1_TEXT("lift_1", true, false, true),
        LIFT_1_TEXT_FLIPPED("lift_1", true, true, true),
        LIFT_2_TEXT("lift_2", true, false, true),
        LIFT_2_TEXT_FLIPPED("lift_2", true, true, true),
        TOILETS("toilets", false, false, true),
        TOILETS_FLIPPED("toilets", false, true, true),
        FEMALE_TOILETS("female", true, false, true),
        FEMALE_TOILETS_FLIPPED("female", true, true, true),
        MALE_TOILETS("male", true, false, true),
        MALE_TOILETS_FLIPPED("male", true, true, true),
        WHEELCHAIR_TOILETS("wheelchair", true, false, true),
        WHEELCHAIR_TOILETS_FLIPPED("wheelchair", true, true, true),
        TRAINS("train", true, false, true),
        TRAINS_FLIPPED("train", true, true, true),
        TRAINS_OLD("train_old", true, false, true),
        TRAINS_OLD_FLIPPED("train_old", true, true, true),
        AIRPORT_EXPRESS_TRAINS("airport_express", true, false, true),
        AIRPORT_EXPRESS_TRAINS_FLIPPED("airport_express", true, true, true),
        AIRPORT_EXPRESS_TRAINS_CITY("airport_express", "airport_express_city", true, false, true),
        AIRPORT_EXPRESS_TRAINS_CITY_FLIPPED("airport_express", "airport_express_city", true, true, true),
        IN_TOWN_CHECK_IN("check_in", "in_town_check_in", true, false, true),
        IN_TOWN_CHECK_IN_FLIPPED("check_in", "in_town_check_in", true, true, true),
        CHECK_IN_PASSENGERS("check_in", "check_in_passengers", true, false, true),
        CHECK_IN_PASSENGERS_FLIPPED("check_in", "check_in_passengers", true, true, true),
        LIGHT_RAIL_1_TRAINS("light_rail_1", true, false, true),
        LIGHT_RAIL_1_TRAINS_FLIPPED("light_rail_1", true, true, true),
        LIGHT_RAIL_2_TRAINS("light_rail_2", false, false, true),
        LIGHT_RAIL_2_TRAINS_FLIPPED("light_rail_2", false, true, true),
        LIGHT_RAIL_3_TRAINS("light_rail_3", true, false, true),
        LIGHT_RAIL_3_TRAINS_FLIPPED("light_rail_3", true, true, true),
        LIGHT_RAIL_4_TRAINS("light_rail_4", false, false, true),
        LIGHT_RAIL_4_TRAINS_FLIPPED("light_rail_4", false, true, true),
        XRL_1_TRAINS("xrl_1", true, false, true),
        XRL_1_TRAINS_FLIPPED("xrl_1", true, true, true),
        XRL_2_TRAINS("xrl_2", true, false, true),
        XRL_2_TRAINS_FLIPPED("xrl_2", true, true, true),
        SP1900_TRAINS("sp1900", true, false, true),
        SP1900_TRAINS_FLIPPED("sp1900", true, true, true),
        YELLOW_HEAD_1_TRAINS("yellow_head_1", true, false, true),
        YELLOW_HEAD_1_TRAINS_FLIPPED("yellow_head_1", true, true, true),
        YELLOW_HEAD_2_TRAINS("yellow_head_2", false, false, true),
        YELLOW_HEAD_2_TRAINS_FLIPPED("yellow_head_2", false, true, true),
        BOAT_BOATS("boat", true, false, true),
        BOAT_BOATS_FLIPPED("boat", true, true, true),
        CUSTOMER_SERVICE_CENTRE("customer_service_centre", true, false, true),
        CUSTOMER_SERVICE_CENTRE_FLIPPED("customer_service_centre", true, true, true),
        TICKETS("tickets", true, false, true),
        TICKETS_FLIPPED("tickets", true, true, true),
        NO_ENTRY("cross", true, false, true),
        NO_ENTRY_FLIPPED("cross", true, true, true),
        EMERGENCY_EXIT("emergency_exit", "emergency_exit", false, false, false, true, 37967),
        EMERGENCY_EXIT_FLIPPED("emergency_exit", "emergency_exit", false, true, true, true, 37967),
        WIFI("wifi", "wifi", true, false, false, true, 16415522),
        WIFI_FLIPPED("wifi", "wifi", true, true, true, true, 16415522),
        LOGO_TEXT("logo", false, false, true),
        LOGO_TEXT_FLIPPED("logo", false, true, true);

        public final ResourceLocation textureId;
        public final String customText;
        public final boolean small;
        public final boolean flipTexture;
        public final boolean flipCustomText;
        public final int backgroundColor;

        private SignType(String texture, String translation, boolean small, boolean flipTexture, boolean flipCustomText, boolean hasCustomText, int backgroundColor) {
            this.textureId = new ResourceLocation("mtr:textures/sign/" + texture + ".png");
            this.customText = hasCustomText ? new TranslationTextComponent("sign.mtr." + translation + "_cjk").func_240702_b_("|").func_230529_a_((ITextComponent)new TranslationTextComponent("sign.mtr." + translation)).getString() : "";
            this.small = small;
            this.flipTexture = flipTexture;
            this.flipCustomText = flipCustomText;
            this.backgroundColor = backgroundColor;
        }

        private SignType(String texture, String translation, boolean small, boolean flipTexture, boolean hasCustomText) {
            this(texture, translation, small, false, flipTexture, hasCustomText, 0);
        }

        private SignType(String texture, boolean small, boolean flipCustomText, boolean hasCustomText) {
            this(texture, texture, small, false, flipCustomText, hasCustomText, 0);
        }

        private SignType(String texture, boolean small, boolean flipTexture) {
            this(texture, texture, small, flipTexture, false, false, 0);
        }
    }
}

