/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public abstract class BlockRouteSignBase
extends BlockDirectionalDoubleBlockBase
implements EntityBlockMapper,
IBlock {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.func_177719_a((String)"propagate_property", (int)0, (int)3);

    public BlockRouteSignBase() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 15).func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult hit) {
        double y = hit.func_216347_e().field_72448_b;
        boolean isUpper = IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER;
        return IBlock.checkHoldingBrush(world, player, () -> {
            if (isUpper && y - Math.floor(y) > 0.8125) {
                world.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)ARROW_DIRECTION));
                this.propagate(world, pos, Direction.DOWN, (Property)ARROW_DIRECTION, 1);
            } else {
                TileEntity entity = world.func_175625_s(pos.func_177979_c(isUpper ? 1 : 0));
                if (entity instanceof TileEntityRouteSignBase) {
                    PacketTrainDataGuiServer.openRailwaySignScreenS2C((ServerPlayerEntity)player, entity.func_174877_v());
                }
            }
        });
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, HALF, ARROW_DIRECTION});
    }

    public static abstract class TileEntityRouteSignBase
    extends BlockEntityClientSerializableMapper {
        private long platformId;
        private static final String KEY_PLATFORM_ID = "platform_id";

        public TileEntityRouteSignBase(TileEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundNBT compoundTag) {
            this.platformId = compoundTag.func_74763_f(KEY_PLATFORM_ID);
        }

        @Override
        public void writeCompoundTag(CompoundNBT compoundTag) {
            compoundTag.func_74772_a(KEY_PLATFORM_ID, this.platformId);
        }

        public void setPlatformId(long platformId) {
            this.platformId = platformId;
            this.func_70296_d();
            this.syncData();
        }

        public long getPlatformId() {
            return this.platformId;
        }
    }
}

