/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityMapper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockStationNameEntrance
extends BlockStationNameBase
implements IBlock {
    public static final IntegerProperty STYLE = IntegerProperty.func_177719_a((String)"propagate_property", (int)0, (int)5);

    public BlockStationNameEntrance(AbstractBlock.Properties settings) {
        super(settings);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            world.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)STYLE));
            this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176746_e(), (Property)STYLE, 1);
            this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176735_f(), (Property)STYLE, 1);
        });
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        return world.func_180495_p(pos.func_177972_a(facing)).func_185904_a().func_76220_a();
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction side = ctx.func_196000_l();
        if (side != Direction.UP && side != Direction.DOWN) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)side.func_176734_d());
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (direction.func_176734_d() == ((Direction)IBlock.getStatePropertySafe(state, field_185512_D)).func_176734_d() && !state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        boolean tall = (Integer)IBlock.getStatePropertySafe(state, STYLE) % 2 == 1;
        return IBlock.getVoxelShapeByDirection(0.0, tall ? 0.0 : 4.0, 0.0, 16.0, tall ? 16.0 : 12.0, 1.0, (Direction)IBlock.getStatePropertySafe(state, field_185512_D));
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityStationNameEntrance(pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, STYLE});
    }

    public static class TileEntityStationNameEntrance
    extends BlockStationNameBase.TileEntityStationNameBase {
        public TileEntityStationNameEntrance(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.STATION_NAME_ENTRANCE_TILE_ENTITY, pos, state, 0.0f, 0.00625f);
        }

        @Override
        public boolean shouldRender() {
            return this.field_145850_b != null && !(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(((Direction)IBlock.getStatePropertySafe((IBlockReader)this.field_145850_b, this.field_174879_c, HorizontalBlock.field_185512_D)).func_176735_f())).func_177230_c() instanceof BlockStationNameEntrance);
        }
    }
}

