/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class BlockStationNameTallBase
extends BlockStationNameBase
implements IBlock {
    public static final BooleanProperty METAL = BooleanProperty.func_177716_a((String)"metal");

    public BlockStationNameTallBase() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean isWhite = (Integer)IBlock.getStatePropertySafe(state, COLOR) == 0;
            int newColorProperty = isWhite ? 2 : 0;
            boolean newMetalProperty = isWhite == (Boolean)IBlock.getStatePropertySafe(state, METAL);
            BlockStationNameTallBase.updateProperties(world, pos, newMetalProperty, newColorProperty);
            switch ((IBlock.EnumThird)((Object)((Object)IBlock.getStatePropertySafe(state, THIRD)))) {
                case LOWER: {
                    BlockStationNameTallBase.updateProperties(world, pos.func_177984_a(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.func_177981_b(2), newMetalProperty, newColorProperty);
                    break;
                }
                case MIDDLE: {
                    BlockStationNameTallBase.updateProperties(world, pos.func_177977_b(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.func_177984_a(), newMetalProperty, newColorProperty);
                    break;
                }
                case UPPER: {
                    BlockStationNameTallBase.updateProperties(world, pos.func_177977_b(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.func_177979_c(2), newMetalProperty, newColorProperty);
                }
            }
        });
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if ((direction == Direction.UP && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.UPPER || direction == Direction.DOWN && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.LOWER) && !newState.func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        switch ((IBlock.EnumThird)((Object)IBlock.getStatePropertySafe(state, THIRD))) {
            case MIDDLE: {
                IBlock.onBreakCreative(world, player, pos.func_177977_b());
                break;
            }
            case UPPER: {
                IBlock.onBreakCreative(world, player, pos.func_177979_c(2));
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.field_72995_K) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a((Property)METAL, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)THIRD, (Comparable)((Object)IBlock.EnumThird.MIDDLE)), 3);
            world.func_180501_a(pos.func_177981_b(2), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a((Property)METAL, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)THIRD, (Comparable)((Object)IBlock.EnumThird.UPPER)), 3);
            world.func_195593_d(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COLOR, field_185512_D, METAL, THIRD});
    }

    protected static Tuple<Integer, Integer> getBounds(BlockState state) {
        int end;
        int start;
        IBlock.EnumThird third = (IBlock.EnumThird)((Object)IBlock.getStatePropertySafe(state, THIRD));
        switch (third) {
            case LOWER: {
                start = 10;
                end = 16;
                break;
            }
            case UPPER: {
                start = 0;
                end = 8;
                break;
            }
            default: {
                start = 0;
                end = 16;
            }
        }
        return new Tuple((Object)start, (Object)end);
    }

    private static void updateProperties(World world, BlockPos pos, boolean metalProperty, int colorProperty) {
        world.func_175656_a(pos, (BlockState)((BlockState)world.func_180495_p(pos).func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(colorProperty))).func_206870_a((Property)METAL, (Comparable)Boolean.valueOf(metalProperty)));
    }

    public static class TileEntityStationNameTallBase
    extends BlockStationNameBase.TileEntityStationNameBase {
        public TileEntityStationNameTallBase(TileEntityType<?> type, BlockPos pos, BlockState state, float zOffset) {
            super(type, pos, state, 0.25f, zOffset);
        }

        @Override
        public boolean shouldRender() {
            if (this.field_145850_b == null) {
                return false;
            }
            return IBlock.getStatePropertySafe((IBlockReader)this.field_145850_b, this.field_174879_c, IBlock.THIRD) == IBlock.EnumThird.MIDDLE;
        }
    }
}

