/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mtr.BlockEntityTypes;
import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTactileMap
extends BlockDirectionalDoubleBlockBase
implements EntityBlockMapper {
    public BlockTactileMap(AbstractBlock.Properties settings) {
        super(settings);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        if (world.field_72995_K && TileEntityTactileMap.onUse != null) {
            TileEntityTactileMap.onUse.accept(pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 2.0, 16.0, 7.0, 14.0, facing);
        }
        return VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape)IBlock.getVoxelShapeByDirection(6.0, 1.0, 7.0, 10.0, 16.0, 9.0, facing));
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityTactileMap(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(World world, BlockPos pos, T blockEntity) {
        TileEntityTactileMap.tick(world, pos);
    }

    @Override
    public TileEntityType<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.TACTILE_MAP_TILE_ENTITY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, HALF});
    }

    public static class TileEntityTactileMap
    extends BlockEntityMapper
    implements TickableMapper {
        public static BiConsumer<BlockPos, Boolean> updateSoundSource = null;
        public static Consumer<BlockPos> onUse = null;

        public TileEntityTactileMap(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.TACTILE_MAP_TILE_ENTITY, pos, state);
        }

        public void func_73660_a() {
            TileEntityTactileMap.tick(this.field_145850_b, this.field_174879_c);
        }

        public void func_145843_s() {
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K && updateSoundSource != null) {
                updateSoundSource.accept(this.field_174879_c, true);
            }
            super.func_145843_s();
        }

        public static <T extends BlockEntityMapper> void tick(World world, BlockPos pos) {
            if (world != null && world.field_72995_K && updateSoundSource != null) {
                updateSoundSource.accept(pos, false);
            }
        }
    }
}

