/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.Random;
import mtr.SoundEvents;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.Utilities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockTicketBarrier
extends HorizontalBlock {
    private final boolean isEntrance;
    public static final EnumProperty<TicketSystem.EnumTicketBarrierOpen> OPEN = EnumProperty.func_177709_a((String)"open", TicketSystem.EnumTicketBarrierOpen.class);

    public BlockTicketBarrier(boolean isEntrance) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 5).func_226896_b_());
        this.isEntrance = isEntrance;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
            Vector3d playerPosRotated = entity.func_213303_ch().func_178786_a((double)pos.func_177958_n() + 0.5, 0.0, (double)pos.func_177952_p() + 0.5).func_178785_b((float)Math.toRadians(facing.func_185119_l()));
            TicketSystem.EnumTicketBarrierOpen open = IBlock.getStatePropertySafe(state, OPEN);
            if (open.isOpen() && playerPosRotated.field_72449_c > 0.0) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED)));
            } else if (!open.isOpen() && playerPosRotated.field_72449_c < 0.0) {
                TicketSystem.EnumTicketBarrierOpen newOpen = TicketSystem.passThrough(world, pos, (PlayerEntity)entity, this.isEntrance, !this.isEntrance, SoundEvents.TICKET_BARRIER, SoundEvents.TICKET_BARRIER_CONCESSIONARY, SoundEvents.TICKET_BARRIER, SoundEvents.TICKET_BARRIER_CONCESSIONARY, null, false);
                world.func_175656_a(pos, (BlockState)state.func_206870_a(OPEN, (Comparable)((Object)newOpen)));
                if (newOpen != TicketSystem.EnumTicketBarrierOpen.CLOSED && !world.func_205220_G_().func_205359_a(pos, (Object)this)) {
                    Utilities.scheduleBlockTick(world, pos, (Block)this, 40);
                }
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED)));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f())).func_206870_a(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        return IBlock.getVoxelShapeByDirection(12.0, 0.0, 0.0, 16.0, 15.0, 16.0, facing);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        TicketSystem.EnumTicketBarrierOpen open = IBlock.getStatePropertySafe(state, OPEN);
        VoxelShape base = IBlock.getVoxelShapeByDirection(15.0, 0.0, 0.0, 16.0, 24.0, 16.0, facing);
        return open.isOpen() ? base : VoxelShapes.func_197872_a((VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 0.0, 7.0, 16.0, 24.0, 9.0, facing), (VoxelShape)base);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, OPEN});
    }
}

