/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.Random;
import mtr.SoundEvents;
import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.Utilities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockTicketProcessor
extends BlockDirectionalDoubleBlockBase {
    public boolean hasLight;
    public boolean canEnter;
    public boolean canExit;
    public static final EnumProperty<EnumTicketProcessorLights> LIGHTS = EnumProperty.func_177709_a((String)"lights", EnumTicketProcessorLights.class);

    public BlockTicketProcessor(boolean hasLight, boolean canEnter, boolean canExit) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200943_b(2.0f).func_235838_a_(state -> 5).func_226896_b_());
        this.hasLight = hasLight;
        this.canEnter = canEnter;
        this.canExit = canExit;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        if (!world.field_72995_K && IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            TicketSystem.EnumTicketBarrierOpen open = TicketSystem.passThrough(world, pos, player, this.canEnter, this.canExit, SoundEvents.TICKET_PROCESSOR_ENTRY, SoundEvents.TICKET_PROCESSOR_ENTRY_CONCESSIONARY, SoundEvents.TICKET_PROCESSOR_EXIT, SoundEvents.TICKET_PROCESSOR_EXIT_CONCESSIONARY, SoundEvents.TICKET_PROCESSOR_FAIL, true);
            world.func_175656_a(pos, (BlockState)state.func_206870_a(LIGHTS, (Comparable)((Object)(open.isOpen() ? EnumTicketProcessorLights.GREEN : EnumTicketProcessorLights.RED))));
            Utilities.scheduleBlockTick(world, pos, (Block)this, 20);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (this.hasLight) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(LIGHTS, (Comparable)((Object)EnumTicketProcessorLights.NONE)));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockGetter, BlockPos pos, ISelectionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, field_185512_D);
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            return VoxelShapes.func_197872_a((VoxelShape)IBlock.getVoxelShapeByDirection(4.75, 1.0, 0.0, 11.25, 13.0, 8.0, facing), (VoxelShape)IBlock.getVoxelShapeByDirection(7.0, 0.0, 2.0, 9.0, 1.0, 4.0, facing));
        }
        return VoxelShapes.func_197872_a((VoxelShape)IBlock.getVoxelShapeByDirection(5.0, 0.0, 0.0, 11.0, 1.0, 6.0, facing), (VoxelShape)IBlock.getVoxelShapeByDirection(7.0, 1.0, 2.0, 9.0, 16.0, 4.0, facing));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, HALF, LIGHTS});
    }

    public static enum EnumTicketProcessorLights implements IStringSerializable
    {
        NONE("none"),
        RED("red"),
        YELLOW_GREEN("yellow_green"),
        GREEN("green");

        private final String name;

        private EnumTicketProcessorLights(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

