/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public abstract class BlockTrainSensorBase
extends Block
implements EntityBlockMapper {
    public BlockTrainSensorBase() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196579_bG));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityTrainSensorBase) {
                ((TileEntityTrainSensorBase)entity).syncData();
                PacketTrainDataGuiServer.openTrainSensorScreenS2C((ServerPlayerEntity)player, pos);
            }
        });
    }

    public static boolean matchesFilter(World world, BlockPos pos, long routeId, float speed) {
        TileEntity entity = world.func_175625_s(pos);
        return entity instanceof TileEntityTrainSensorBase && ((TileEntityTrainSensorBase)entity).matchesFilter(routeId, speed);
    }

    public static abstract class TileEntityTrainSensorBase
    extends BlockEntityClientSerializableMapper {
        private boolean stoppedOnly;
        private boolean movingOnly;
        private final Set<Long> filterRouteIds = new HashSet<Long>();
        private static final String KEY_ROUTE_IDS = "route_ids";
        private static final String KEY_STOPPED_ONLY = "stopped_only";
        private static final String KEY_MOVING_ONLY = "moving_only";

        public TileEntityTrainSensorBase(TileEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundNBT compoundTag) {
            long[] routeIdsArray;
            for (long routeId : routeIdsArray = compoundTag.func_197645_o(KEY_ROUTE_IDS)) {
                this.filterRouteIds.add(routeId);
            }
            this.stoppedOnly = compoundTag.func_74767_n(KEY_STOPPED_ONLY);
            this.movingOnly = compoundTag.func_74767_n(KEY_MOVING_ONLY);
        }

        @Override
        public void writeCompoundTag(CompoundNBT compoundTag) {
            compoundTag.func_202168_c(KEY_ROUTE_IDS, new ArrayList<Long>(this.filterRouteIds));
            compoundTag.func_74757_a(KEY_STOPPED_ONLY, this.stoppedOnly);
            compoundTag.func_74757_a(KEY_MOVING_ONLY, this.movingOnly);
        }

        public boolean matchesFilter(long routeId, float speed) {
            if (!this.filterRouteIds.isEmpty() && !this.filterRouteIds.contains(routeId)) {
                return false;
            }
            return speed < 0.0f || !this.stoppedOnly && !this.movingOnly || this.stoppedOnly && speed == 0.0f || this.movingOnly && speed > 0.0f;
        }

        public Set<Long> getRouteIds() {
            return this.filterRouteIds;
        }

        public boolean getStoppedOnly() {
            return this.stoppedOnly;
        }

        public boolean getMovingOnly() {
            return this.movingOnly;
        }

        protected void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
            this.filterRouteIds.clear();
            this.filterRouteIds.addAll(filterRouteIds);
            this.stoppedOnly = stoppedOnly;
            this.movingOnly = movingOnly;
            this.func_70296_d();
            this.syncData();
        }

        public abstract void setData(Set<Long> var1, boolean var2, boolean var3, int var4, String ... var5);
    }
}

