/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.function.Consumer;
import mtr.Items;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public interface IBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final EnumProperty<EnumThird> THIRD = EnumProperty.func_177709_a((String)"third", EnumThird.class);
    public static final EnumProperty<EnumSide> SIDE_EXTENDED = EnumProperty.func_177709_a((String)"side", EnumSide.class);
    public static final EnumProperty<EnumSide> SIDE = EnumProperty.func_177708_a((String)"side", EnumSide.class, side -> side != EnumSide.MIDDLE && side != EnumSide.SINGLE);

    default public <T extends Comparable<T>> void propagate(World world, BlockPos pos, Direction direction, Property<T> property, int maxBlocksAway) {
        Object originalPropertyValue = IBlock.getStatePropertySafe((IBlockReader)world, pos, property);
        this.propagate(world, pos, direction, (BlockPos offsetPos) -> world.func_175656_a(offsetPos, (BlockState)world.func_180495_p(offsetPos).func_206870_a(property, originalPropertyValue)), maxBlocksAway);
    }

    default public void propagate(World world, BlockPos pos, Direction direction, Consumer<BlockPos> callback, int maxBlocksAway) {
        for (int i = 1; i <= maxBlocksAway; ++i) {
            BlockPos offsetPos = pos.func_177967_a(direction, i);
            if (this != world.func_180495_p(offsetPos).func_177230_c()) continue;
            callback.accept(offsetPos);
            this.propagate(world, offsetPos, direction, callback, maxBlocksAway);
            return;
        }
    }

    public static ActionResultType checkHoldingBrush(World world, PlayerEntity player, Runnable callbackBrush, Runnable callbackNoBrush) {
        return IBlock.checkHoldingItem(world, player, item -> callbackBrush.run(), callbackNoBrush, Items.BRUSH);
    }

    public static ActionResultType checkHoldingItem(World world, PlayerEntity player, Consumer<Item> callbackItem, Runnable callbackNoItem, Item ... items) {
        Item holdingItem = null;
        for (Item item : items) {
            if (!player.func_233631_a_(item)) continue;
            holdingItem = item;
            break;
        }
        if (holdingItem != null) {
            if (!world.field_72995_K) {
                callbackItem.accept(holdingItem);
            }
            return ActionResultType.SUCCESS;
        }
        if (callbackNoItem == null) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K) {
            callbackNoItem.run();
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public static ActionResultType checkHoldingBrush(World world, PlayerEntity player, Runnable callbackBrush) {
        return IBlock.checkHoldingBrush(world, player, callbackBrush, null);
    }

    public static VoxelShape getVoxelShapeByDirection(double x1, double y1, double z1, double x2, double y2, double z2, Direction facing) {
        switch (facing) {
            case NORTH: {
                return Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return Block.func_208617_a((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return Block.func_208617_a((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return Block.func_208617_a((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public static boolean isReplaceable(BlockItemUseContext ctx, Direction direction, int totalLength) {
        for (int i = 0; i < totalLength; ++i) {
            if (ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177967_a(direction, i)).func_196953_a(ctx)) continue;
            return false;
        }
        return true;
    }

    public static void onBreakCreative(World world, PlayerEntity player, BlockPos pos) {
        if (!world.field_72995_K && player == null || player.func_184812_l_()) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
            BlockState state = world.func_180495_p(pos);
            world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
        }
    }

    public static Direction getSideDirection(BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalBlock.field_185512_D);
        return IBlock.getStatePropertySafe(state, SIDE) == EnumSide.LEFT ? facing.func_176746_e() : facing.func_176735_f();
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(IBlockReader world, BlockPos pos, Property<T> property) {
        return IBlock.getStatePropertySafe(world.func_180495_p(pos), property);
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(BlockState state, Property<T> property) {
        Comparable defaultProperty = (Comparable)property.func_177700_c().toArray()[0];
        try {
            return (T)(state.func_235901_b_(property) ? state.func_177229_b(property) : defaultProperty);
        }
        catch (Exception exception) {
            return (T)defaultProperty;
        }
    }

    public static enum EnumSide implements IStringSerializable
    {
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        SINGLE("single");

        private final String name;

        private EnumSide(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumThird implements IStringSerializable
    {
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private EnumThird(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

