/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import mtr.client.DynamicTrainModel;
import mtr.client.TrainClientRegistry;
import mtr.data.TrainType;
import mtr.render.RenderTrains;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class CustomResources {
    public static final Map<String, CustomSign> CUSTOM_SIGNS = new HashMap<String, CustomSign>();
    public static final String CUSTOM_RESOURCES_ID = "mtr_custom_resources";
    private static final String CUSTOM_TRAIN_ID_PREFIX = "mtr_custom_train_";
    private static final String CUSTOM_SIGN_ID_PREFIX = "mtr_custom_sign_";
    private static final String CUSTOM_TRAINS_KEY = "custom_trains";
    private static final String CUSTOM_SIGNS_KEY = "custom_signs";
    private static final String CUSTOM_TRAINS_BASE_TRAIN_TYPE = "base_train_type";
    private static final String CUSTOM_TRAINS_NAME = "name";
    private static final String CUSTOM_TRAINS_COLOR = "color";
    private static final String CUSTOM_TRAINS_MODEL = "model";
    private static final String CUSTOM_TRAINS_MODEL_PROPERTIES = "model_properties";
    private static final String CUSTOM_TRAINS_TEXTURE_ID = "texture_id";
    private static final String CUSTOM_TRAINS_SPEED_SOUND_COUNT = "speed_sound_count";
    private static final String CUSTOM_TRAINS_SPEED_SOUND_BASE_ID = "speed_sound_base_id";
    private static final String CUSTOM_TRAINS_DOOR_SOUND_BASE_ID = "door_sound_base_id";
    private static final String CUSTOM_TRAINS_DOOR_CLOSE_SOUND_TIME = "door_close_sound_time";
    private static final String CUSTOM_SIGNS_TEXTURE_ID = "texture_id";
    private static final String CUSTOM_SIGNS_FLIP_TEXTURE = "flip_texture";
    private static final String CUSTOM_SIGNS_CUSTOM_TEXT = "custom_text";
    private static final String CUSTOM_SIGNS_FLIP_CUSTOM_TEXT = "flip_custom_text";
    private static final String CUSTOM_SIGNS_SMALL = "small";
    private static final String CUSTOM_SIGNS_BACKGROUND_COLOR = "background_color";

    public static void reload(IResourceManager manager) {
        TrainClientRegistry.reset();
        RenderTrains.clearTextureAvailability();
        CUSTOM_SIGNS.clear();
        ArrayList customTrains = new ArrayList();
        CustomResources.readResource(manager, "mtr:mtr_custom_resources.json", jsonConfig -> {
            try {
                jsonConfig.get(CUSTOM_TRAINS_KEY).getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String trainId = CUSTOM_TRAIN_ID_PREFIX + (String)entry.getKey();
                        TrainType baseTrainType = TrainType.getOrDefault(jsonObject.get(CUSTOM_TRAINS_BASE_TRAIN_TYPE).getAsString());
                        TrainClientRegistry.TrainProperties baseTrainProperties = TrainClientRegistry.getTrainProperties(baseTrainType.toString(), baseTrainType);
                        String name = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_NAME, null, JsonElement::getAsString);
                        int color = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_COLOR, baseTrainProperties.color, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        String textureId = CustomResources.getOrDefault(jsonObject, "texture_id", baseTrainProperties.textureId, JsonElement::getAsString);
                        int speedSoundCount = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_SPEED_SOUND_COUNT, baseTrainProperties.speedSoundCount, JsonElement::getAsInt);
                        String speedSoundBaseId = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_SPEED_SOUND_BASE_ID, baseTrainProperties.speedSoundBaseId, JsonElement::getAsString);
                        String doorSoundBaseId = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_DOOR_SOUND_BASE_ID, baseTrainProperties.doorSoundBaseId, JsonElement::getAsString);
                        float doorCloseSoundTime = CustomResources.getOrDefault(jsonObject, CUSTOM_TRAINS_DOOR_CLOSE_SOUND_TIME, Float.valueOf(baseTrainProperties.doorCloseSoundTime), JsonElement::getAsFloat).floatValue();
                        if (jsonObject.has(CUSTOM_TRAINS_MODEL) && jsonObject.has(CUSTOM_TRAINS_MODEL_PROPERTIES)) {
                            CustomResources.readResource(manager, jsonObject.get(CUSTOM_TRAINS_MODEL).getAsString(), jsonModel -> CustomResources.readResource(manager, jsonObject.get(CUSTOM_TRAINS_MODEL_PROPERTIES).getAsString(), jsonProperties -> {
                                TrainClientRegistry.register(trainId, baseTrainType, new DynamicTrainModel((JsonObject)jsonModel, (JsonObject)jsonProperties), textureId, speedSoundBaseId, doorSoundBaseId, name, color, speedSoundCount, doorCloseSoundTime, false);
                                customTrains.add(trainId);
                            }));
                        } else {
                            TrainClientRegistry.register(trainId, baseTrainType, baseTrainProperties.model, textureId, speedSoundBaseId, doorSoundBaseId, name, color, speedSoundCount, doorCloseSoundTime, false);
                            customTrains.add(trainId);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jsonConfig.get(CUSTOM_SIGNS_KEY).getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        boolean flipTexture = CustomResources.getOrDefault(jsonObject, CUSTOM_SIGNS_FLIP_TEXTURE, false, JsonElement::getAsBoolean);
                        String customText = CustomResources.getOrDefault(jsonObject, CUSTOM_SIGNS_CUSTOM_TEXT, "", JsonElement::getAsString);
                        boolean flipCustomText = CustomResources.getOrDefault(jsonObject, CUSTOM_SIGNS_FLIP_CUSTOM_TEXT, false, JsonElement::getAsBoolean);
                        boolean small = CustomResources.getOrDefault(jsonObject, CUSTOM_SIGNS_SMALL, false, JsonElement::getAsBoolean);
                        int backgroundColor = CustomResources.getOrDefault(jsonObject, CUSTOM_SIGNS_BACKGROUND_COLOR, 0, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        CUSTOM_SIGNS.put(CUSTOM_SIGN_ID_PREFIX + (String)entry.getKey(), new CustomSign(new ResourceLocation(jsonObject.get("texture_id").getAsString()), flipTexture, customText, flipCustomText, small, backgroundColor));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        System.out.println("Loaded " + customTrains.size() + " custom train(s)");
        customTrains.forEach(System.out::println);
        System.out.println("Loaded " + CUSTOM_SIGNS.size() + " custom sign(s)");
        CUSTOM_SIGNS.keySet().forEach(System.out::println);
    }

    private static void readResource(IResourceManager manager, String path, Consumer<JsonObject> callback) {
        try {
            manager.func_199004_b(new ResourceLocation(path)).forEach(resource -> {
                try (InputStream stream = resource.func_199027_b();){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resource.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int colorStringToInt(String string) {
        try {
            return Integer.parseInt(string.toUpperCase().replaceAll("[^0-9A-F]", ""), 16);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static SoundEvent[] registerSoundEvents(int size, int groupSize, String path) {
        return (SoundEvent[])IntStream.range(0, size).mapToObj(i -> {
            String group;
            switch (i % groupSize) {
                case 0: {
                    group = "a";
                    break;
                }
                case 1: {
                    group = "b";
                    break;
                }
                case 2: {
                    group = "c";
                    break;
                }
                default: {
                    group = "";
                }
            }
            return new SoundEvent(new ResourceLocation(path + i / 3 + group));
        }).toArray(SoundEvent[]::new);
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            return function.apply(jsonObject.get(key));
        }
        return defaultValue;
    }

    public static class CustomSign {
        public final ResourceLocation textureId;
        public final boolean flipTexture;
        public final String customText;
        public final boolean flipCustomText;
        public final boolean small;
        public final int backgroundColor;

        public CustomSign(ResourceLocation textureId, boolean flipTexture, String customText, boolean flipCustomText, boolean small, int backgroundColor) {
            this.textureId = textureId;
            this.flipTexture = flipTexture;
            this.customText = customText;
            this.flipCustomText = flipCustomText;
            this.small = small;
            this.backgroundColor = backgroundColor;
        }

        public boolean hasCustomText() {
            return !this.customText.isEmpty();
        }
    }
}

