/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.model.ModelTrainBase;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class DynamicTrainModel
extends ModelTrainBase {
    private final Map<String, ModelMapper> parts = new HashMap<String, ModelMapper>();
    private final JsonObject properties;
    private final int doorMax;

    public DynamicTrainModel(JsonObject model, JsonObject properties) {
        JsonObject resolution = model.getAsJsonObject("resolution");
        int textureWidth = resolution.get("width").getAsInt();
        int textureHeight = resolution.get("height").getAsInt();
        ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, textureWidth, textureHeight);
        HashMap elementsByKey = new HashMap();
        model.getAsJsonArray("elements").forEach(element -> elementsByKey.put(element.getAsJsonObject().get("uuid").getAsString(), new ModelMapper(modelDataWrapper)));
        model.getAsJsonArray("outliner").forEach(element -> {
            JsonObject elementObject = element.getAsJsonObject();
            this.parts.put(elementObject.get("name").getAsString(), this.addChildren(elementObject, elementsByKey, modelDataWrapper));
        });
        model.getAsJsonArray("elements").forEach(element -> {
            JsonObject elementObject = element.getAsJsonObject();
            ModelMapper child = (ModelMapper)((Object)((Object)elementsByKey.get(elementObject.get("uuid").getAsString())));
            Double[] origin = new Double[]{0.0, 0.0, 0.0};
            DynamicTrainModel.getArrayFromValue(origin, elementObject, "origin", JsonElement::getAsDouble);
            child.func_78793_a(-origin[0].floatValue(), -origin[1].floatValue(), origin[2].floatValue());
            Double[] rotation = new Double[]{0.0, 0.0, 0.0};
            DynamicTrainModel.getArrayFromValue(rotation, elementObject, "rotation", JsonElement::getAsDouble);
            DynamicTrainModel.setRotationAngle(child, -((float)Math.toRadians(rotation[0])), -((float)Math.toRadians(rotation[1])), (float)Math.toRadians(rotation[2]));
            Integer[] uvOffset = new Integer[]{0, 0};
            DynamicTrainModel.getArrayFromValue(uvOffset, elementObject, "uv_offset", JsonElement::getAsInt);
            Double[] posFrom = new Double[]{0.0, 0.0, 0.0};
            DynamicTrainModel.getArrayFromValue(posFrom, elementObject, "from", JsonElement::getAsDouble);
            Double[] posTo = new Double[]{0.0, 0.0, 0.0};
            DynamicTrainModel.getArrayFromValue(posTo, elementObject, "to", JsonElement::getAsDouble);
            double inflate = elementObject.has("inflate") ? elementObject.get("inflate").getAsDouble() : 0.0;
            boolean mirror = elementObject.has("shade") && !elementObject.get("shade").getAsBoolean();
            child.func_78784_a(uvOffset[0], uvOffset[1]).func_228303_a_(origin[0].floatValue() - posTo[0].floatValue(), origin[1].floatValue() - posTo[1].floatValue(), posFrom[2].floatValue() - origin[2].floatValue(), (float)Math.round(posTo[0].floatValue() - posFrom[0].floatValue()), (float)Math.round(posTo[1].floatValue() - posFrom[1].floatValue()), (float)Math.round(posTo[2].floatValue() - posFrom[2].floatValue()), (float)inflate, mirror);
        });
        this.properties = properties;
        this.doorMax = properties.get("door_max").getAsInt();
        modelDataWrapper.setModelPart(textureWidth, textureHeight);
        this.parts.values().forEach(part -> {
            part.func_78793_a(0.0f, 0.0f, 0.0f);
            part.func_78784_a(0, 0).func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            part.setModelPart();
        });
    }

    @Override
    protected void renderWindowPositions(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean isEnd1Head, boolean isEnd2Head) {
    }

    @Override
    protected void renderDoorPositions(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean isEnd1Head, boolean isEnd2Head) {
        this.renderParts("parts_normal", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (doorLeftZ > 0.0f || doorRightZ > 0.0f) {
            this.renderParts("parts_door_opened", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_door_closed", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderHeadPosition1(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean useHeadlights) {
        this.renderParts("parts_head_1", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (useHeadlights) {
            this.renderParts("parts_head_1_headlights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_head_1_tail_lights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderHeadPosition2(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean useHeadlights) {
        this.renderParts("parts_head_2", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (useHeadlights) {
            this.renderParts("parts_head_2_headlights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_head_2_tail_lights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderEndPosition1(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        this.renderParts("parts_end_1", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
    }

    @Override
    protected void renderEndPosition2(MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        this.renderParts("parts_end_2", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
    }

    @Override
    protected ModelDoorOverlay getModelDoorOverlay() {
        return null;
    }

    @Override
    protected ModelDoorOverlayTopBase getModelDoorOverlayTop() {
        return null;
    }

    @Override
    protected int[] getWindowPositions() {
        return new int[]{0};
    }

    @Override
    protected int[] getDoorPositions() {
        return new int[]{0};
    }

    @Override
    protected int[] getEndPositions() {
        return new int[]{0, 0};
    }

    @Override
    protected int[] getBogiePositions() {
        return new int[0];
    }

    @Override
    protected float getDoorAnimationX(float value, boolean opening) {
        return 0.0f;
    }

    @Override
    protected float getDoorAnimationZ(float value, boolean opening) {
        return DynamicTrainModel.smoothEnds(0.0f, this.doorMax, 0.0f, 0.5f, value);
    }

    private ModelMapper addChildren(JsonObject jsonObject, Map<String, ModelMapper> children, ModelDataWrapper modelDataWrapper) {
        ModelMapper part = new ModelMapper(modelDataWrapper);
        jsonObject.getAsJsonArray("children").forEach(child -> part.func_78792_a(child.isJsonObject() ? this.addChildren(child.getAsJsonObject(), children, modelDataWrapper) : (ModelRenderer)children.get(child.getAsString())));
        return part;
    }

    private void renderParts(String category, MatrixStack matrices, IVertexBuilder vertices, ModelTrainBase.RenderStage renderStage, int light, boolean renderDetails, float doorLeftZ, float doorRightZ) {
        if (!this.properties.has(category)) {
            return;
        }
        this.properties.getAsJsonArray(category).forEach(partElement -> {
            ModelMapper part;
            boolean shouldRender;
            JsonObject partObject = partElement.getAsJsonObject();
            boolean bl = shouldRender = renderDetails || !partObject.has("skip_rendering_if_too_far") || !partObject.get("skip_rendering_if_too_far").getAsBoolean();
            if (shouldRender && renderStage.toString().equals(partObject.get("stage").getAsString().toUpperCase()) && (part = this.parts.get(partObject.get("part_name").getAsString())) != null) {
                float zOffset;
                if (partObject.has("door_offset_z")) {
                    switch (partObject.get("door_offset_z").getAsString()) {
                        case "left": {
                            zOffset = doorLeftZ;
                            break;
                        }
                        case "right": {
                            zOffset = doorRightZ;
                            break;
                        }
                        case "left_negative": {
                            zOffset = -doorLeftZ;
                            break;
                        }
                        case "right_negative": {
                            zOffset = -doorRightZ;
                            break;
                        }
                        default: {
                            zOffset = 0.0f;
                            break;
                        }
                    }
                } else {
                    zOffset = 0.0f;
                }
                if (partObject.has("positions")) {
                    partObject.getAsJsonArray("positions").forEach(positionElement -> {
                        float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                        float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                        DynamicTrainModel.renderOnce(part, matrices, vertices, light, x, z + zOffset);
                    });
                }
                if (partObject.has("positions_flipped")) {
                    partObject.getAsJsonArray("positions_flipped").forEach(positionElement -> {
                        float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                        float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                        DynamicTrainModel.renderOnceFlipped(part, matrices, vertices, light, x, z - zOffset);
                    });
                }
            }
        });
    }

    private static <T> void getArrayFromValue(T[] array, JsonObject jsonObject, String key, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            for (int i = 0; i < array.length; ++i) {
                array[i] = function.apply(jsonArray.get(i));
            }
        }
    }
}

