/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.text2speech.Narrator;
import java.util.ArrayList;
import mtr.client.Config;
import mtr.data.IGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public interface IDrawing {
    public static void drawStringWithFont(MatrixStack matrices, FontRenderer textRenderer, IRenderTypeBuffer.Impl immediate, String text, float x, float y, int light) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, x, y, 1.0f, -1, true, light, null);
    }

    public static void drawStringWithFont(MatrixStack matrices, FontRenderer textRenderer, IRenderTypeBuffer.Impl immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, -1.0f, -1.0f, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(MatrixStack matrices, FontRenderer textRenderer, IRenderTypeBuffer.Impl immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, maxWidth, maxHeight, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(MatrixStack matrices, FontRenderer textRenderer, IRenderTypeBuffer.Impl immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        float scaleX;
        float totalWidthScaled;
        boolean isCJK;
        Style style;
        Style style2 = style = Config.useMTRFont() ? Style.field_240709_b_.func_240719_a_(new ResourceLocation("mtr", "mtr")) : Style.field_240709_b_;
        while (text.contains("||")) {
            text = text.replace("||", "|");
        }
        String[] stringSplit = text.split("\\|");
        ArrayList<Boolean> isCJKList = new ArrayList<Boolean>();
        ArrayList<IReorderingProcessor> orderedTexts = new ArrayList<IReorderingProcessor>();
        int totalHeight = 0;
        int totalWidth = 0;
        for (String stringSplitPart : stringSplit) {
            isCJK = stringSplitPart.codePoints().anyMatch(Character::isIdeographic);
            isCJKList.add(isCJK);
            IReorderingProcessor orderedText = new StringTextComponent(stringSplitPart).func_230530_a_(style).func_241878_f();
            orderedTexts.add(orderedText);
            totalHeight += 10 * (isCJK ? 2 : 1);
            int width = textRenderer.func_243245_a(orderedText) * (isCJK ? 2 : 1);
            if (width <= totalWidth) continue;
            totalWidth = width;
        }
        if (maxHeight >= 0.0f && (float)totalHeight / scale > maxHeight) {
            scale = (float)totalHeight / maxHeight;
        }
        matrices.func_227860_a_();
        if (maxWidth >= 0.0f && (float)totalWidth > maxWidth * scale) {
            totalWidthScaled = maxWidth * scale;
            scaleX = (float)totalWidth / maxWidth;
        } else {
            totalWidthScaled = totalWidth;
            scaleX = scale;
        }
        matrices.func_227862_a_(1.0f / scaleX, 1.0f / scale, 1.0f / scale);
        float offset = verticalAlignment.getOffset(y * scale, totalHeight);
        for (int i = 0; i < orderedTexts.size(); ++i) {
            int extraScale;
            isCJK = (Boolean)isCJKList.get(i);
            int n = extraScale = isCJK ? 2 : 1;
            if (isCJK) {
                matrices.func_227860_a_();
                matrices.func_227862_a_((float)extraScale, (float)extraScale, 1.0f);
            }
            float xOffset = horizontalAlignment.getOffset(xAlignment.getOffset(x * scaleX, totalWidth), textRenderer.func_243245_a((IReorderingProcessor)orderedTexts.get(i)) * extraScale - totalWidth);
            float shade = light == 0xF000F0 ? 1.0f : Math.min((float)LightTexture.func_228450_a_((int)light) / 16.0f * 0.1f + 0.7f, 1.0f);
            int a = textColor >> 24 & 0xFF;
            int r = (int)((float)(textColor >> 16 & 0xFF) * shade);
            int g = (int)((float)(textColor >> 8 & 0xFF) * shade);
            int b = (int)((float)(textColor & 0xFF) * shade);
            if (immediate != null) {
                textRenderer.func_238416_a_((IReorderingProcessor)orderedTexts.get(i), xOffset / (float)extraScale, offset / (float)extraScale, (a << 24) + (r << 16) + (g << 8) + b, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, light);
            }
            if (isCJK) {
                matrices.func_227865_b_();
            }
            offset += (float)(10 * extraScale);
        }
        matrices.func_227865_b_();
        if (drawingCallback != null) {
            float x1 = xAlignment.getOffset(x, totalWidthScaled / scale);
            float y1 = verticalAlignment.getOffset(y, (float)totalHeight / scale);
            drawingCallback.drawingCallback(x1, y1, x1 + totalWidthScaled / scale, y1 + (float)totalHeight / scale);
        }
    }

    public static void drawRectangle(IVertexBuilder vertexConsumer, double x1, double y1, double x2, double y2, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.func_225582_a_(x1, y1, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        vertexConsumer.func_225582_a_(x1, y2, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        vertexConsumer.func_225582_a_(x2, y2, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        vertexConsumer.func_225582_a_(x2, y1, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y1, z1, x2, y2, z2, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, float x, float y, float width, float height, Direction facing, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
    }

    public static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, float x, float y, float width, float height, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        Vector3i vec3i = facing.func_176730_m();
        Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrices.func_227866_c_().func_227872_b_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.func_227888_a_(matrix4f, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p()).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p()).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, x3, y3, z3).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p()).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, x4, y4, z4).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p()).func_181675_d();
    }

    public static void setPositionAndWidth(Widget widget, int x, int y, int widgetWidth) {
        widget.field_230690_l_ = x;
        widget.field_230691_m_ = y;
        widget.func_230991_b_(MathHelper.func_76125_a((int)widgetWidth, (int)0, (int)380));
    }

    public static void narrateOrAnnounce(String message) {
        String newMessage = IGui.formatStationName(message).replace("  ", " ");
        if (!newMessage.isEmpty()) {
            ClientPlayerEntity player;
            if (Config.useTTSAnnouncements()) {
                Narrator.getNarrator().say(newMessage, true);
            }
            if (Config.showAnnouncementMessages() && (player = Minecraft.func_71410_x().field_71439_g) != null) {
                player.func_146105_b((ITextComponent)new StringTextComponent(newMessage), false);
            }
        }
    }

    @FunctionalInterface
    public static interface DrawingCallback {
        public void drawingCallback(float var1, float var2, float var3, float var4);
    }
}

