/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import mtr.MTRClient;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.model.ModelATrain;
import mtr.model.ModelATrainMini;
import mtr.model.ModelATrainSmall;
import mtr.model.ModelCMStock;
import mtr.model.ModelCMStockMini;
import mtr.model.ModelCMStockSmall;
import mtr.model.ModelCTrain;
import mtr.model.ModelCTrainMini;
import mtr.model.ModelCTrainSmall;
import mtr.model.ModelClass802;
import mtr.model.ModelClass802Mini;
import mtr.model.ModelDRL;
import mtr.model.ModelE44;
import mtr.model.ModelE44Mini;
import mtr.model.ModelKTrain;
import mtr.model.ModelKTrainMini;
import mtr.model.ModelKTrainSmall;
import mtr.model.ModelLightRail;
import mtr.model.ModelLondonUnderground1995;
import mtr.model.ModelLondonUndergroundD78;
import mtr.model.ModelLondonUndergroundD78Mini;
import mtr.model.ModelMLR;
import mtr.model.ModelMLRMini;
import mtr.model.ModelMLRSmall;
import mtr.model.ModelMTrain;
import mtr.model.ModelMTrainMini;
import mtr.model.ModelMTrainSmall;
import mtr.model.ModelR179;
import mtr.model.ModelR179Mini;
import mtr.model.ModelR211;
import mtr.model.ModelR211Mini;
import mtr.model.ModelSP1900;
import mtr.model.ModelSP1900Mini;
import mtr.model.ModelSP1900Small;
import mtr.model.ModelSTrain;
import mtr.model.ModelSTrainMini;
import mtr.model.ModelSTrainSmall;
import mtr.model.ModelTrainBase;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TrainClientRegistry {
    private static final Map<String, TrainProperties> REGISTRY = new HashMap<String, TrainProperties>();
    private static final Map<TransportMode, List<String>> KEY_ORDERS = new HashMap<TransportMode, List<String>>();
    private static final String SOUND_ACCELERATION = "_acceleration_";
    private static final String SOUND_DECELERATION = "_deceleration_";
    private static final String SOUND_DOOR_OPEN = "_door_open";
    private static final String SOUND_DOOR_CLOSE = "_door_close";

    public static void register(String key, TrainType baseTrainType, ModelTrainBase model, String textureId, String speedSoundBaseId, String doorSoundBaseId, String name, int color, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
        String keyLower = key.toLowerCase();
        if (!KEY_ORDERS.containsKey((Object)baseTrainType.transportMode)) {
            KEY_ORDERS.put(baseTrainType.transportMode, new ArrayList());
        }
        if (!KEY_ORDERS.get((Object)baseTrainType.transportMode).contains(keyLower)) {
            KEY_ORDERS.get((Object)baseTrainType.transportMode).add(keyLower);
        }
        REGISTRY.put(keyLower, new TrainProperties(baseTrainType, model, textureId, speedSoundBaseId, doorSoundBaseId, new TranslationTextComponent(name == null ? "train.mtr." + keyLower : name), color, speedSoundCount, doorCloseSoundTime, useAccelerationSoundsWhenCoasting));
    }

    public static void reset() {
        REGISTRY.clear();
        KEY_ORDERS.clear();
        TrainClientRegistry.register("sp1900", TrainType.SP1900, new ModelSP1900(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", null, 13209, 120, 0.5f, false);
        TrainClientRegistry.register("sp1900_small", TrainType.SP1900_SMALL, new ModelSP1900Small(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", null, 13209, 120, 0.5f, false);
        TrainClientRegistry.register("sp1900_mini", TrainType.SP1900_MINI, new ModelSP1900Mini(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", null, 13209, 120, 0.5f, false);
        TrainClientRegistry.register("c1141a", TrainType.C1141A, new ModelSP1900(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", null, 11805257, 96, 0.5f, false);
        TrainClientRegistry.register("c1141a_small", TrainType.C1141A_SMALL, new ModelSP1900Small(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", null, 11805257, 96, 0.5f, false);
        TrainClientRegistry.register("c1141a_mini", TrainType.C1141A_MINI, new ModelSP1900Mini(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", null, 11805257, 96, 0.5f, false);
        TrainClientRegistry.register("m_train", TrainType.M_TRAIN, new ModelMTrain(), "mtr:textures/entity/m_train", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("m_train_small", TrainType.M_TRAIN_SMALL, new ModelMTrainSmall(), "mtr:textures/entity/m_train", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("m_train_mini", TrainType.M_TRAIN_MINI, new ModelMTrainMini(), "mtr:textures/entity/m_train", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("cm_stock", TrainType.CM_STOCK, new ModelCMStock(), "mtr:textures/entity/cm_stock", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("cm_stock_small", TrainType.CM_STOCK_SMALL, new ModelCMStockSmall(), "mtr:textures/entity/cm_stock", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("cm_stock_mini", TrainType.CM_STOCK_MINI, new ModelCMStockMini(), "mtr:textures/entity/cm_stock", "m_train", "m_train", null, 0x999999, 90, 0.5f, false);
        TrainClientRegistry.register("mlr", TrainType.MLR, new ModelMLR(), "mtr:textures/entity/mlr", "mlr", "mlr", null, 7124450, 93, 0.5f, true);
        TrainClientRegistry.register("mlr_small", TrainType.MLR_SMALL, new ModelMLRSmall(), "mtr:textures/entity/mlr", "mlr", "mlr", null, 7124450, 93, 0.5f, true);
        TrainClientRegistry.register("mlr_mini", TrainType.MLR_MINI, new ModelMLRMini(), "mtr:textures/entity/mlr", "mlr", "mlr", null, 7124450, 93, 0.5f, true);
        TrainClientRegistry.register("e44", TrainType.E44, new ModelE44(), "mtr:textures/entity/e44", "mlr", "m_train", null, 15183653, 93, 0.5f, true);
        TrainClientRegistry.register("e44_mini", TrainType.E44_MINI, new ModelE44Mini(), "mtr:textures/entity/e44", "mlr", "m_train", null, 15183653, 93, 0.5f, true);
        TrainClientRegistry.register("drl", TrainType.DRL, new ModelDRL(), "mtr:textures/entity/drl", "m_train", null, null, 15894455, 90, 0.5f, false);
        TrainClientRegistry.register("k_train", TrainType.K_TRAIN, new ModelKTrain(false), "mtr:textures/entity/k_train", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_small", TrainType.K_TRAIN_SMALL, new ModelKTrainSmall(false), "mtr:textures/entity/k_train", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_mini", TrainType.K_TRAIN_MINI, new ModelKTrainMini(false), "mtr:textures/entity/k_train", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_tcl", TrainType.K_TRAIN_TCL, new ModelKTrain(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_tcl_small", TrainType.K_TRAIN_TCL_SMALL, new ModelKTrainSmall(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_tcl_mini", TrainType.K_TRAIN_TCL_MINI, new ModelKTrainMini(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_ael", TrainType.K_TRAIN_AEL, new ModelKTrain(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_ael_small", TrainType.K_TRAIN_AEL_SMALL, new ModelKTrainSmall(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("k_train_ael_mini", TrainType.K_TRAIN_AEL_MINI, new ModelKTrainMini(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", null, 961362, 66, 1.0f, false);
        TrainClientRegistry.register("c_train", TrainType.C_TRAIN, new ModelCTrain(), "mtr:textures/entity/c_train", "c_train", "sp1900", null, 16636160, 69, 0.5f, false);
        TrainClientRegistry.register("c_train_small", TrainType.C_TRAIN_SMALL, new ModelCTrainSmall(), "mtr:textures/entity/c_train", "c_train", "sp1900", null, 16636160, 69, 0.5f, false);
        TrainClientRegistry.register("c_train_mini", TrainType.C_TRAIN_MINI, new ModelCTrainMini(), "mtr:textures/entity/c_train", "c_train", "sp1900", null, 16636160, 69, 0.5f, false);
        TrainClientRegistry.register("s_train", TrainType.S_TRAIN, new ModelSTrain(), "mtr:textures/entity/s_train", "c_train", "sp1900", null, 12700963, 69, 0.5f, false);
        TrainClientRegistry.register("s_train_small", TrainType.S_TRAIN_SMALL, new ModelSTrainSmall(), "mtr:textures/entity/s_train", "c_train", "sp1900", null, 12700963, 69, 0.5f, false);
        TrainClientRegistry.register("s_train_mini", TrainType.S_TRAIN_MINI, new ModelSTrainMini(), "mtr:textures/entity/s_train", "c_train", "sp1900", null, 12700963, 69, 0.5f, false);
        TrainClientRegistry.register("a_train_tcl", TrainType.A_TRAIN_TCL, new ModelATrain(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", null, 16159815, 78, 0.5f, false);
        TrainClientRegistry.register("a_train_tcl_small", TrainType.A_TRAIN_TCL_SMALL, new ModelATrainSmall(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", null, 16159815, 78, 0.5f, false);
        TrainClientRegistry.register("a_train_tcl_mini", TrainType.A_TRAIN_TCL_MINI, new ModelATrainMini(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", null, 16159815, 78, 0.5f, false);
        TrainClientRegistry.register("a_train_ael", TrainType.A_TRAIN_AEL, new ModelATrain(true), "mtr:textures/entity/a_train_ael", "a_train", "a_train", null, 36237, 78, 0.5f, false);
        TrainClientRegistry.register("a_train_ael_mini", TrainType.A_TRAIN_AEL_MINI, new ModelATrainMini(true), "mtr:textures/entity/a_train_ael", "a_train", "a_train", null, 36237, 78, 0.5f, false);
        TrainClientRegistry.register("light_rail_1", TrainType.LIGHT_RAIL_1, new ModelLightRail(1), "mtr:textures/entity/light_rail_1", "light_rail_aeg", "light_rail_1", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_1r", TrainType.LIGHT_RAIL_1R, new ModelLightRail(4), "mtr:textures/entity/light_rail_1r", "light_rail_aeg", "light_rail_1", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_2", TrainType.LIGHT_RAIL_2, new ModelLightRail(2), "mtr:textures/entity/light_rail_2", "light_rail_aeg", "light_rail_3", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_3", TrainType.LIGHT_RAIL_3, new ModelLightRail(3), "mtr:textures/entity/light_rail_3", "light_rail_mitsubishi", "light_rail_3", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_4", TrainType.LIGHT_RAIL_4, new ModelLightRail(4), "mtr:textures/entity/light_rail_4", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_5", TrainType.LIGHT_RAIL_5, new ModelLightRail(5), "mtr:textures/entity/light_rail_5", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_1r_old", TrainType.LIGHT_RAIL_1R_OLD, new ModelLightRail(4), "mtr:textures/entity/light_rail_1r_old", "light_rail_aeg", "light_rail_1", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_4_old", TrainType.LIGHT_RAIL_4_OLD, new ModelLightRail(4), "mtr:textures/entity/light_rail_4_old", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_5_old", TrainType.LIGHT_RAIL_5_OLD, new ModelLightRail(5), "mtr:textures/entity/light_rail_5_old", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_1_orange", TrainType.LIGHT_RAIL_1_ORANGE, new ModelLightRail(1), "mtr:textures/entity/light_rail_1_orange", "light_rail_aeg", "light_rail_1", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_1r_orange", TrainType.LIGHT_RAIL_1R_ORANGE, new ModelLightRail(4), "mtr:textures/entity/light_rail_1r_orange", "light_rail_aeg", "light_rail_1", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_2_orange", TrainType.LIGHT_RAIL_2_ORANGE, new ModelLightRail(2), "mtr:textures/entity/light_rail_2_orange", "light_rail_aeg", "light_rail_3", null, 13805605, 48, 1.0f, false);
        TrainClientRegistry.register("light_rail_3_orange", TrainType.LIGHT_RAIL_3_ORANGE, new ModelLightRail(3), "mtr:textures/entity/light_rail_3_orange", "light_rail_mitsubishi", "light_rail_3", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_4_orange", TrainType.LIGHT_RAIL_4_ORANGE, new ModelLightRail(4), "mtr:textures/entity/light_rail_4_orange", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("light_rail_5_orange", TrainType.LIGHT_RAIL_5_ORANGE, new ModelLightRail(5), "mtr:textures/entity/light_rail_5_orange", "light_rail_mitsubishi", "light_rail_4", null, 13805605, 45, 1.0f, false);
        TrainClientRegistry.register("london_underground_d78", TrainType.LONDON_UNDERGROUND_D78, new ModelLondonUndergroundD78(), "mtr:textures/entity/london_underground_d78", "mlr", "london_underground_d78", null, 29225, 93, 1.0f, true);
        TrainClientRegistry.register("london_underground_d78_mini", TrainType.LONDON_UNDERGROUND_D78_MINI, new ModelLondonUndergroundD78Mini(), "mtr:textures/entity/london_underground_d78", "mlr", "london_underground_d78", null, 29225, 93, 1.0f, true);
        TrainClientRegistry.register("london_underground_1995", TrainType.LONDON_UNDERGROUND_1995, new ModelLondonUnderground1995(), "mtr:textures/entity/london_underground_1995", "london_underground_1995", "london_underground_1995", null, 0x333333, 72, 0.5f, false);
        TrainClientRegistry.register("london_underground_1996", TrainType.LONDON_UNDERGROUND_1996, new ModelLondonUnderground1995(), "mtr:textures/entity/london_underground_1996", "london_underground_1996", "london_underground_1995", null, 10593703, 93, 0.5f, false);
        TrainClientRegistry.register("r179", TrainType.R179, new ModelR179(), "mtr:textures/entity/r179", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("r179_mini", TrainType.R179_MINI, new ModelR179Mini(), "mtr:textures/entity/r179", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("r211", TrainType.R211, new ModelR211(false), "mtr:textures/entity/r211", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("r211_mini", TrainType.R211_MINI, new ModelR211Mini(false), "mtr:textures/entity/r211", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("r211t", TrainType.R211T, new ModelR211(true), "mtr:textures/entity/r211", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("r211t_mini", TrainType.R211T_MINI, new ModelR211Mini(true), "mtr:textures/entity/r211", "r179", "r179", null, 0xD5D5D5, 66, 1.0f, false);
        TrainClientRegistry.register("class_802_gwr", TrainType.CLASS_802_GWR, new ModelClass802(), "mtr:textures/entity/class_802_gwr", "k_train", "class_802", null, 138773, 66, 1.0f, false);
        TrainClientRegistry.register("class_802_gwr_mini", TrainType.CLASS_802_GWR_MINI, new ModelClass802Mini(), "mtr:textures/entity/class_802_gwr", "k_train", "class_802", null, 138773, 66, 1.0f, false);
        TrainClientRegistry.register("class_802_tpe", TrainType.CLASS_802_TPE, new ModelClass802(), "mtr:textures/entity/class_802_tpe", "k_train", "class_802", null, 42726, 66, 1.0f, false);
        TrainClientRegistry.register("class_802_tpe_mini", TrainType.CLASS_802_TPE_MINI, new ModelClass802Mini(), "mtr:textures/entity/class_802_tpe", "k_train", "class_802", null, 42726, 66, 1.0f, false);
        TrainClientRegistry.register("minecart", TrainType.MINECART, null, "textures/entity/minecart", null, null, null, 0x666666, 0, 0.5f, false);
        TrainClientRegistry.register("oak_boat", TrainType.OAK_BOAT, null, "textures/entity/boat/oak", null, null, null, 9402184, 0, 0.5f, false);
        TrainClientRegistry.register("spruce_boat", TrainType.SPRUCE_BOAT, null, "textures/entity/boat/spruce", null, null, null, 9402184, 0, 0.5f, false);
        TrainClientRegistry.register("birch_boat", TrainType.BIRCH_BOAT, null, "textures/entity/boat/birch", null, null, null, 9402184, 0, 0.5f, false);
        TrainClientRegistry.register("jungle_boat", TrainType.JUNGLE_BOAT, null, "textures/entity/boat/jungle", null, null, null, 9402184, 0, 0.5f, false);
        TrainClientRegistry.register("acacia_boat", TrainType.ACACIA_BOAT, null, "textures/entity/boat/acacia", null, null, null, 9402184, 0, 0.5f, false);
        TrainClientRegistry.register("dark_oak_boat", TrainType.DARK_OAK_BOAT, null, "textures/entity/boat/dark_oak", null, null, null, 9402184, 0, 0.5f, false);
    }

    public static TrainProperties getTrainProperties(String key, TrainType baseTrainType) {
        String keyLower = key.toLowerCase();
        if (REGISTRY.containsKey(keyLower)) {
            return REGISTRY.get(keyLower);
        }
        String fallbackKeyLower = baseTrainType.toString().toLowerCase();
        return REGISTRY.containsKey(fallbackKeyLower) ? REGISTRY.get(fallbackKeyLower) : TrainClientRegistry.getBlankProperties(baseTrainType);
    }

    public static TrainProperties getTrainProperties(TransportMode transportMode, int index) {
        return index >= 0 && index < KEY_ORDERS.get((Object)transportMode).size() ? REGISTRY.get(KEY_ORDERS.get((Object)transportMode).get(index)) : TrainClientRegistry.getBlankProperties(TrainType.values()[0]);
    }

    public static String getTrainId(TransportMode transportMode, int index) {
        return KEY_ORDERS.get((Object)transportMode).get(index >= 0 && index < KEY_ORDERS.get((Object)transportMode).size() ? index : 0);
    }

    public static void forEach(TransportMode transportMode, BiConsumer<String, TrainProperties> biConsumer) {
        KEY_ORDERS.get((Object)transportMode).forEach(key -> biConsumer.accept((String)key, REGISTRY.get(key)));
    }

    private static TrainProperties getBlankProperties(TrainType baseTrainType) {
        return new TrainProperties(baseTrainType, null, null, null, null, new TranslationTextComponent(""), 0, 0, 0.5f, false);
    }

    public static class TrainProperties {
        public final TrainType baseTrainType;
        public final ModelTrainBase model;
        public final String textureId;
        public final String speedSoundBaseId;
        public final String doorSoundBaseId;
        public final TranslationTextComponent name;
        public final int color;
        public final int speedSoundCount;
        public final float doorCloseSoundTime;
        private final boolean useAccelerationSoundsWhenCoasting;
        private final char[] SOUND_GROUP_LETTERS = new char[]{'a', 'b', 'c'};
        private final int SOUND_GROUP_SIZE = this.SOUND_GROUP_LETTERS.length;

        private TrainProperties(TrainType baseTrainType, ModelTrainBase model, String textureId, String speedSoundBaseId, String doorSoundBaseId, TranslationTextComponent name, int color, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
            this.baseTrainType = baseTrainType;
            this.model = model;
            this.textureId = TrainProperties.resolvePath(textureId);
            this.speedSoundBaseId = TrainProperties.resolvePath(speedSoundBaseId);
            this.doorSoundBaseId = TrainProperties.resolvePath(doorSoundBaseId);
            this.name = name;
            this.color = color;
            this.speedSoundCount = speedSoundCount;
            this.doorCloseSoundTime = doorCloseSoundTime;
            this.useAccelerationSoundsWhenCoasting = useAccelerationSoundsWhenCoasting;
        }

        public void playSpeedSoundEffect(World world, BlockPos pos, float oldSpeed, float speed) {
            int floorSpeed;
            if (world instanceof ClientWorld && MTRClient.canPlaySound() && this.speedSoundCount > 0 && this.speedSoundBaseId != null && (floorSpeed = (int)Math.floor(speed / 0.01f / 4.0f)) > 0) {
                int index = Math.min(floorSpeed, this.speedSoundCount) - 1;
                boolean isAccelerating = speed == oldSpeed ? this.useAccelerationSoundsWhenCoasting || new Random().nextBoolean() : speed > oldSpeed;
                String soundId = this.speedSoundBaseId + (isAccelerating ? TrainClientRegistry.SOUND_ACCELERATION : TrainClientRegistry.SOUND_DECELERATION) + index / this.SOUND_GROUP_SIZE + this.SOUND_GROUP_LETTERS[index % this.SOUND_GROUP_SIZE];
                ((ClientWorld)world).func_184156_a(pos, new SoundEvent(new ResourceLocation("mtr", soundId)), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }

        public void playDoorSoundEffect(World world, BlockPos pos, float oldDoorValue, float doorValue) {
            String soundId;
            if (world instanceof ClientWorld && this.doorSoundBaseId != null && (soundId = oldDoorValue <= 0.0f && doorValue > 0.0f ? this.doorSoundBaseId + TrainClientRegistry.SOUND_DOOR_OPEN : (oldDoorValue >= this.doorCloseSoundTime && doorValue < this.doorCloseSoundTime ? this.doorSoundBaseId + TrainClientRegistry.SOUND_DOOR_CLOSE : null)) != null) {
                ((ClientWorld)world).func_184156_a(pos, new SoundEvent(new ResourceLocation("mtr", soundId)), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }

        private static String resolvePath(String path) {
            return path == null ? null : path.toLowerCase().split("\\.png")[0];
        }
    }
}

