/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.MessagePackHelper;
import mtr.data.SavedRailBase;
import mtr.data.TransportMode;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Platform
extends SavedRailBase {
    private int dwellTime;
    public static final int MAX_DWELL_TIME = 120;
    private static final int DEFAULT_DWELL_TIME = 20;
    private static final String KEY_DWELL_TIME = "dwell_time";

    public Platform(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(id, transportMode, pos1, pos2);
        this.dwellTime = 20;
    }

    public Platform(TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(transportMode, pos1, pos2);
        this.dwellTime = 20;
    }

    public Platform(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.dwellTime = messagePackHelper.getInt(KEY_DWELL_TIME);
    }

    @Deprecated
    public Platform(CompoundNBT compoundTag) {
        super(compoundTag);
        this.dwellTime = compoundTag.func_74762_e(KEY_DWELL_TIME);
    }

    public Platform(PacketBuffer packet) {
        super(packet);
        this.dwellTime = packet.readInt();
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_DWELL_TIME).packInt(this.dwellTime);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 1;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        packet.writeInt(this.dwellTime);
    }

    @Override
    public void update(String key, PacketBuffer packet) {
        if (KEY_DWELL_TIME.equals(key)) {
            this.name = packet.func_150789_c(Short.MAX_VALUE);
            this.color = packet.readInt();
            this.dwellTime = packet.readInt();
        } else {
            super.update(key, packet);
        }
    }

    public int getDwellTime() {
        if (this.dwellTime <= 0 || this.dwellTime > 120) {
            this.dwellTime = 20;
        }
        return this.dwellTime;
    }

    public void setDwellTime(int newDwellTime, Consumer<PacketBuffer> sendPacket) {
        this.dwellTime = newDwellTime <= 0 || newDwellTime > 120 ? 20 : newDwellTime;
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_DWELL_TIME);
        packet.func_180714_a(this.name);
        packet.writeInt(this.color);
        packet.writeInt(this.dwellTime);
        sendPacket.accept(packet);
    }
}

