/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.block.BlockNode;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SerializedDataBase;
import mtr.data.TransportMode;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class Rail
extends SerializedDataBase {
    public final RailType railType;
    public final TransportMode transportMode;
    public final RailAngle facingStart;
    public final RailAngle facingEnd;
    private final double h1;
    private final double k1;
    private final double r1;
    private final double tStart1;
    private final double tEnd1;
    private final double h2;
    private final double k2;
    private final double r2;
    private final double tStart2;
    private final double tEnd2;
    private final int yStart;
    private final int yEnd;
    private final boolean reverseT1;
    private final boolean isStraight1;
    private final boolean reverseT2;
    private final boolean isStraight2;
    private static final double ACCEPT_THRESHOLD = 1.0E-4;
    private static final int MIN_RADIUS = 2;
    private static final String KEY_H_1 = "h_1";
    private static final String KEY_K_1 = "k_1";
    private static final String KEY_H_2 = "h_2";
    private static final String KEY_K_2 = "k_2";
    private static final String KEY_R_1 = "r_1";
    private static final String KEY_R_2 = "r_2";
    private static final String KEY_T_START_1 = "t_start_1";
    private static final String KEY_T_END_1 = "t_end_1";
    private static final String KEY_T_START_2 = "t_start_2";
    private static final String KEY_T_END_2 = "t_end_2";
    private static final String KEY_Y_START = "y_start";
    private static final String KEY_Y_END = "y_end";
    private static final String KEY_REVERSE_T_1 = "reverse_t_1";
    private static final String KEY_IS_STRAIGHT_1 = "is_straight_1";
    private static final String KEY_REVERSE_T_2 = "reverse_t_2";
    private static final String KEY_IS_STRAIGHT_2 = "is_straight_2";
    private static final String KEY_RAIL_TYPE = "rail_type";
    private static final String KEY_TRANSPORT_MODE = "transport_mode";

    public Rail(BlockPos posStart, RailAngle facingStart, BlockPos posEnd, RailAngle facingEnd, RailType railType, TransportMode transportMode) {
        this.facingStart = facingStart;
        this.facingEnd = facingEnd;
        this.railType = railType;
        this.transportMode = transportMode;
        this.yStart = posStart.func_177956_o();
        this.yEnd = posEnd.func_177956_o();
        int xStart = posStart.func_177958_n();
        int zStart = posStart.func_177952_p();
        int xEnd = posEnd.func_177958_n();
        int zEnd = posEnd.func_177952_p();
        Vector3d vecDifference = new Vector3d((double)(posEnd.func_177958_n() - posStart.func_177958_n()), 0.0, (double)(posEnd.func_177952_p() - posStart.func_177952_p()));
        Vector3d vecDifferenceRotated = vecDifference.func_178785_b((float)facingStart.angleRadians);
        double deltaForward = vecDifferenceRotated.field_72449_c;
        double deltaSide = vecDifferenceRotated.field_72450_a;
        if (facingStart.isParallel(facingEnd)) {
            if (Math.abs(deltaForward) < 1.0E-4) {
                this.h1 = facingStart.cos;
                this.k1 = facingStart.sin;
                if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                    this.tStart1 = (double)xStart / this.h1;
                    this.tEnd1 = (double)xEnd / this.h1;
                } else {
                    double div = facingStart.add((RailAngle)facingStart).cos;
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                    this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                    this.tEnd1 = (this.h1 * (double)xEnd - this.k1 * (double)zEnd) / div;
                }
                this.r2 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.reverseT1 = this.tStart1 > this.tEnd1;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
                this.tEnd2 = 0.0;
                this.tStart2 = 0.0;
            } else if (Math.abs(deltaSide) > 1.0E-4) {
                double radius = (deltaForward * deltaForward + deltaSide * deltaSide) / (4.0 * deltaForward);
                this.r1 = this.r2 = Math.abs(radius);
                this.h1 = (double)xStart - radius * facingStart.sin;
                this.k1 = (double)zStart + radius * facingStart.cos;
                this.h2 = (double)xEnd - radius * facingEnd.sin;
                this.k2 = (double)zEnd + radius * facingEnd.cos;
                this.reverseT1 = deltaForward < 0.0 != deltaSide < 0.0;
                this.reverseT2 = !this.reverseT1;
                this.tStart1 = Rail.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                this.tEnd1 = Rail.getTBounds((double)xStart + vecDifference.field_72450_a / 2.0, this.h1, (double)zStart + vecDifference.field_72449_c / 2.0, this.k1, this.r1, this.tStart1, this.reverseT1);
                this.tStart2 = Rail.getTBounds((double)xStart + vecDifference.field_72450_a / 2.0, this.h2, (double)zStart + vecDifference.field_72449_c / 2.0, this.k2, this.r2);
                this.tEnd2 = Rail.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                this.isStraight2 = false;
                this.isStraight1 = false;
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        } else {
            RailAngle newFacingStart = vecDifferenceRotated.field_72450_a < -1.0E-4 ? facingStart.getOpposite() : facingStart;
            RailAngle newFacingEnd = facingEnd.cos * vecDifference.field_72450_a + facingEnd.sin * vecDifference.field_72449_c < -1.0E-4 ? facingEnd.getOpposite() : facingEnd;
            double angleForward = Math.atan2(deltaForward, deltaSide);
            RailAngle railAngleDifference = newFacingEnd.sub(newFacingStart);
            double angleDifference = railAngleDifference.angleRadians;
            if (Math.signum(angleForward) == Math.signum(angleDifference)) {
                double absAngleForward = Math.abs(angleForward);
                if (absAngleForward - Math.abs(angleDifference / 2.0) < 1.0E-4) {
                    double offsetSide = Math.abs(deltaForward / railAngleDifference.halfTan);
                    double remainingSide = deltaSide - offsetSide;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin;
                    this.h1 = newFacingStart.cos;
                    this.k1 = newFacingStart.sin;
                    if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                        this.tStart1 = (double)xStart / this.h1;
                        this.tEnd1 = deltaXEnd / this.h1;
                    } else {
                        double div = newFacingStart.add((RailAngle)newFacingStart).cos;
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                        this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                        this.tEnd1 = (this.h1 * deltaXEnd - this.k1 * deltaZEnd) / div;
                    }
                    this.isStraight1 = true;
                    this.reverseT1 = this.tStart1 > this.tEnd1;
                    double radius = deltaForward / (1.0 - railAngleDifference.cos);
                    this.r2 = Math.abs(radius);
                    this.h2 = deltaXEnd - radius * newFacingStart.sin;
                    this.k2 = deltaZEnd + radius * newFacingStart.cos;
                    this.reverseT2 = deltaForward < 0.0;
                    this.tStart2 = Rail.getTBounds(deltaXEnd, this.h2, deltaZEnd, this.k2, this.r2);
                    this.tEnd2 = Rail.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                    this.isStraight2 = false;
                } else if (absAngleForward - Math.abs(angleDifference) < 1.0E-4) {
                    double crossSide = deltaForward / railAngleDifference.tan;
                    double remainingSide = (deltaSide - crossSide) * (1.0 + railAngleDifference.cos);
                    double remainingForward = (deltaSide - crossSide) * railAngleDifference.sin;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos - remainingForward * newFacingStart.sin;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin + remainingForward * newFacingStart.cos;
                    double radius = (deltaSide - deltaForward / railAngleDifference.tan) / railAngleDifference.halfTan;
                    this.r1 = Math.abs(radius);
                    this.h1 = (double)xStart - radius * newFacingStart.sin;
                    this.k1 = (double)zStart + radius * newFacingStart.cos;
                    this.isStraight1 = false;
                    this.reverseT1 = deltaForward < 0.0;
                    this.tStart1 = Rail.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                    this.tEnd1 = Rail.getTBounds(deltaXEnd, this.h1, deltaZEnd, this.k1, this.r1, this.tStart1, this.reverseT1);
                    this.h2 = newFacingEnd.cos;
                    this.k2 = newFacingEnd.sin;
                    if (Math.abs(this.h2) >= 0.5 && Math.abs(this.k2) >= 0.5) {
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / this.h2 / this.h2;
                        this.tStart2 = deltaXEnd / this.h2;
                        this.tEnd2 = (double)xEnd / this.h2;
                    } else {
                        double div = newFacingEnd.add((RailAngle)newFacingEnd).cos;
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / div;
                        this.tStart2 = (this.h2 * deltaXEnd - this.k2 * deltaZEnd) / div;
                        this.tEnd2 = (this.h2 * (double)xEnd - this.k2 * (double)zEnd) / div;
                    }
                    this.isStraight2 = true;
                    this.reverseT2 = this.tStart2 > this.tEnd2;
                } else {
                    this.r2 = 0.0;
                    this.r1 = 0.0;
                    this.k2 = 0.0;
                    this.h2 = 0.0;
                    this.k1 = 0.0;
                    this.h1 = 0.0;
                    this.tEnd2 = 0.0;
                    this.tEnd1 = 0.0;
                    this.tStart2 = 0.0;
                    this.tStart1 = 0.0;
                    this.reverseT1 = false;
                    this.reverseT2 = false;
                    this.isStraight2 = true;
                    this.isStraight1 = true;
                }
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        }
    }

    public Rail(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.h1 = messagePackHelper.getDouble(KEY_H_1);
        this.k1 = messagePackHelper.getDouble(KEY_K_1);
        this.h2 = messagePackHelper.getDouble(KEY_H_2);
        this.k2 = messagePackHelper.getDouble(KEY_K_2);
        this.r1 = messagePackHelper.getDouble(KEY_R_1);
        this.r2 = messagePackHelper.getDouble(KEY_R_2);
        this.tStart1 = messagePackHelper.getDouble(KEY_T_START_1);
        this.tEnd1 = messagePackHelper.getDouble(KEY_T_END_1);
        this.tStart2 = messagePackHelper.getDouble(KEY_T_START_2);
        this.tEnd2 = messagePackHelper.getDouble(KEY_T_END_2);
        this.yStart = messagePackHelper.getInt(KEY_Y_START);
        this.yEnd = messagePackHelper.getInt(KEY_Y_END);
        this.reverseT1 = messagePackHelper.getBoolean(KEY_REVERSE_T_1);
        this.isStraight1 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_1);
        this.reverseT2 = messagePackHelper.getBoolean(KEY_REVERSE_T_2);
        this.isStraight2 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_2);
        this.railType = EnumHelper.valueOf(RailType.IRON, messagePackHelper.getString(KEY_RAIL_TYPE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, messagePackHelper.getString(KEY_TRANSPORT_MODE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    @Deprecated
    public Rail(CompoundNBT compoundTag) {
        this.h1 = compoundTag.func_74769_h(KEY_H_1);
        this.k1 = compoundTag.func_74769_h(KEY_K_1);
        this.h2 = compoundTag.func_74769_h(KEY_H_2);
        this.k2 = compoundTag.func_74769_h(KEY_K_2);
        this.r1 = compoundTag.func_74769_h(KEY_R_1);
        this.r2 = compoundTag.func_74769_h(KEY_R_2);
        this.tStart1 = compoundTag.func_74769_h(KEY_T_START_1);
        this.tEnd1 = compoundTag.func_74769_h(KEY_T_END_1);
        this.tStart2 = compoundTag.func_74769_h(KEY_T_START_2);
        this.tEnd2 = compoundTag.func_74769_h(KEY_T_END_2);
        this.yStart = compoundTag.func_74762_e(KEY_Y_START);
        this.yEnd = compoundTag.func_74762_e(KEY_Y_END);
        this.reverseT1 = compoundTag.func_74767_n(KEY_REVERSE_T_1);
        this.isStraight1 = compoundTag.func_74767_n(KEY_IS_STRAIGHT_1);
        this.reverseT2 = compoundTag.func_74767_n(KEY_REVERSE_T_2);
        this.isStraight2 = compoundTag.func_74767_n(KEY_IS_STRAIGHT_2);
        this.railType = EnumHelper.valueOf(RailType.IRON, compoundTag.func_74779_i(KEY_RAIL_TYPE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, compoundTag.func_74779_i(KEY_TRANSPORT_MODE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    public Rail(PacketBuffer packet) {
        this.h1 = packet.readDouble();
        this.k1 = packet.readDouble();
        this.h2 = packet.readDouble();
        this.k2 = packet.readDouble();
        this.r1 = packet.readDouble();
        this.r2 = packet.readDouble();
        this.tStart1 = packet.readDouble();
        this.tEnd1 = packet.readDouble();
        this.tStart2 = packet.readDouble();
        this.tEnd2 = packet.readDouble();
        this.yStart = packet.readInt();
        this.yEnd = packet.readInt();
        this.reverseT1 = packet.readBoolean();
        this.isStraight1 = packet.readBoolean();
        this.reverseT2 = packet.readBoolean();
        this.isStraight2 = packet.readBoolean();
        this.railType = EnumHelper.valueOf(RailType.IRON, packet.func_150789_c(Short.MAX_VALUE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.func_150789_c(Short.MAX_VALUE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_H_1).packDouble(this.h1);
        messagePacker.packString(KEY_K_1).packDouble(this.k1);
        messagePacker.packString(KEY_H_2).packDouble(this.h2);
        messagePacker.packString(KEY_K_2).packDouble(this.k2);
        messagePacker.packString(KEY_R_1).packDouble(this.r1);
        messagePacker.packString(KEY_R_2).packDouble(this.r2);
        messagePacker.packString(KEY_T_START_1).packDouble(this.tStart1);
        messagePacker.packString(KEY_T_END_1).packDouble(this.tEnd1);
        messagePacker.packString(KEY_T_START_2).packDouble(this.tStart2);
        messagePacker.packString(KEY_T_END_2).packDouble(this.tEnd2);
        messagePacker.packString(KEY_Y_START).packInt(this.yStart);
        messagePacker.packString(KEY_Y_END).packInt(this.yEnd);
        messagePacker.packString(KEY_REVERSE_T_1).packBoolean(this.reverseT1);
        messagePacker.packString(KEY_IS_STRAIGHT_1).packBoolean(this.isStraight1);
        messagePacker.packString(KEY_REVERSE_T_2).packBoolean(this.reverseT2);
        messagePacker.packString(KEY_IS_STRAIGHT_2).packBoolean(this.isStraight2);
        messagePacker.packString(KEY_RAIL_TYPE).packString(this.railType.toString());
        messagePacker.packString(KEY_TRANSPORT_MODE).packString(this.transportMode.toString());
    }

    @Override
    public int messagePackLength() {
        return 18;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        packet.writeDouble(this.h1);
        packet.writeDouble(this.k1);
        packet.writeDouble(this.h2);
        packet.writeDouble(this.k2);
        packet.writeDouble(this.r1);
        packet.writeDouble(this.r2);
        packet.writeDouble(this.tStart1);
        packet.writeDouble(this.tEnd1);
        packet.writeDouble(this.tStart2);
        packet.writeDouble(this.tEnd2);
        packet.writeInt(this.yStart);
        packet.writeInt(this.yEnd);
        packet.writeBoolean(this.reverseT1);
        packet.writeBoolean(this.isStraight1);
        packet.writeBoolean(this.reverseT2);
        packet.writeBoolean(this.isStraight2);
        packet.func_180714_a(this.railType.toString());
        packet.func_180714_a(this.transportMode.toString());
    }

    public Vector3d getPosition(double rawValue) {
        double count1 = Math.abs(this.tEnd1 - this.tStart1);
        double count2 = Math.abs(this.tEnd2 - this.tStart2);
        double value = MathHelper.func_151237_a((double)rawValue, (double)0.0, (double)(count1 + count2));
        double y = this.getPositionY(value);
        if (value <= count1) {
            return Rail.getPositionXZ(this.h1, this.k1, this.r1, (double)(this.reverseT1 ? -1 : 1) * value + this.tStart1, 0.0, this.isStraight1).func_72441_c(0.0, y, 0.0);
        }
        return Rail.getPositionXZ(this.h2, this.k2, this.r2, (double)(this.reverseT2 ? -1 : 1) * (value - count1) + this.tStart2, 0.0, this.isStraight2).func_72441_c(0.0, y, 0.0);
    }

    public double getLength() {
        return Math.abs(this.tEnd2 - this.tStart2) + Math.abs(this.tEnd1 - this.tStart1);
    }

    public void render(RenderRail callback, float offsetRadius1, float offsetRadius2) {
        this.renderSegment(this.h1, this.k1, this.r1, this.tStart1, this.tEnd1, 0.0, offsetRadius1, offsetRadius2, this.reverseT1, this.isStraight1, callback);
        this.renderSegment(this.h2, this.k2, this.r2, this.tStart2, this.tEnd2, Math.abs(this.tEnd1 - this.tStart1), offsetRadius1, offsetRadius2, this.reverseT2, this.isStraight2, callback);
    }

    public boolean goodRadius() {
        return (this.isStraight1 || this.r1 > 1.9999) && (this.isStraight2 || this.r2 > 1.9999);
    }

    public boolean isValid() {
        return (this.h1 != 0.0 || this.k1 != 0.0 || this.h2 != 0.0 || this.k2 != 0.0 || this.r1 != 0.0 || this.r2 != 0.0 || this.tStart1 != 0.0 || this.tStart2 != 0.0 || this.tEnd1 != 0.0 || this.tEnd2 != 0.0) && this.facingStart == this.getRailAngle(false) && this.facingEnd == this.getRailAngle(true);
    }

    private double getPositionY(double value) {
        double offsetValue;
        double yInitial;
        double yChange;
        double intercept = this.getLength() / 2.0;
        if (value < intercept) {
            yChange = (float)(this.yEnd - this.yStart) / 2.0f;
            yInitial = this.yStart;
            offsetValue = value;
        } else {
            yChange = (float)(this.yStart - this.yEnd) / 2.0f;
            yInitial = this.yEnd;
            offsetValue = this.getLength() - value;
        }
        return yChange * offsetValue * offsetValue / (intercept * intercept) + yInitial;
    }

    private static Vector3d getPositionXZ(double h, double k, double r, double t, double radiusOffset, boolean isStraight) {
        if (isStraight) {
            return new Vector3d(h * t + k * ((Math.abs(h) >= 0.5 && Math.abs(k) >= 0.5 ? 0.0 : r) + radiusOffset) + 0.5, 0.0, k * t + h * (r - radiusOffset) + 0.5);
        }
        return new Vector3d(h + (r + radiusOffset) * Math.cos(t / r) + 0.5, 0.0, k + (r + radiusOffset) * Math.sin(t / r) + 0.5);
    }

    private void renderSegment(double h, double k, double r, double tStart, double tEnd, double rawValueOffset, float offsetRadius1, float offsetRadius2, boolean reverseT, boolean isStraight, RenderRail callback) {
        double count = Math.abs(tEnd - tStart);
        double increment = count / (double)Math.round(count);
        for (double i = 0.0; i < count - 0.1; i += increment) {
            double t1 = (double)(reverseT ? -1 : 1) * i + tStart;
            double t2 = (double)(reverseT ? -1 : 1) * (i + increment) + tStart;
            Vector3d corner1 = Rail.getPositionXZ(h, k, r, t1, offsetRadius1, isStraight);
            Vector3d corner2 = Rail.getPositionXZ(h, k, r, t1, offsetRadius2, isStraight);
            Vector3d corner3 = Rail.getPositionXZ(h, k, r, t2, offsetRadius2, isStraight);
            Vector3d corner4 = Rail.getPositionXZ(h, k, r, t2, offsetRadius1, isStraight);
            double y1 = this.getPositionY(i + rawValueOffset);
            double y2 = this.getPositionY(i + increment + rawValueOffset);
            callback.renderRail(corner1.field_72450_a, corner1.field_72449_c, corner2.field_72450_a, corner2.field_72449_c, corner3.field_72450_a, corner3.field_72449_c, corner4.field_72450_a, corner4.field_72449_c, y1, y2);
        }
    }

    private RailAngle getRailAngle(boolean getEnd) {
        double end;
        double start;
        if (getEnd) {
            start = this.getLength();
            end = start - 1.0E-4;
        } else {
            start = 0.0;
            end = 1.0E-4;
        }
        Vector3d pos1 = this.getPosition(start);
        Vector3d pos2 = this.getPosition(end);
        return RailAngle.fromAngle((float)Math.toDegrees(Math.atan2(pos2.field_72449_c - pos1.field_72449_c, pos2.field_72450_a - pos1.field_72450_a)));
    }

    private static double getTBounds(double x, double h, double z, double k, double r) {
        return MathHelper.func_181159_b((double)(z - k), (double)(x - h)) * r;
    }

    private static double getTBounds(double x, double h, double z, double k, double r, double tStart, boolean reverse) {
        double t = Rail.getTBounds(x, h, z, k, r);
        if (t < tStart && !reverse) {
            return t + Math.PI * 2 * r;
        }
        if (t > tStart && reverse) {
            return t - Math.PI * 2 * r;
        }
        return t;
    }

    @FunctionalInterface
    public static interface RenderRail {
        public void renderRail(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);
    }

    public static enum RailActionType {
        BRIDGE("percentage_complete_bridge", "rail_action_bridge", MaterialColor.field_197656_x),
        TUNNEL("percentage_complete_tunnel", "rail_action_tunnel", MaterialColor.field_151650_B),
        TUNNEL_WALL("percentage_complete_tunnel_wall", "rail_action_tunnel_wall", MaterialColor.field_151670_w);

        private final String progressTranslation;
        private final String nameTranslation;
        private final int color;

        private RailActionType(String progressTranslation, String nameTranslation, MaterialColor materialColor) {
            this.progressTranslation = progressTranslation;
            this.nameTranslation = nameTranslation;
            this.color = materialColor.field_76291_p;
        }
    }

    public static class RailActions {
        private double distance;
        public final long id;
        private final World world;
        private final UUID uuid;
        private final String playerName;
        private final RailActionType railActionType;
        private final Rail rail;
        private final int radius;
        private final int height;
        private final double length;
        private final BlockState state;
        private final boolean isSlab;
        private final Set<BlockPos> blacklistedPos = new HashSet<BlockPos>();
        private static final double INCREMENT = 0.01;

        public RailActions(World world, PlayerEntity player, RailActionType railActionType, Rail rail, int radius, int height, BlockState state) {
            this.id = new Random().nextLong();
            this.world = world;
            this.uuid = player.func_110124_au();
            this.playerName = player.func_200200_C_().getString();
            this.railActionType = railActionType;
            this.rail = rail;
            this.radius = radius;
            this.height = height;
            this.state = state;
            this.isSlab = state != null && state.func_177230_c() instanceof SlabBlock;
            this.length = rail.getLength();
            this.distance = 0.0;
        }

        public boolean build() {
            switch (this.railActionType) {
                case BRIDGE: {
                    return this.createBridge();
                }
                case TUNNEL: {
                    return this.createTunnel();
                }
                case TUNNEL_WALL: {
                    return this.createTunnelWall();
                }
            }
            return true;
        }

        public void writePacket(PacketBuffer packet) {
            packet.writeLong(this.id);
            packet.func_180714_a(this.playerName);
            packet.writeFloat(RailwayData.round(this.length, 1));
            packet.func_180714_a(this.state == null ? "" : this.state.func_177230_c().func_149739_a());
            packet.func_180714_a(this.railActionType.nameTranslation);
            packet.writeInt(this.railActionType.color);
        }

        private boolean createTunnel() {
            return this.create(true, editPos -> {
                BlockPos pos = new BlockPos(editPos);
                if (!this.blacklistedPos.contains(pos) && RailActions.canPlace(this.world, pos)) {
                    this.world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.blacklistedPos.add(pos);
                }
            });
        }

        private boolean createTunnelWall() {
            return this.create(false, editPos -> {
                BlockPos pos = new BlockPos(editPos);
                if (!this.blacklistedPos.contains(pos) && RailActions.canPlace(this.world, pos)) {
                    this.world.func_175656_a(pos, this.state);
                    this.blacklistedPos.add(pos);
                }
            });
        }

        private boolean createBridge() {
            return this.create(false, editPos -> {
                boolean placeHalf;
                BlockState placeState;
                BlockPos placePos;
                BlockPos pos = new BlockPos(editPos);
                boolean isTopHalf = editPos.field_72448_b - Math.floor(editPos.field_72448_b) >= 0.5;
                this.blacklistedPos.add(RailActions.getHalfPos(pos, isTopHalf));
                if (this.isSlab && isTopHalf) {
                    placePos = pos;
                    placeState = (BlockState)this.state.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                    placeHalf = false;
                } else {
                    placePos = pos.func_177977_b();
                    placeState = this.isSlab ? (BlockState)this.state.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP) : this.state;
                    placeHalf = true;
                }
                if (placePos != pos && RailActions.canPlace(this.world, pos)) {
                    this.world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                if (!this.blacklistedPos.contains(RailActions.getHalfPos(placePos, placeHalf)) && RailActions.canPlace(this.world, placePos)) {
                    this.world.func_175656_a(placePos, placeState);
                }
            });
        }

        private boolean create(boolean includeMiddle, Consumer<Vector3d> consumer) {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 2L) {
                Vector3d pos1 = this.rail.getPosition(this.distance);
                this.distance += 0.01;
                Vector3d pos2 = this.rail.getPosition(this.distance);
                Vector3d vec3 = new Vector3d(pos2.field_72450_a - pos1.field_72450_a, 0.0, pos2.field_72449_c - pos1.field_72449_c).func_72432_b().func_178785_b(1.5707964f);
                for (double x = (double)(-this.radius); x <= (double)this.radius; x += 0.01) {
                    boolean wholeNumber;
                    Vector3d editPos = pos1.func_178787_e(vec3.func_216372_d(x, 0.0, x));
                    boolean bl = wholeNumber = Math.floor(editPos.field_72448_b) == Math.ceil(editPos.field_72448_b);
                    if (includeMiddle || Math.abs(x) > (double)this.radius - 0.01) {
                        for (int y = 0; y <= this.height; ++y) {
                            if (y >= this.height && wholeNumber) continue;
                            consumer.accept(editPos.func_72441_c(0.0, (double)y, 0.0));
                        }
                        continue;
                    }
                    consumer.accept(editPos.func_72441_c(0.0, (double)Math.max(0, wholeNumber ? this.height - 1 : this.height), 0.0));
                }
                if (!(this.length - this.distance < 0.01)) continue;
                this.showProgressMessage(100.0f);
                return true;
            }
            this.showProgressMessage(RailwayData.round(100.0 * this.distance / this.length, 1));
            return false;
        }

        private void showProgressMessage(float percentage) {
            PlayerEntity player = this.world.func_217371_b(this.uuid);
            if (player != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr." + this.railActionType.progressTranslation, new Object[]{Float.valueOf(percentage)}), true);
            }
        }

        private static boolean canPlace(World world, BlockPos pos) {
            return world.func_175625_s(pos) == null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockNode);
        }

        private static BlockPos getHalfPos(BlockPos pos, boolean isTopHalf) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o() * 2 + (isTopHalf ? 1 : 0), pos.func_177952_p());
        }
    }
}

