/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mtr.MTR;
import mtr.Registry;
import mtr.block.BlockNode;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.MessagePackHelper;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayDataCoolDownModule;
import mtr.data.RailwayDataFileSaveModule;
import mtr.data.RailwayDataPathGenerationModule;
import mtr.data.RailwayDataRailActionsModule;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.ScheduleEntry;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainServer;
import mtr.data.TransportMode;
import mtr.mappings.PersistentStateMapper;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.path.PathData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class RailwayData
extends PersistentStateMapper
implements IPacket {
    public final Set<Station> stations = new HashSet<Station>();
    public final Set<Platform> platforms = new HashSet<Platform>();
    public final Set<Siding> sidings = new HashSet<Siding>();
    public final Set<Route> routes = new HashSet<Route>();
    public final Set<Depot> depots = new HashSet<Depot>();
    public final DataCache dataCache = new DataCache(this.stations, this.platforms, this.sidings, this.routes, this.depots);
    public final RailwayDataCoolDownModule railwayDataCoolDownModule;
    public final RailwayDataPathGenerationModule railwayDataPathGenerationModule;
    public final RailwayDataRailActionsModule railwayDataRailActionsModule;
    private int prevPlatformCount;
    private int prevSidingCount;
    private final World world;
    private final Map<BlockPos, Map<BlockPos, Rail>> rails = new HashMap<BlockPos, Map<BlockPos, Rail>>();
    private final SignalBlocks signalBlocks = new SignalBlocks();
    private final RailwayDataFileSaveModule railwayDataFileSaveModule;
    private final List<Map<UUID, Long>> trainPositions = new ArrayList<Map<UUID, Long>>(2);
    private final Map<PlayerEntity, BlockPos> playerLastUpdatedPositions = new HashMap<PlayerEntity, BlockPos>();
    private final List<PlayerEntity> playersToSyncSchedules = new ArrayList<PlayerEntity>();
    private final Map<PlayerEntity, Set<TrainServer>> trainsInPlayerRange = new HashMap<PlayerEntity, Set<TrainServer>>();
    private final Map<Long, List<ScheduleEntry>> schedulesForPlatform = new HashMap<Long, List<ScheduleEntry>>();
    private static final int RAIL_UPDATE_DISTANCE = 128;
    private static final int PLAYER_MOVE_UPDATE_THRESHOLD = 16;
    private static final int SCHEDULE_UPDATE_TICKS = 60;
    private static final int DATA_VERSION = 1;
    private static final String NAME = "mtr_train_data";
    private static final String KEY_RAW_MESSAGE_PACK = "raw_message_pack";
    private static final String KEY_DATA_VERSION = "mtr_data_version";
    private static final String KEY_STATIONS = "stations";
    private static final String KEY_PLATFORMS = "platforms";
    private static final String KEY_SIDINGS = "sidings";
    private static final String KEY_ROUTES = "routes";
    private static final String KEY_DEPOTS = "depots";
    private static final String KEY_RAILS = "rails";
    private static final String KEY_SIGNAL_BLOCKS = "signal_blocks";

    public RailwayData(World world) {
        super(NAME);
        this.world = world;
        this.trainPositions.add(new HashMap());
        this.trainPositions.add(new HashMap());
        this.railwayDataFileSaveModule = new RailwayDataFileSaveModule(this, world, this.rails, this.signalBlocks);
        this.railwayDataPathGenerationModule = new RailwayDataPathGenerationModule(this, world, this.rails);
        this.railwayDataRailActionsModule = new RailwayDataRailActionsModule(this, world, this.rails);
        this.railwayDataCoolDownModule = new RailwayDataCoolDownModule(this, world, this.rails);
    }

    @Override
    public void func_76184_a(CompoundNBT compoundTag) {
        if (compoundTag.func_74764_b(KEY_RAW_MESSAGE_PACK)) {
            try {
                MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(compoundTag.func_74770_j(KEY_RAW_MESSAGE_PACK));
                int mapSize = messageUnpacker.unpackMapHeader();
                block22: for (int i = 0; i < mapSize; ++i) {
                    String key = messageUnpacker.unpackString();
                    if (key.equals(KEY_DATA_VERSION)) {
                        if (messageUnpacker.unpackInt() <= 1) continue;
                        throw new IllegalArgumentException("Unsupported data version");
                    }
                    int arraySize = messageUnpacker.unpackArrayHeader();
                    switch (key) {
                        case "stations": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.stations.add(new Station(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                        case "platforms": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.platforms.add(new Platform(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                        case "sidings": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.sidings.add(new Siding(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                        case "routes": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.routes.add(new Route(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                        case "depots": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.depots.add(new Depot(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                        case "rails": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                RailEntry railEntry = new RailEntry(RailwayData.readMessagePackSKMap(messageUnpacker));
                                this.rails.put(railEntry.pos, railEntry.connections);
                            }
                            continue block22;
                        }
                        case "signal_blocks": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block22;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                CompoundNBT tagStations = compoundTag.func_74775_l(KEY_STATIONS);
                for (Object key : tagStations.func_150296_c()) {
                    this.stations.add(new Station(tagStations.func_74775_l((String)key)));
                }
                CompoundNBT tagNewPlatforms = compoundTag.func_74775_l(KEY_PLATFORMS);
                for (Object key : tagNewPlatforms.func_150296_c()) {
                    this.platforms.add(new Platform(tagNewPlatforms.func_74775_l((String)key)));
                }
                CompoundNBT tagNewSidings = compoundTag.func_74775_l(KEY_SIDINGS);
                for (Object key : tagNewSidings.func_150296_c()) {
                    this.sidings.add(new Siding(tagNewSidings.func_74775_l((String)key)));
                }
                CompoundNBT tagNewRoutes = compoundTag.func_74775_l(KEY_ROUTES);
                for (Object key : tagNewRoutes.func_150296_c()) {
                    this.routes.add(new Route(tagNewRoutes.func_74775_l((String)key)));
                }
                CompoundNBT tagNewDepots = compoundTag.func_74775_l(KEY_DEPOTS);
                for (Object key : tagNewDepots.func_150296_c()) {
                    this.depots.add(new Depot(tagNewDepots.func_74775_l((String)key)));
                }
                CompoundNBT tagNewRails = compoundTag.func_74775_l(KEY_RAILS);
                for (String key : tagNewRails.func_150296_c()) {
                    RailEntry railEntry = new RailEntry(tagNewRails.func_74775_l(key));
                    this.rails.put(railEntry.pos, railEntry.connections);
                }
                CompoundNBT tagNewSignalBlocks = compoundTag.func_74775_l(KEY_SIGNAL_BLOCKS);
                for (String key : tagNewSignalBlocks.func_150296_c()) {
                    this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(tagNewSignalBlocks.func_74775_l(key)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.railwayDataFileSaveModule.load();
        this.validateData();
        this.dataCache.sync();
        this.signalBlocks.writeCache();
    }

    public void func_215158_a(File file) {
        MinecraftServer minecraftServer = ((ServerWorld)this.world).func_73046_m();
        if (minecraftServer.func_71241_aa() || !minecraftServer.func_71278_l()) {
            this.railwayDataFileSaveModule.fullSave();
        } else {
            this.railwayDataFileSaveModule.autoSave();
        }
        this.func_76185_a();
        super.func_215158_a(file);
    }

    public CompoundNBT func_189551_b(CompoundNBT compoundTag) {
        return compoundTag;
    }

    public void simulateTrains() {
        List players = this.world.func_217369_A();
        players.forEach(player -> {
            BlockPos playerBlockPos = player.func_233580_cy_();
            Vector3d playerPos = player.func_213303_ch();
            if (!this.playerLastUpdatedPositions.containsKey(player) || this.playerLastUpdatedPositions.get(player).func_218139_n((Vector3i)playerBlockPos) > 16) {
                HashMap<BlockPos, Map> railsToAdd = new HashMap<BlockPos, Map>();
                this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                    if (new AxisAlignedBB(startPos, endPos).func_186662_g(128.0).func_72318_a(playerPos)) {
                        if (!railsToAdd.containsKey(startPos)) {
                            railsToAdd.put((BlockPos)startPos, new HashMap());
                        }
                        ((Map)railsToAdd.get(startPos)).put(endPos, rail);
                    }
                }));
                PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                packet.writeInt(railsToAdd.size());
                railsToAdd.forEach((posStart, railMap) -> {
                    packet.func_179255_a(posStart);
                    packet.writeInt(railMap.size());
                    railMap.forEach((posEnd, rail) -> {
                        packet.func_179255_a(posEnd);
                        rail.writePacket(packet);
                    });
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_WRITE_RAILS, packet);
                }
                this.playerLastUpdatedPositions.put((PlayerEntity)player, playerBlockPos);
            }
        });
        this.trainPositions.remove(0);
        this.trainPositions.add(new HashMap());
        HashMap<PlayerEntity, Set> newTrainsInPlayerRange = new HashMap<PlayerEntity, Set>();
        HashSet trainsToSync = new HashSet();
        this.schedulesForPlatform.clear();
        this.signalBlocks.resetOccupied();
        this.sidings.forEach(siding -> {
            siding.setSidingData(this.world, this.dataCache.sidingIdToDepot.get(siding.id), this.rails);
            siding.simulateTrain(this.dataCache, this.trainPositions, this.signalBlocks, newTrainsInPlayerRange, trainsToSync, this.schedulesForPlatform);
        });
        int hour = Depot.getHour(this.world);
        this.depots.forEach(depot -> depot.deployTrain(this, hour));
        this.railwayDataCoolDownModule.tick();
        this.railwayDataRailActionsModule.tick();
        this.trainsInPlayerRange.forEach((player, trains) -> {
            for (TrainServer train : trains) {
                if (newTrainsInPlayerRange.containsKey(player) && ((Set)newTrainsInPlayerRange.get(player)).contains(train)) continue;
                PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                if (newTrainsInPlayerRange.containsKey(player)) {
                    packet.writeInt(((Set)newTrainsInPlayerRange.get(player)).size());
                    ((Set)newTrainsInPlayerRange.get(player)).forEach(trainToKeep -> packet.writeLong(trainToKeep.id));
                } else {
                    packet.writeInt(0);
                }
                if (packet.readableBytes() > 0x100000) break;
                Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_DELETE_TRAINS, packet);
                break;
            }
        });
        newTrainsInPlayerRange.forEach((player, trains) -> {
            ArrayList trainsPacketsToUpdate = new ArrayList();
            trains.forEach(train -> {
                if (trainsToSync.contains(train) || !this.trainsInPlayerRange.containsKey(player) || !this.trainsInPlayerRange.get(player).contains(train)) {
                    PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                    train.writePacket(packet);
                    if (packet.readableBytes() < 0x100000) {
                        trainsPacketsToUpdate.add(packet);
                    }
                }
            });
            while (!trainsPacketsToUpdate.isEmpty()) {
                PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                while (!trainsPacketsToUpdate.isEmpty()) {
                    PacketBuffer trainPacket = (PacketBuffer)trainsPacketsToUpdate.get(0);
                    if (packet.readableBytes() + trainPacket.readableBytes() >= 0x100000) break;
                    packet.writeBytes((ByteBuf)trainPacket);
                    trainsPacketsToUpdate.remove(0);
                }
                Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_UPDATE_TRAINS, packet);
            }
        });
        this.trainsInPlayerRange.clear();
        this.trainsInPlayerRange.putAll(newTrainsInPlayerRange);
        if (MTR.isGameTickInterval(60)) {
            players.forEach(player -> {
                if (!this.playersToSyncSchedules.contains(player)) {
                    this.playersToSyncSchedules.add((PlayerEntity)player);
                }
            });
        }
        if (!this.playersToSyncSchedules.isEmpty()) {
            PlayerEntity player2 = this.playersToSyncSchedules.remove(0);
            BlockPos playerBlockPos = player2.func_233580_cy_();
            Vector3d playerPos = player2.func_213303_ch();
            Set<Long> platformIds = this.platforms.stream().filter(platform -> {
                if (platform.isCloseToSavedRail(playerBlockPos, 16, 16, 16)) {
                    return true;
                }
                Station station = this.dataCache.platformIdToStation.get(platform.id);
                return station != null && station.inArea(playerBlockPos.func_177958_n(), playerBlockPos.func_177952_p());
            }).map(platform -> platform.id).collect(Collectors.toSet());
            HashSet railsToAdd = new HashSet();
            this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                if (new AxisAlignedBB(startPos, endPos).func_186662_g(128.0).func_72318_a(playerPos)) {
                    railsToAdd.add(PathData.getRailProduct(startPos, endPos));
                }
            }));
            HashMap<Long, Boolean> signalBlockStatus = new HashMap<Long, Boolean>();
            railsToAdd.forEach(rail -> this.signalBlocks.getSignalBlockStatus((Map<Long, Boolean>)signalBlockStatus, (UUID)rail));
            if (!platformIds.isEmpty() || !signalBlockStatus.isEmpty()) {
                PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                packet.writeInt(platformIds.size());
                platformIds.forEach(platformId -> {
                    packet.writeLong(platformId.longValue());
                    List<ScheduleEntry> scheduleEntries = this.schedulesForPlatform.get(platformId);
                    if (scheduleEntries == null) {
                        packet.writeInt(0);
                    } else {
                        packet.writeInt(scheduleEntries.size());
                        scheduleEntries.forEach(scheduleEntry -> scheduleEntry.writePacket(packet));
                    }
                });
                packet.writeInt(signalBlockStatus.size());
                signalBlockStatus.forEach((id, occupied) -> {
                    packet.writeLong(id.longValue());
                    packet.writeBoolean(occupied.booleanValue());
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((ServerPlayerEntity)player2, PACKET_UPDATE_SCHEDULE, packet);
                }
            }
        }
        if (this.prevPlatformCount != this.platforms.size() || this.prevSidingCount != this.sidings.size()) {
            this.dataCache.sync();
        }
        this.prevPlatformCount = this.platforms.size();
        this.prevSidingCount = this.sidings.size();
        this.railwayDataFileSaveModule.autoSaveTick();
    }

    public void onPlayerJoin(ServerPlayerEntity serverPlayer) {
        PacketTrainDataGuiServer.sendAllInChunks(serverPlayer, this.stations, this.platforms, this.sidings, this.routes, this.depots, this.signalBlocks);
        this.railwayDataCoolDownModule.onPlayerJoin(serverPlayer);
    }

    public long addRail(TransportMode transportMode, BlockPos posStart, BlockPos posEnd, Rail rail, boolean validate) {
        long newId = validate ? new Random().nextLong() : 0L;
        RailwayData.addRail(this.rails, this.platforms, this.sidings, transportMode, posStart, posEnd, rail, newId);
        if (validate) {
            this.validateData();
        }
        return newId;
    }

    public long addSignal(DyeColor color, BlockPos posStart, BlockPos posEnd) {
        return this.signalBlocks.add(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void removeNode(BlockPos pos) {
        RailwayData.removeNode(this.world, this.rails, pos);
        this.validateData();
        PacketBuffer packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.func_217369_A().forEach(player -> Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public void removeRailConnection(BlockPos pos1, BlockPos pos2) {
        RailwayData.removeRailConnection(this.world, this.rails, pos1, pos2);
        this.validateData();
        PacketBuffer packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.func_217369_A().forEach(player -> Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public boolean hasSavedRail(BlockPos pos) {
        return this.rails.containsKey(pos) && this.rails.get(pos).values().stream().anyMatch(rail -> rail.railType.hasSavedRail);
    }

    public boolean containsRail(BlockPos pos1, BlockPos pos2) {
        return RailwayData.containsRail(this.rails, pos1, pos2);
    }

    public long removeSignal(DyeColor color, BlockPos posStart, BlockPos posEnd) {
        return this.signalBlocks.remove(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void disconnectPlayer(PlayerEntity player) {
        this.railwayDataCoolDownModule.onPlayerDisconnect(player);
        this.playerLastUpdatedPositions.remove(player);
    }

    public void getSchedulesForStation(Map<Long, List<ScheduleEntry>> schedulesForStation, long stationId) {
        this.schedulesForPlatform.forEach((platformId, schedules) -> {
            Station station = this.dataCache.platformIdToStation.get(platformId);
            if (station != null && station.id == stationId) {
                schedulesForStation.put((Long)platformId, (List<ScheduleEntry>)schedules);
            }
        });
    }

    public List<ScheduleEntry> getSchedulesAtPlatform(long platformId) {
        return this.schedulesForPlatform.get(platformId);
    }

    private void validateData() {
        RailwayData.removeSavedRailS2C(this.world, this.platforms, this.rails, PACKET_DELETE_PLATFORM);
        RailwayData.removeSavedRailS2C(this.world, this.sidings, this.rails, PACKET_DELETE_SIDING);
        ArrayList railsToRemove = new ArrayList();
        this.rails.forEach((startPos, railMap) -> railMap.forEach((endPos, rail) -> {
            if (rail.railType.hasSavedRail && SavedRailBase.isInvalidSavedRail(this.rails, endPos, startPos)) {
                railsToRemove.add(startPos);
                railsToRemove.add(endPos);
            }
        }));
        for (int i = 0; i < railsToRemove.size() - 1; i += 2) {
            RailwayData.removeRailConnection(null, this.rails, (BlockPos)railsToRemove.get(i), (BlockPos)railsToRemove.get(i + 1));
        }
    }

    public static Platform getPlatformByPos(Set<Platform> platforms, BlockPos pos) {
        try {
            return platforms.stream().filter(platform -> platform.containsPos(pos)).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addRail(Map<BlockPos, Map<BlockPos, Rail>> rails, Set<Platform> platforms, Set<Siding> sidings, TransportMode transportMode, BlockPos posStart, BlockPos posEnd, Rail rail, long savedRailId) {
        try {
            if (!rails.containsKey(posStart)) {
                rails.put(posStart, new HashMap());
            }
            rails.get(posStart).put(posEnd, rail);
            if (savedRailId != 0L) {
                if (rail.railType == RailType.PLATFORM && platforms.stream().noneMatch(platform -> platform.containsPos(posStart) || platform.containsPos(posEnd))) {
                    platforms.add(new Platform(savedRailId, transportMode, posStart, posEnd));
                } else if (rail.railType == RailType.SIDING && sidings.stream().noneMatch(siding -> siding.containsPos(posStart) || siding.containsPos(posEnd))) {
                    sidings.add(new Siding(savedRailId, transportMode, posStart, posEnd, (int)Math.floor(rail.getLength())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNode(World world, Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos) {
        try {
            rails.remove(pos);
            rails.forEach((startPos, railMap) -> {
                railMap.remove(pos);
                if (railMap.isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, startPos);
                }
            });
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeRailConnection(World world, Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        try {
            if (rails.containsKey(pos1)) {
                rails.get(pos1).remove(pos2);
                if (rails.get(pos1).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos1);
                }
            }
            if (rails.containsKey(pos2)) {
                rails.get(pos2).remove(pos1);
                if (rails.get(pos2).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos2);
                }
            }
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean containsRail(Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        return rails.containsKey(pos1) && rails.get(pos1).containsKey(pos2);
    }

    public static Station getStation(Set<Station> stations, DataCache dataCache, BlockPos pos) {
        try {
            if (dataCache.blockPosToStation.containsKey(pos)) {
                return dataCache.blockPosToStation.get(pos);
            }
            return stations.stream().filter(station -> station.inArea(pos.func_177958_n(), pos.func_177952_p())).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, BlockPos pos) {
        return RailwayData.getClosePlatformId(platforms, dataCache, pos, 5, 0, 4);
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, BlockPos pos, int radius, int lower, int upper) {
        try {
            if (dataCache.blockPosToPlatformId.containsKey(pos)) {
                return dataCache.blockPosToPlatformId.get(pos);
            }
            long platformId = 0L;
            int i = 1;
            while (i <= radius) {
                int searchRadius = i++;
                platformId = platforms.stream().filter(platform -> platform.isCloseToSavedRail(pos, searchRadius, lower, upper)).min(Comparator.comparingInt(platform -> platform.getMidPos().func_218139_n((Vector3i)pos))).map(platform -> platform.id).orElse(0L);
                if (platformId != 0L) break;
            }
            dataCache.blockPosToPlatformId.put(pos, platformId);
            return platformId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static boolean useRoutesAndStationsFromIndex(int stopIndex, List<Long> routeIds, DataCache dataCache, RouteAndStationsCallback routeAndStationsCallback) {
        if (stopIndex < 0) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < routeIds.size(); ++i) {
            Route nextRoute;
            Route thisRoute = dataCache.routeIdMap.get(routeIds.get(i));
            Route route = nextRoute = i < routeIds.size() - 1 && !dataCache.routeIdMap.get((Object)routeIds.get((int)(i + 1))).isHidden ? dataCache.routeIdMap.get(routeIds.get(i + 1)) : null;
            if (thisRoute == null) continue;
            int difference = stopIndex - sum;
            sum += thisRoute.platformIds.size();
            if (!thisRoute.platformIds.isEmpty() && nextRoute != null && !nextRoute.platformIds.isEmpty() && thisRoute.platformIds.get(thisRoute.platformIds.size() - 1).equals(nextRoute.platformIds.get(0))) {
                --sum;
            }
            if (stopIndex >= sum) continue;
            Station thisStation = dataCache.platformIdToStation.get(thisRoute.platformIds.get(difference));
            Station nextStation = difference < thisRoute.platformIds.size() - 1 ? dataCache.platformIdToStation.get(thisRoute.platformIds.get(difference + 1)) : null;
            Station lastStation = thisRoute.platformIds.isEmpty() ? null : dataCache.platformIdToStation.get(thisRoute.platformIds.get(thisRoute.platformIds.size() - 1));
            routeAndStationsCallback.routeAndStationsCallback(difference, thisRoute, nextRoute, thisStation, nextStation, lastStation);
            return true;
        }
        return false;
    }

    public static boolean isBetween(double value, double value1, double value2) {
        return RailwayData.isBetween(value, value1, value2, 0.0);
    }

    public static boolean isBetween(double value, double value1, double value2, double padding) {
        return value >= Math.min(value1, value2) - padding && value <= Math.max(value1, value2) + padding;
    }

    public static float round(double value, int decimalPlaces) {
        int factor = 1;
        for (int i = 0; i < decimalPlaces; ++i) {
            factor *= 10;
        }
        return (float)Math.round(value * (double)factor) / (float)factor;
    }

    public static void writeMessagePackDataset(MessagePacker messagePacker, Collection<? extends SerializedDataBase> dataSet, String key) throws IOException {
        messagePacker.packString(key);
        messagePacker.packArrayHeader(dataSet.size());
        for (SerializedDataBase serializedDataBase : dataSet) {
            messagePacker.packMapHeader(serializedDataBase.messagePackLength());
            serializedDataBase.toMessagePack(messagePacker);
        }
    }

    public static Map<String, Value> castMessagePackValueToSKMap(Value value) {
        Map<Object, Object> oldMap = value == null ? new HashMap() : value.asMapValue().map();
        HashMap<String, Value> resultMap = new HashMap<String, Value>(oldMap.size());
        oldMap.forEach((key, newValue) -> resultMap.put(key.asStringValue().asString(), (Value)newValue));
        return resultMap;
    }

    public static boolean hasNoPermission(ServerPlayerEntity serverPlayer) {
        return !RailwayData.hasPermission(serverPlayer.field_71134_c.func_73081_b());
    }

    public static boolean hasPermission(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SURVIVAL;
    }

    public static RailwayData getInstance(World world) {
        return RailwayData.getInstance(world, () -> new RailwayData(world), NAME);
    }

    public static void benchmark(Runnable runnable, float threshold) {
        long nanos = System.nanoTime();
        runnable.run();
        float duration = (float)(System.nanoTime() - nanos) / 1.0E9f;
        if (duration >= threshold) {
            System.out.println(duration);
        }
    }

    private static void validateRails(World world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        HashSet railsToRemove = new HashSet();
        HashSet railsNodesToRemove = new HashSet();
        rails.forEach((startPos, railMap) -> {
            boolean loadedChunk = world.func_217354_b(startPos.func_177958_n() / 16, startPos.func_177952_p() / 16);
            if (loadedChunk && !(world.func_180495_p(startPos).func_177230_c() instanceof BlockNode)) {
                railsNodesToRemove.add(startPos);
            }
            if (railMap.isEmpty()) {
                railsToRemove.add(startPos);
            }
        });
        railsToRemove.forEach(rails::remove);
        railsNodesToRemove.forEach(pos -> RailwayData.removeNode(null, rails, pos));
    }

    private static void removeSavedRailS2C(World world, Set<? extends SavedRailBase> savedRailBases, Map<BlockPos, Map<BlockPos, Rail>> rails, ResourceLocation packetId) {
        savedRailBases.removeIf(savedRailBase -> {
            boolean delete = savedRailBase.isInvalidSavedRail(rails);
            if (delete) {
                PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                packet.writeLong(savedRailBase.id);
                world.func_217369_A().forEach(player -> Registry.sendToPlayer((ServerPlayerEntity)player, packetId, packet));
            }
            return delete;
        });
    }

    private static Map<String, Value> readMessagePackSKMap(MessageUnpacker messageUnpacker) throws IOException {
        int size = messageUnpacker.unpackMapHeader();
        HashMap<String, Value> result = new HashMap<String, Value>(size);
        for (int i = 0; i < size; ++i) {
            result.put(messageUnpacker.unpackString(), messageUnpacker.unpackValue());
        }
        return result;
    }

    @Deprecated
    private static class RailEntry
    extends SerializedDataBase {
        public final BlockPos pos;
        public final Map<BlockPos, Rail> connections;
        private static final String KEY_NODE_POS = "node_pos";
        private static final String KEY_RAIL_CONNECTIONS = "rail_connections";

        public RailEntry(BlockPos pos, Map<BlockPos, Rail> connections) {
            this.pos = pos;
            this.connections = connections;
        }

        public RailEntry(CompoundNBT compoundTag) {
            this.pos = BlockPos.func_218283_e((long)compoundTag.func_74763_f(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Rail>();
            CompoundNBT tagConnections = compoundTag.func_74775_l(KEY_RAIL_CONNECTIONS);
            for (String keyConnection : tagConnections.func_150296_c()) {
                this.connections.put(BlockPos.func_218283_e((long)tagConnections.func_74775_l(keyConnection).func_74763_f(KEY_NODE_POS)), new Rail(tagConnections.func_74775_l(keyConnection)));
            }
        }

        public RailEntry(Map<String, Value> map) {
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            this.pos = BlockPos.func_218283_e((long)messagePackHelper.getLong(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Rail>();
            messagePackHelper.iterateArrayValue(KEY_RAIL_CONNECTIONS, value -> {
                Map<String, Value> mapSK = RailwayData.castMessagePackValueToSKMap(value);
                this.connections.put(BlockPos.func_218283_e((long)new MessagePackHelper(mapSK).getLong(KEY_NODE_POS)), new Rail(mapSK));
            });
        }

        @Override
        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.func_218275_a());
            messagePacker.packString(KEY_RAIL_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<BlockPos, Rail> entry : this.connections.entrySet()) {
                BlockPos endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.func_218275_a());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        @Override
        public int messagePackLength() {
            return 2;
        }

        @Override
        public void writePacket(PacketBuffer packet) {
        }
    }

    @FunctionalInterface
    public static interface RouteAndStationsCallback {
        public void routeAndStationsCallback(int var1, Route var2, Route var3, Station var4, Station var5, Station var6);
    }
}

