/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mtr.Registry;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RailwayDataCoolDownModule
extends RailwayDataModuleBase {
    private final Map<PlayerEntity, Integer> playerRidingCoolDown = new HashMap<PlayerEntity, Integer>();
    private final Map<PlayerEntity, EntitySeat> playerSeats = new HashMap<PlayerEntity, EntitySeat>();
    private final Map<PlayerEntity, Integer> playerSeatCoolDowns = new HashMap<PlayerEntity, Integer>();

    public RailwayDataCoolDownModule(RailwayData railwayData, World world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        this.world.func_217369_A().forEach(player -> {
            EntitySeat seat;
            Integer seatCoolDownOld = this.playerSeatCoolDowns.get(player);
            EntitySeat seatOld = this.playerSeats.get(player);
            if (seatCoolDownOld == null || seatCoolDownOld <= 0 || Utilities.entityRemoved(seatOld)) {
                seat = new EntitySeat(this.world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                this.world.func_217376_c((Entity)seat);
                seat.initialize((PlayerEntity)player);
                this.playerSeats.put((PlayerEntity)player, seat);
                this.playerSeatCoolDowns.put((PlayerEntity)player, 3);
            } else {
                seat = this.playerSeats.get(player);
                this.playerSeatCoolDowns.put((PlayerEntity)player, this.playerSeatCoolDowns.get(player) - 1);
            }
            seat.updateSeatByRailwayData((PlayerEntity)player);
        });
        HashSet playersToRemove = new HashSet();
        this.playerRidingCoolDown.forEach((player, coolDown) -> {
            if (coolDown <= 0) {
                RailwayDataCoolDownModule.updatePlayerRiding(player, false);
                playersToRemove.add(player);
            }
            this.playerRidingCoolDown.put((PlayerEntity)player, coolDown - 1);
        });
        playersToRemove.forEach(this.playerRidingCoolDown::remove);
    }

    public void onPlayerJoin(ServerPlayerEntity serverPlayer) {
        this.playerRidingCoolDown.put((PlayerEntity)serverPlayer, 2);
    }

    public void onPlayerDisconnect(PlayerEntity player) {
        this.playerSeats.remove(player);
        this.playerSeatCoolDowns.remove(player);
    }

    public void updatePlayerRiding(PlayerEntity player) {
        RailwayDataCoolDownModule.updatePlayerRiding(player, true);
        this.playerRidingCoolDown.put(player, 2);
    }

    public void updatePlayerSeatCoolDown(PlayerEntity player) {
        this.playerSeatCoolDowns.put(player, 3);
    }

    public boolean canRide(PlayerEntity player) {
        return !this.playerRidingCoolDown.containsKey(player);
    }

    private static void updatePlayerRiding(PlayerEntity player, boolean isRiding) {
        player.field_70143_R = 0.0f;
        player.func_189654_d(isRiding);
        player.field_70145_X = isRiding;
        if (isRiding) {
            Utilities.getAbilities((PlayerEntity)player).field_75101_c = true;
        } else {
            ((ServerPlayerEntity)player).field_71134_c.func_73081_b().func_77147_a(Utilities.getAbilities(player));
        }
        Registry.setInTeleportationState(player, isRiding);
    }
}

