/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RouteType;
import mtr.data.TransportMode;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Route
extends NameColorDataBase
implements IGui {
    public RouteType routeType;
    public boolean isLightRailRoute;
    public boolean isHidden;
    public CircularState circularState;
    public String lightRailRouteNumber;
    public final List<Long> platformIds;
    private static final String KEY_PLATFORM_IDS = "platform_ids";
    private static final String KEY_ROUTE_TYPE = "route_type";
    private static final String KEY_IS_LIGHT_RAIL_ROUTE = "is_light_rail_route";
    private static final String KEY_LIGHT_RAIL_ROUTE_NUMBER = "light_rail_route_number";
    private static final String KEY_IS_ROUTE_HIDDEN = "is_route_hidden";
    private static final String KEY_CIRCULAR_STATE = "circular_state";

    public Route(TransportMode transportMode) {
        this(0L, transportMode);
    }

    public Route(long id, TransportMode transportMode) {
        super(id, transportMode);
        this.platformIds = new ArrayList<Long>();
        this.routeType = RouteType.NORMAL;
        this.isLightRailRoute = false;
        this.circularState = CircularState.NONE;
        this.lightRailRouteNumber = "";
        this.isHidden = false;
    }

    public Route(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.platformIds = new ArrayList<Long>();
        messagePackHelper.iterateArrayValue(KEY_PLATFORM_IDS, platformId -> this.platformIds.add(platformId.asIntegerValue().asLong()));
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, messagePackHelper.getString(KEY_ROUTE_TYPE));
        this.isLightRailRoute = messagePackHelper.getBoolean(KEY_IS_LIGHT_RAIL_ROUTE);
        this.isHidden = messagePackHelper.getBoolean(KEY_IS_ROUTE_HIDDEN);
        this.lightRailRouteNumber = messagePackHelper.getString(KEY_LIGHT_RAIL_ROUTE_NUMBER);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, messagePackHelper.getString(KEY_CIRCULAR_STATE));
    }

    @Deprecated
    public Route(CompoundNBT compoundTag) {
        super(compoundTag);
        long[] platformIdsArray;
        this.platformIds = new ArrayList<Long>();
        for (long platformId : platformIdsArray = compoundTag.func_197645_o(KEY_PLATFORM_IDS)) {
            this.platformIds.add(platformId);
        }
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, compoundTag.func_74779_i(KEY_ROUTE_TYPE));
        this.isLightRailRoute = compoundTag.func_74767_n(KEY_IS_LIGHT_RAIL_ROUTE);
        this.isHidden = compoundTag.func_74767_n(KEY_IS_ROUTE_HIDDEN);
        this.lightRailRouteNumber = compoundTag.func_74779_i(KEY_LIGHT_RAIL_ROUTE_NUMBER);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, compoundTag.func_74779_i(KEY_CIRCULAR_STATE));
    }

    public Route(PacketBuffer packet) {
        super(packet);
        this.platformIds = new ArrayList<Long>();
        int platformCount = packet.readInt();
        for (int i = 0; i < platformCount; ++i) {
            this.platformIds.add(packet.readLong());
        }
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, packet.func_150789_c(Short.MAX_VALUE));
        this.isLightRailRoute = packet.readBoolean();
        this.isHidden = packet.readBoolean();
        this.lightRailRouteNumber = packet.func_150789_c(Short.MAX_VALUE);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, packet.func_150789_c(Short.MAX_VALUE));
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_PLATFORM_IDS).packArrayHeader(this.platformIds.size());
        for (Long platformId : this.platformIds) {
            messagePacker.packLong(platformId);
        }
        messagePacker.packString(KEY_ROUTE_TYPE).packString(this.routeType.toString());
        messagePacker.packString(KEY_IS_LIGHT_RAIL_ROUTE).packBoolean(this.isLightRailRoute);
        messagePacker.packString(KEY_IS_ROUTE_HIDDEN).packBoolean(this.isHidden);
        messagePacker.packString(KEY_LIGHT_RAIL_ROUTE_NUMBER).packString(this.lightRailRouteNumber);
        messagePacker.packString(KEY_CIRCULAR_STATE).packString(this.circularState.toString());
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 6;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        packet.writeInt(this.platformIds.size());
        this.platformIds.forEach(arg_0 -> ((PacketBuffer)packet).writeLong(arg_0));
        packet.func_180714_a(this.routeType.toString());
        packet.writeBoolean(this.isLightRailRoute);
        packet.writeBoolean(this.isHidden);
        packet.func_180714_a(this.lightRailRouteNumber);
        packet.func_180714_a(this.circularState.toString());
    }

    @Override
    public void update(String key, PacketBuffer packet) {
        switch (key) {
            case "platform_ids": {
                this.platformIds.clear();
                int platformCount = packet.readInt();
                for (int i = 0; i < platformCount; ++i) {
                    this.platformIds.add(packet.readLong());
                }
                break;
            }
            case "is_light_rail_route": {
                this.name = packet.func_150789_c(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.routeType = EnumHelper.valueOf(RouteType.NORMAL, packet.func_150789_c(Short.MAX_VALUE));
                this.isLightRailRoute = packet.readBoolean();
                this.lightRailRouteNumber = packet.func_150789_c(Short.MAX_VALUE);
                this.isHidden = packet.readBoolean();
                this.circularState = EnumHelper.valueOf(CircularState.NONE, packet.func_150789_c(Short.MAX_VALUE));
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    @Override
    protected boolean hasTransportMode() {
        return true;
    }

    public void setPlatformIds(Consumer<PacketBuffer> sendPacket) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_PLATFORM_IDS);
        packet.writeInt(this.platformIds.size());
        this.platformIds.forEach(arg_0 -> ((PacketBuffer)packet).writeLong(arg_0));
        sendPacket.accept(packet);
    }

    public void setExtraData(Consumer<PacketBuffer> sendPacket) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_IS_LIGHT_RAIL_ROUTE);
        packet.func_180714_a(this.name);
        packet.writeInt(this.color);
        packet.func_180714_a(this.routeType.toString());
        packet.writeBoolean(this.isLightRailRoute);
        packet.func_180714_a(this.lightRailRouteNumber);
        packet.writeBoolean(this.isHidden);
        packet.func_180714_a(this.circularState.toString());
        sendPacket.accept(packet);
    }

    public static enum CircularState {
        NONE,
        CLOCKWISE,
        ANTICLOCKWISE;

    }
}

