/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.math.NumberUtils;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class SavedRailBase
extends NameColorDataBase {
    private final Set<BlockPos> positions;
    private static final String KEY_POS_1 = "pos_1";
    private static final String KEY_POS_2 = "pos_2";

    public SavedRailBase(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(id, transportMode);
        this.name = "1";
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
    }

    public SavedRailBase(TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(transportMode);
        this.name = "1";
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
    }

    public SavedRailBase(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(BlockPos.func_218283_e((long)messagePackHelper.getLong(KEY_POS_1)));
        this.positions.add(BlockPos.func_218283_e((long)messagePackHelper.getLong(KEY_POS_2)));
    }

    @Deprecated
    public SavedRailBase(CompoundNBT compoundTag) {
        super(compoundTag);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(BlockPos.func_218283_e((long)compoundTag.func_74763_f(KEY_POS_1)));
        this.positions.add(BlockPos.func_218283_e((long)compoundTag.func_74763_f(KEY_POS_2)));
    }

    public SavedRailBase(PacketBuffer packet) {
        super(packet);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(packet.func_179259_c());
        this.positions.add(packet.func_179259_c());
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_POS_1).packLong(this.getPosition(0).func_218275_a());
        messagePacker.packString(KEY_POS_2).packLong(this.getPosition(1).func_218275_a());
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 2;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        packet.func_179255_a(this.getPosition(0));
        packet.func_179255_a(this.getPosition(1));
    }

    @Override
    protected final boolean hasTransportMode() {
        return true;
    }

    public boolean containsPos(BlockPos pos) {
        return this.positions.contains(pos);
    }

    public BlockPos getMidPos() {
        return this.getMidPos(false);
    }

    public BlockPos getMidPos(boolean zeroY) {
        BlockPos pos = this.getPosition(0).func_177971_a((Vector3i)this.getPosition(1));
        return new BlockPos(pos.func_177958_n() / 2, zeroY ? 0 : pos.func_177956_o() / 2, pos.func_177952_p() / 2);
    }

    public Direction.Axis getAxis() {
        BlockPos difference = this.getPosition(0).func_177973_b((Vector3i)this.getPosition(1));
        return Math.abs(difference.func_177958_n()) > Math.abs(difference.func_177952_p()) ? Direction.Axis.X : Direction.Axis.Z;
    }

    public boolean isInvalidSavedRail(Map<BlockPos, Map<BlockPos, Rail>> rails) {
        BlockPos pos2;
        BlockPos pos1 = this.getPosition(0);
        return SavedRailBase.isInvalidSavedRail(rails, pos1, pos2 = this.getPosition(1)) || SavedRailBase.isInvalidSavedRail(rails, pos2, pos1);
    }

    public boolean isCloseToSavedRail(BlockPos pos, int radius, int lower, int upper) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
        int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        return new AxisAlignedBB((double)(x1 - radius), (double)(y1 - lower), (double)(z1 - radius), (double)(x2 + radius + 1), (double)(y2 + upper + 1), (double)(z2 + radius + 1)).func_197744_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public List<BlockPos> getOrderedPositions(BlockPos pos, boolean reverse) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        double d1 = pos1.func_177951_i((Vector3i)pos);
        double d2 = pos2.func_177951_i((Vector3i)pos);
        ArrayList<BlockPos> orderedPositions = new ArrayList<BlockPos>();
        if (d2 > d1 == reverse) {
            orderedPositions.add(pos2);
            orderedPositions.add(pos1);
        } else {
            orderedPositions.add(pos1);
            orderedPositions.add(pos2);
        }
        return orderedPositions;
    }

    public BlockPos getOtherPosition(BlockPos pos) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        return pos.equals((Object)pos1) ? pos2 : pos1;
    }

    private BlockPos getPosition(int index) {
        return this.positions.size() > index ? new ArrayList<BlockPos>(this.positions).get(index) : new BlockPos(0, 0, 0);
    }

    public static boolean isInvalidSavedRail(Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        return !RailwayData.containsRail(rails, pos1, pos2) || !rails.get((Object)pos1).get((Object)pos2).railType.hasSavedRail;
    }

    @Override
    public int compareTo(NameColorDataBase compare) {
        boolean thisIsNumber = NumberUtils.isParsable((String)this.name);
        boolean compareIsNumber = NumberUtils.isParsable((String)compare.name);
        if (thisIsNumber && compareIsNumber) {
            int floatCompare = Float.compare(Float.parseFloat(this.name), Float.parseFloat(compare.name));
            return floatCompare == 0 ? super.compareTo(compare) : floatCompare;
        }
        if (thisIsNumber) {
            return -1;
        }
        if (compareIsNumber) {
            return 1;
        }
        return super.compareTo(compare);
    }
}

