/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.data.ScheduleEntry;
import mtr.data.SignalBlocks;
import mtr.data.TrainServer;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.path.PathData;
import mtr.path.PathFinder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class Siding
extends SavedRailBase
implements IPacket,
IReducedSaveData {
    private World world;
    private Depot depot;
    private String trainId;
    private TrainType baseTrainType;
    private int trainCars;
    private boolean unlimitedTrains;
    private int maxTrains;
    private float accelerationConstant;
    private final float railLength;
    private final List<PathData> path = new ArrayList<PathData>();
    private final List<Float> distances = new ArrayList<Float>();
    private final List<TimeSegment> timeSegments = new ArrayList<TimeSegment>();
    private final Map<Long, Map<Long, Float>> platformTimes = new HashMap<Long, Map<Long, Float>>();
    private final Set<TrainServer> trains = new HashSet<TrainServer>();
    private static final String KEY_RAIL_LENGTH = "rail_length";
    private static final String KEY_BASE_TRAIN_TYPE = "train_type";
    private static final String KEY_TRAIN_ID = "train_custom_id";
    private static final String KEY_UNLIMITED_TRAINS = "unlimited_trains";
    private static final String KEY_MAX_TRAINS = "max_trains";
    private static final String KEY_PATH = "path";
    private static final String KEY_TRAINS = "trains";
    private static final String KEY_ACCELERATION_CONSTANT = "acceleration_constant";

    public Siding(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2, float railLength) {
        super(id, transportMode, pos1, pos2);
        this.railLength = railLength;
        this.setTrainDetails("", Siding.getTrainType(transportMode));
        this.accelerationConstant = 0.01f;
    }

    public Siding(TransportMode transportMode, BlockPos pos1, BlockPos pos2, float railLength) {
        super(transportMode, pos1, pos2);
        this.railLength = railLength;
        this.setTrainDetails("", Siding.getTrainType(transportMode));
        this.accelerationConstant = 0.01f;
    }

    public Siding(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.railLength = messagePackHelper.getFloat(KEY_RAIL_LENGTH);
        this.setTrainDetails(messagePackHelper.getString(KEY_TRAIN_ID), TrainType.getOrDefault(messagePackHelper.getString(KEY_BASE_TRAIN_TYPE)));
        this.unlimitedTrains = messagePackHelper.getBoolean(KEY_UNLIMITED_TRAINS);
        this.maxTrains = messagePackHelper.getInt(KEY_MAX_TRAINS);
        float tempAccelerationConstant = RailwayData.round(messagePackHelper.getFloat(KEY_ACCELERATION_CONSTANT, 0.01f), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        messagePackHelper.iterateArrayValue(KEY_PATH, pathSection -> this.path.add(new PathData(RailwayData.castMessagePackValueToSKMap(pathSection))));
        this.generateTimeSegments(this.path, this.timeSegments, this.platformTimes);
        messagePackHelper.iterateArrayValue(KEY_TRAINS, value -> this.trains.add(new TrainServer(this.id, this.railLength, this.path, this.distances, this.timeSegments, RailwayData.castMessagePackValueToSKMap(value))));
        this.generateDistances();
    }

    @Deprecated
    public Siding(CompoundNBT compoundTag) {
        super(compoundTag);
        this.railLength = compoundTag.func_74760_g(KEY_RAIL_LENGTH);
        this.setTrainDetails(compoundTag.func_74779_i(KEY_TRAIN_ID), TrainType.getOrDefault(compoundTag.func_74779_i(KEY_BASE_TRAIN_TYPE)));
        this.unlimitedTrains = compoundTag.func_74767_n(KEY_UNLIMITED_TRAINS);
        this.maxTrains = compoundTag.func_74762_e(KEY_MAX_TRAINS);
        this.accelerationConstant = 0.01f;
        CompoundNBT tagPath = compoundTag.func_74775_l(KEY_PATH);
        int pathCount = tagPath.func_150296_c().size();
        for (int i = 0; i < pathCount; ++i) {
            this.path.add(new PathData(tagPath.func_74775_l(KEY_PATH + i)));
        }
        this.generateTimeSegments(this.path, this.timeSegments, this.platformTimes);
        CompoundNBT tagTrains = compoundTag.func_74775_l(KEY_TRAINS);
        tagTrains.func_150296_c().forEach(key -> this.trains.add(new TrainServer(this.id, this.railLength, this.path, this.distances, this.timeSegments, tagTrains.func_74775_l(key))));
        this.generateDistances();
    }

    public Siding(PacketBuffer packet) {
        super(packet);
        this.railLength = packet.readFloat();
        this.setTrainDetails(packet.func_150789_c(Short.MAX_VALUE), TrainType.values()[packet.readInt()]);
        this.unlimitedTrains = packet.readBoolean();
        this.maxTrains = packet.readInt();
        float tempAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        this.toReducedMessagePack(messagePacker);
        RailwayData.writeMessagePackDataset(messagePacker, this.trains, KEY_TRAINS);
    }

    @Override
    public void toReducedMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_RAIL_LENGTH).packFloat(this.railLength);
        messagePacker.packString(KEY_TRAIN_ID).packString(this.trainId);
        messagePacker.packString(KEY_BASE_TRAIN_TYPE).packString(this.baseTrainType.toString());
        messagePacker.packString(KEY_UNLIMITED_TRAINS).packBoolean(this.unlimitedTrains);
        messagePacker.packString(KEY_MAX_TRAINS).packInt(this.maxTrains);
        messagePacker.packString(KEY_ACCELERATION_CONSTANT).packFloat(this.accelerationConstant);
        RailwayData.writeMessagePackDataset(messagePacker, this.path, KEY_PATH);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 8;
    }

    @Override
    public int reducedMessagePackLength() {
        return this.messagePackLength() - 1;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        packet.writeFloat(this.railLength);
        packet.func_180714_a(this.trainId);
        packet.writeInt(this.baseTrainType.ordinal());
        packet.writeBoolean(this.unlimitedTrains);
        packet.writeInt(this.maxTrains);
        packet.writeFloat(this.accelerationConstant);
    }

    @Override
    public void update(String key, PacketBuffer packet) {
        switch (key) {
            case "train_type": {
                this.setTrainDetails(packet.func_150789_c(Short.MAX_VALUE), TrainType.values()[packet.readInt()]);
                this.trains.clear();
                break;
            }
            case "unlimited_trains": {
                this.name = packet.func_150789_c(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.unlimitedTrains = packet.readBoolean();
                this.maxTrains = packet.readInt();
                float newAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
                if (!(newAccelerationConstant > 0.0f)) break;
                this.trains.clear();
                this.accelerationConstant = newAccelerationConstant;
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    public void setTrainIdAndBaseType(String customId, TrainType trainType, Consumer<PacketBuffer> sendPacket) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_BASE_TRAIN_TYPE);
        packet.func_180714_a(customId);
        packet.writeInt(trainType.ordinal());
        sendPacket.accept(packet);
        this.setTrainDetails(customId, trainType);
    }

    public void setUnlimitedTrains(boolean unlimitedTrains, int maxTrains, float accelerationConstant, Consumer<PacketBuffer> sendPacket) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_UNLIMITED_TRAINS);
        packet.func_180714_a(this.name);
        packet.writeInt(this.color);
        packet.writeBoolean(unlimitedTrains);
        packet.writeInt(maxTrains);
        float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
        packet.writeFloat(tempAccelerationConstant);
        sendPacket.accept(packet);
        this.unlimitedTrains = unlimitedTrains;
        this.maxTrains = maxTrains;
        if (tempAccelerationConstant > 0.0f) {
            this.trains.clear();
            this.accelerationConstant = tempAccelerationConstant;
        }
    }

    public String getTrainId() {
        return this.trainId;
    }

    public TrainType getBaseTrainType() {
        return this.baseTrainType;
    }

    public float getAccelerationConstant() {
        return this.accelerationConstant;
    }

    public void setSidingData(World world, Depot depot, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        this.world = world;
        this.depot = depot;
        if (depot == null) {
            this.trains.clear();
            this.path.clear();
            this.distances.clear();
        } else {
            if (this.path.isEmpty()) {
                this.generateDefaultPath(rails);
                this.generateDistances();
            }
            depot.platformTimes.clear();
            depot.platformTimes.putAll(this.platformTimes);
        }
    }

    public int generateRoute(MinecraftServer minecraftServer, List<PathData> mainPath, int successfulSegmentsMain, Map<BlockPos, Map<BlockPos, Rail>> rails, SavedRailBase firstPlatform, SavedRailBase lastPlatform) {
        int successfulSegments;
        ArrayList<PathData> tempPath = new ArrayList<PathData>();
        if (firstPlatform == null || lastPlatform == null) {
            successfulSegments = 0;
        } else {
            ArrayList<SavedRailBase> depotAndFirstPlatform = new ArrayList<SavedRailBase>();
            depotAndFirstPlatform.add(this);
            depotAndFirstPlatform.add(firstPlatform);
            PathFinder.findPath(tempPath, rails, depotAndFirstPlatform, 0);
            if (tempPath.isEmpty()) {
                successfulSegments = 1;
            } else if (mainPath.isEmpty()) {
                tempPath.clear();
                successfulSegments = successfulSegmentsMain + 1;
            } else {
                PathFinder.appendPath(tempPath, mainPath);
                ArrayList<SavedRailBase> lastPlatformAndDepot = new ArrayList<SavedRailBase>();
                lastPlatformAndDepot.add(lastPlatform);
                lastPlatformAndDepot.add(this);
                ArrayList<PathData> pathLastPlatformToDepot = new ArrayList<PathData>();
                PathFinder.findPath(pathLastPlatformToDepot, rails, lastPlatformAndDepot, successfulSegmentsMain);
                if (pathLastPlatformToDepot.isEmpty()) {
                    successfulSegments = successfulSegmentsMain + 1;
                    tempPath.clear();
                } else {
                    PathFinder.appendPath(tempPath, pathLastPlatformToDepot);
                    successfulSegments = successfulSegmentsMain + 2;
                }
            }
        }
        ArrayList<TimeSegment> tempTimeSegments = new ArrayList<TimeSegment>();
        HashMap<Long, Map<Long, Float>> tempPlatformTimes = new HashMap<Long, Map<Long, Float>>();
        this.generateTimeSegments(tempPath, tempTimeSegments, tempPlatformTimes);
        minecraftServer.execute(() -> {
            try {
                this.path.clear();
                if (tempPath.isEmpty()) {
                    this.generateDefaultPath(rails);
                } else {
                    this.path.addAll(tempPath);
                }
                this.timeSegments.clear();
                this.timeSegments.addAll(tempTimeSegments);
                this.platformTimes.clear();
                this.platformTimes.putAll(tempPlatformTimes);
                this.generateDistances();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return successfulSegments;
    }

    public void simulateTrain(DataCache dataCache, List<Map<UUID, Long>> trainPositions, SignalBlocks signalBlocks, Map<PlayerEntity, Set<TrainServer>> trainsInPlayerRange, Set<TrainServer> trainsToSync, Map<Long, List<ScheduleEntry>> schedulesForPlatform) {
        if (this.depot == null) {
            return;
        }
        int trainsAtDepot = 0;
        boolean spawnTrain = true;
        HashSet<Integer> railProgressSet = new HashSet<Integer>();
        HashSet<TrainServer> trainsToRemove = new HashSet<TrainServer>();
        for (TrainServer train : this.trains) {
            int roundedRailProgress;
            if (train.simulateTrain(this.world, 1.0f, this.depot, dataCache, trainPositions, trainsInPlayerRange, schedulesForPlatform, this.unlimitedTrains)) {
                trainsToSync.add(train);
            }
            if (train.closeToDepot(this.baseTrainType.getSpacing() * this.trainCars)) {
                spawnTrain = false;
            }
            if (!train.getIsOnRoute() && ++trainsAtDepot > 1) {
                trainsToRemove.add(train);
            }
            if (railProgressSet.contains(roundedRailProgress = Math.round(train.getRailProgress() * 10.0f))) {
                trainsToRemove.add(train);
            }
            railProgressSet.add(roundedRailProgress);
            if (trainPositions == null) continue;
            train.writeTrainPositions(trainPositions, signalBlocks);
        }
        if (this.trainCars > 0 && (this.trains.isEmpty() || spawnTrain && (this.unlimitedTrains || this.trains.size() <= this.maxTrains))) {
            TrainServer train = new TrainServer(this.unlimitedTrains || this.maxTrains > 0 ? new Random().nextLong() : this.id, this.id, this.railLength, this.trainId, this.baseTrainType, this.trainCars, this.path, this.distances, this.accelerationConstant, this.timeSegments);
            this.trains.add(train);
        }
        if (!trainsToRemove.isEmpty()) {
            trainsToRemove.forEach(this.trains::remove);
        }
    }

    public int getMaxTrains() {
        return this.maxTrains;
    }

    public boolean getUnlimitedTrains() {
        return this.unlimitedTrains;
    }

    public void clearTrains() {
        this.trains.clear();
    }

    private void setTrainDetails(String trainId, TrainType baseTrainType) {
        this.trainId = trainId;
        this.baseTrainType = baseTrainType;
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(this.railLength / (float)baseTrainType.getSpacing() + 0.01f));
    }

    private void generateDefaultPath(Map<BlockPos, Map<BlockPos, Rail>> rails) {
        this.trains.clear();
        List<BlockPos> orderedPositions = this.getOrderedPositions(new BlockPos(0, 0, 0), false);
        BlockPos pos1 = orderedPositions.get(0);
        BlockPos pos2 = orderedPositions.get(1);
        if (RailwayData.containsRail(rails, pos1, pos2)) {
            this.path.add(new PathData(rails.get(pos1).get(pos2), this.id, 0, pos1, pos2, -1));
        }
        this.trains.add(new TrainServer(this.id, this.id, this.railLength, this.trainId, this.baseTrainType, this.trainCars, this.path, this.distances, this.accelerationConstant, this.timeSegments));
    }

    private void generateDistances() {
        this.distances.clear();
        float distanceSum = 0.0f;
        for (PathData pathData : this.path) {
            distanceSum = (float)((double)distanceSum + pathData.rail.getLength());
            this.distances.add(Float.valueOf(distanceSum));
        }
        if (this.path.size() != 1) {
            this.trains.removeIf(train -> train.id == this.id == this.unlimitedTrains);
        }
    }

    private void generateTimeSegments(List<PathData> path, List<TimeSegment> timeSegments, Map<Long, Map<Long, Float>> platformTimes) {
        timeSegments.clear();
        float distanceSum1 = 0.0f;
        ArrayList<Float> stoppingDistances = new ArrayList<Float>();
        for (PathData pathData : path) {
            distanceSum1 = (float)((double)distanceSum1 + pathData.rail.getLength());
            if (pathData.dwellTime <= 0) continue;
            stoppingDistances.add(Float.valueOf(distanceSum1));
        }
        float railProgress = (this.railLength + (float)(this.trainCars * this.baseTrainType.getSpacing())) / 2.0f;
        float nextStoppingDistance = 0.0f;
        float speed = 0.0f;
        float time = 0.0f;
        float timeOld = 0.0f;
        long savedRailBaseIdOld = 0L;
        float distanceSum2 = 0.0f;
        for (int i = 0; i < path.size(); ++i) {
            if (railProgress >= nextStoppingDistance) {
                nextStoppingDistance = stoppingDistances.isEmpty() ? distanceSum1 : ((Float)stoppingDistances.remove(0)).floatValue();
            }
            PathData pathData = path.get(i);
            float railSpeed = pathData.rail.railType.canAccelerate ? pathData.rail.railType.maxBlocksPerTick : Math.max(speed, RailType.WOODEN.maxBlocksPerTick);
            distanceSum2 = (float)((double)distanceSum2 + pathData.rail.getLength());
            while (railProgress < distanceSum2) {
                int speedChange;
                if (speed > railSpeed || nextStoppingDistance - railProgress + 1.0f < 0.5f * speed * speed / this.accelerationConstant) {
                    speed = Math.max(speed - this.accelerationConstant, this.accelerationConstant);
                    speedChange = -1;
                } else if (speed < railSpeed) {
                    speed = Math.min(speed + this.accelerationConstant, railSpeed);
                    speedChange = 1;
                } else {
                    speedChange = 0;
                }
                if (timeSegments.isEmpty() || timeSegments.get(timeSegments.size() - 1).speedChange != speedChange) {
                    timeSegments.add(new TimeSegment(railProgress, speed, time, speedChange, this.accelerationConstant));
                }
                railProgress = Math.min(railProgress + speed, distanceSum2);
                TimeSegment timeSegment = timeSegments.get(timeSegments.size() - 1);
                timeSegment.endRailProgress = railProgress;
                timeSegment.endTime = time += 1.0f;
                timeSegment.savedRailBaseId = nextStoppingDistance != distanceSum1 && railProgress == distanceSum2 ? pathData.savedRailBaseId : 0L;
            }
            time += (float)(pathData.dwellTime * 5);
            if (pathData.savedRailBaseId != 0L) {
                if (savedRailBaseIdOld != 0L) {
                    if (!platformTimes.containsKey(savedRailBaseIdOld)) {
                        platformTimes.put(savedRailBaseIdOld, new HashMap());
                    }
                    platformTimes.get(savedRailBaseIdOld).put(pathData.savedRailBaseId, Float.valueOf(time - timeOld));
                }
                savedRailBaseIdOld = pathData.savedRailBaseId;
                timeOld = time;
            }
            time += (float)(pathData.dwellTime * 5);
            if (i + 1 >= path.size() || !pathData.isOppositeRail(path.get(i + 1))) continue;
            railProgress += (float)(this.baseTrainType.getSpacing() * this.trainCars);
        }
    }

    private static TrainType getTrainType(TransportMode transportMode) {
        switch (transportMode) {
            case TRAIN: {
                return TrainType.SP1900;
            }
            case BOAT: {
                return TrainType.OAK_BOAT;
            }
        }
        return TrainType.values()[0];
    }

    public static class TimeSegment {
        public float endRailProgress;
        public long savedRailBaseId;
        public long routeId;
        public int currentStationIndex;
        public float endTime;
        public final float startRailProgress;
        private final float startSpeed;
        private final float startTime;
        private final int speedChange;
        private final float accelerationConstant;

        private TimeSegment(float startRailProgress, float startSpeed, float startTime, int speedChange, float accelerationConstant) {
            this.startRailProgress = startRailProgress;
            this.startSpeed = startSpeed;
            this.startTime = startTime;
            this.speedChange = Integer.compare(speedChange, 0);
            float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
            this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        }

        public float getTime(float railProgress) {
            float distance = railProgress - this.startRailProgress;
            if (this.speedChange == 0) {
                return this.startTime + distance / this.startSpeed;
            }
            float acceleration = (float)this.speedChange * this.accelerationConstant;
            return this.startTime + (float)(Math.sqrt(2.0f * acceleration * distance + this.startSpeed * this.startSpeed) - (double)this.startSpeed) / acceleration;
        }
    }
}

