/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.AreaBase;
import mtr.data.MessagePackHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Station
extends AreaBase {
    public int zone;
    public final Map<String, List<String>> exits = new HashMap<String, List<String>>();
    private static final String KEY_ZONE = "zone";
    private static final String KEY_EXITS = "exits";
    private static final String KEY_EXIT_EDIT_PARENT = "exit_edit_parent";
    private static final String KEY_EXIT_DELETE_PARENT = "exit_delete_parent";
    private static final String KEY_EXIT_DESTINATIONS = "exit_destinations";

    public Station() {
    }

    public Station(long id) {
        super(id);
    }

    public Station(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.zone = messagePackHelper.getInt(KEY_ZONE);
        messagePackHelper.iterateMapValue(KEY_EXITS, entry -> {
            ArrayList<String> destinations = new ArrayList<String>(((Value)entry.getValue()).asArrayValue().size());
            for (Value destination : ((Value)entry.getValue()).asArrayValue()) {
                destinations.add(destination.asStringValue().asString());
            }
            this.exits.put(((Value)entry.getKey()).asStringValue().asString(), destinations);
        });
    }

    @Deprecated
    public Station(CompoundNBT compoundTag) {
        super(compoundTag);
        this.zone = compoundTag.func_74762_e(KEY_ZONE);
        CompoundNBT tagExits = compoundTag.func_74775_l(KEY_EXITS);
        for (String keyParent : tagExits.func_150296_c()) {
            ArrayList<String> destinations = new ArrayList<String>();
            CompoundNBT tagDestinations = tagExits.func_74775_l(keyParent);
            for (String keyDestination : tagDestinations.func_150296_c()) {
                destinations.add(tagDestinations.func_74779_i(keyDestination));
            }
            this.exits.put(keyParent, destinations);
        }
    }

    public Station(PacketBuffer packet) {
        super(packet);
        this.zone = packet.readInt();
        int exitCount = packet.readInt();
        for (int i = 0; i < exitCount; ++i) {
            String parent = packet.func_150789_c(Short.MAX_VALUE);
            ArrayList<String> destinations = new ArrayList<String>();
            int destinationCount = packet.readInt();
            for (int j = 0; j < destinationCount; ++j) {
                destinations.add(packet.func_150789_c(Short.MAX_VALUE));
            }
            this.exits.put(parent, destinations);
        }
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_ZONE).packInt(this.zone);
        messagePacker.packString(KEY_EXITS);
        messagePacker.packMapHeader(this.exits.size());
        for (Map.Entry<String, List<String>> entry : this.exits.entrySet()) {
            String key = entry.getKey();
            List<String> destinations = entry.getValue();
            messagePacker.packString(key);
            messagePacker.packArrayHeader(destinations.size());
            for (String destination : destinations) {
                messagePacker.packString(destination);
            }
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 2;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        packet.writeInt(this.zone);
        packet.writeInt(this.exits.size());
        this.exits.forEach((parent, destinations) -> {
            packet.func_180714_a(parent);
            packet.writeInt(destinations.size());
            destinations.forEach(arg_0 -> ((PacketBuffer)packet).func_180714_a(arg_0));
        });
    }

    @Override
    public void update(String key, PacketBuffer packet) {
        switch (key) {
            case "exit_edit_parent": {
                String oldParent = packet.func_150789_c(Short.MAX_VALUE);
                String newParent = packet.func_150789_c(Short.MAX_VALUE);
                this.setExitParent(oldParent, newParent);
                break;
            }
            case "exit_delete_parent": {
                this.exits.remove(packet.func_150789_c(Short.MAX_VALUE));
                break;
            }
            case "exit_destinations": {
                String parent = packet.func_150789_c(Short.MAX_VALUE);
                if (!this.parentExists(parent)) break;
                this.exits.get(parent).clear();
                int destinationCount = packet.readInt();
                for (int i = 0; i < destinationCount; ++i) {
                    this.exits.get(parent).add(packet.func_150789_c(Short.MAX_VALUE));
                }
                break;
            }
            case "zone": {
                this.name = packet.func_150789_c(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.zone = packet.readInt();
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    @Override
    protected boolean hasTransportMode() {
        return false;
    }

    public void setZone(Consumer<PacketBuffer> sendPacket) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_ZONE);
        packet.func_180714_a(this.name);
        packet.writeInt(this.color);
        packet.writeInt(this.zone);
        sendPacket.accept(packet);
    }

    public void setExitParent(String oldParent, String newParent, Consumer<PacketBuffer> sendPacket) {
        this.setExitParent(oldParent, newParent);
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_EXIT_EDIT_PARENT);
        packet.func_180714_a(oldParent);
        packet.func_180714_a(newParent);
        sendPacket.accept(packet);
    }

    public void deleteExitParent(String parent, Consumer<PacketBuffer> sendPacket) {
        this.exits.remove(parent);
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.func_180714_a(this.transportMode.toString());
        packet.func_180714_a(KEY_EXIT_DELETE_PARENT);
        packet.func_180714_a(parent);
        sendPacket.accept(packet);
    }

    public void setExitDestinations(String parent, Consumer<PacketBuffer> sendPacket) {
        if (this.parentExists(parent)) {
            PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
            packet.writeLong(this.id);
            packet.func_180714_a(this.transportMode.toString());
            packet.func_180714_a(KEY_EXIT_DESTINATIONS);
            packet.func_180714_a(parent);
            packet.writeInt(this.exits.get(parent).size());
            this.exits.get(parent).forEach(arg_0 -> ((PacketBuffer)packet).func_180714_a(arg_0));
            sendPacket.accept(packet);
        }
    }

    public Map<String, List<String>> getGeneratedExits() {
        ArrayList<String> exitParents = new ArrayList<String>(this.exits.keySet());
        exitParents.sort(String::compareTo);
        HashMap<String, List<String>> generatedExits = new HashMap<String, List<String>>();
        exitParents.forEach(parent -> {
            String exitLetter = parent.substring(0, 1);
            if (!generatedExits.containsKey(exitLetter)) {
                generatedExits.put(exitLetter, new ArrayList());
            }
            ((List)generatedExits.get(exitLetter)).addAll((Collection)this.exits.get(parent));
            generatedExits.put((String)parent, this.exits.get(parent));
        });
        return generatedExits;
    }

    private void setExitParent(String oldParent, String newParent) {
        if (this.parentExists(oldParent)) {
            ArrayList existingDestinations = this.exits.get(oldParent);
            this.exits.remove(oldParent);
            this.exits.put(newParent, existingDestinations == null ? new ArrayList() : existingDestinations);
        } else {
            this.exits.put(newParent, new ArrayList());
        }
    }

    private boolean parentExists(String parent) {
        return parent != null && this.exits.containsKey(parent);
    }

    public static long serializeExit(String exit) {
        char[] characters = exit.toCharArray();
        long code = 0L;
        for (char character : characters) {
            code <<= 8;
            code += (long)character;
        }
        return code;
    }

    public static String deserializeExit(long code) {
        StringBuilder exit = new StringBuilder();
        for (long charCodes = code; charCodes > 0L; charCodes >>= 8) {
            exit.insert(0, (char)(charCodes & 0xFFL));
        }
        return exit.toString();
    }
}

