/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import mtr.data.RailwayData;
import mtr.data.Station;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TicketSystem {
    public static final String BALANCE_OBJECTIVE = "mtr_balance";
    private static final String ENTRY_ZONE_OBJECTIVE = "mtr_entry_zone";
    private static final int BASE_FARE = 2;
    private static final int ZONE_FARE = 1;
    private static final int EVASION_FINE = 500;

    public static EnumTicketBarrierOpen passThrough(World world, BlockPos pos, PlayerEntity player, boolean isEntrance, boolean isExit, SoundEvent entrySound, SoundEvent entrySoundConcessionary, SoundEvent exitSound, SoundEvent exitSoundConcessionary, SoundEvent failSound, boolean remindIfNoRecord) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        Station station = RailwayData.getStation(railwayData.stations, railwayData.dataCache, pos);
        if (station == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        TicketSystem.addObjectivesIfMissing(world);
        Score balanceScore = TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE);
        Score entryZoneScore = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_OBJECTIVE);
        boolean isEntering = isEntrance && isExit ? entryZoneScore.func_96652_c() == 0 : isEntrance;
        boolean canOpen = isEntering ? TicketSystem.onEnter(station, player, balanceScore, entryZoneScore, remindIfNoRecord) : TicketSystem.onExit(station, player, balanceScore, entryZoneScore, remindIfNoRecord);
        if (canOpen) {
            world.func_184133_a(null, pos, TicketSystem.isConcessionary(player) ? (isEntering ? entrySoundConcessionary : exitSoundConcessionary) : (isEntering ? entrySound : exitSound), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (failSound != null) {
            world.func_184133_a(null, pos, failSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return canOpen ? (TicketSystem.isConcessionary(player) ? EnumTicketBarrierOpen.OPEN_CONCESSIONARY : EnumTicketBarrierOpen.OPEN) : EnumTicketBarrierOpen.CLOSED;
    }

    public static void addObjectivesIfMissing(World world) {
        try {
            world.func_96441_U().func_199868_a(BALANCE_OBJECTIVE, ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("Balance"), ScoreCriteria.RenderType.INTEGER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            world.func_96441_U().func_199868_a(ENTRY_ZONE_OBJECTIVE, ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("Entry Zone"), ScoreCriteria.RenderType.INTEGER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Score getPlayerScore(World world, PlayerEntity player, String objectiveName) {
        return world.func_96441_U().func_96529_a(player.func_146103_bH().getName(), world.func_96441_U().func_96518_b(objectiveName));
    }

    private static boolean onEnter(Station station, PlayerEntity player, Score balanceScore, Score entryZoneScore, boolean remindIfNoRecord) {
        int entryZone = entryZoneScore.func_96652_c();
        if (entryZone != 0) {
            if (remindIfNoRecord) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.already_entered"), true);
                return false;
            }
            entryZoneScore.func_96647_c(0);
            balanceScore.func_96649_a(-500);
        }
        if (balanceScore.func_96652_c() >= 0) {
            entryZoneScore.func_96647_c(TicketSystem.encodeZone(station.zone));
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.enter_barrier", new Object[]{String.format("%s (%s)", station.name.replace('|', ' '), station.zone), balanceScore.func_96652_c()}), true);
            return true;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.insufficient_balance", new Object[]{balanceScore.func_96652_c()}), true);
        return false;
    }

    private static boolean onExit(Station station, PlayerEntity player, Score balanceScore, Score entryZoneScore, boolean remindIfNoRecord) {
        int finalFare;
        int entryZone = entryZoneScore.func_96652_c();
        int fare = 2 + 1 * Math.abs(station.zone - TicketSystem.decodeZone(entryZone));
        int n = entryZone != 0 ? (TicketSystem.isConcessionary(player) ? (int)Math.ceil((float)fare / 2.0f) : fare) : (finalFare = 500);
        if (entryZone == 0 && remindIfNoRecord) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.already_exited"), true);
            return false;
        }
        entryZoneScore.func_96647_c(0);
        balanceScore.func_96649_a(-finalFare);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.exit_barrier", new Object[]{String.format("%s (%s)", station.name.replace('|', ' '), station.zone), finalFare, balanceScore.func_96652_c()}), true);
        return true;
    }

    private static boolean isConcessionary(PlayerEntity player) {
        return player.func_184812_l_();
    }

    private static int encodeZone(int zone) {
        return zone >= 0 ? zone + 1 : zone;
    }

    private static int decodeZone(int zone) {
        return zone > 0 ? zone - 1 : zone;
    }

    public static enum EnumTicketBarrierOpen implements IStringSerializable
    {
        CLOSED("closed"),
        OPEN("open"),
        OPEN_CONCESSIONARY("open_concessionary");

        private final String name;

        private EnumTicketBarrierOpen(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }
}

