/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPlatform;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TrainType;
import mtr.packet.IPacket;
import mtr.path.PathData;
import net.minecraft.block.Block;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class Train
extends NameColorDataBase
implements IPacket,
IGui {
    protected float speed;
    protected float railProgress;
    protected float stopCounter;
    protected int nextStoppingIndex;
    protected boolean reversed;
    protected boolean isOnRoute = false;
    public final long sidingId;
    protected final String trainId;
    protected final TrainType baseTrainType;
    protected final int trainCars;
    protected final List<PathData> path;
    protected final List<Float> distances;
    protected final Set<UUID> ridingEntities = new HashSet<UUID>();
    protected final Inventory inventory;
    protected final float accelerationConstant;
    private final float railLength;
    public static final float ACCELERATION_DEFAULT = 0.01f;
    protected static final int MAX_CHECK_DISTANCE = 32;
    protected static final int DOOR_MOVE_TIME = 64;
    private static final int DOOR_DELAY = 20;
    private static final String KEY_SPEED = "speed";
    private static final String KEY_ACCELERATION_CONSTANT = "acceleration_constant";
    private static final String KEY_RAIL_PROGRESS = "rail_progress";
    private static final String KEY_STOP_COUNTER = "stop_counter";
    private static final String KEY_NEXT_STOPPING_INDEX = "next_stopping_index";
    private static final String KEY_REVERSED = "reversed";
    private static final String KEY_IS_ON_ROUTE = "is_on_route";
    private static final String KEY_TRAIN_TYPE = "train_type";
    private static final String KEY_TRAIN_CUSTOM_ID = "train_custom_id";
    private static final String KEY_RIDING_ENTITIES = "riding_entities";
    private static final String KEY_CARGO = "cargo";

    public Train(long id, long sidingId, float railLength, String trainId, TrainType baseTrainType, int trainCars, List<PathData> path, List<Float> distances, float accelerationConstant) {
        super(id);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.trainId = trainId;
        this.baseTrainType = baseTrainType;
        this.trainCars = trainCars;
        this.path = path;
        this.distances = distances;
        float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.inventory = new Inventory(trainCars);
    }

    public Train(long sidingId, float railLength, List<PathData> path, List<Float> distances, Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.path = path;
        this.distances = distances;
        this.speed = messagePackHelper.getFloat(KEY_SPEED);
        float tempAccelerationConstant = RailwayData.round(messagePackHelper.getFloat(KEY_ACCELERATION_CONSTANT, 0.01f), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.railProgress = messagePackHelper.getFloat(KEY_RAIL_PROGRESS);
        this.stopCounter = messagePackHelper.getFloat(KEY_STOP_COUNTER);
        this.nextStoppingIndex = messagePackHelper.getInt(KEY_NEXT_STOPPING_INDEX);
        this.reversed = messagePackHelper.getBoolean(KEY_REVERSED);
        this.trainId = messagePackHelper.getString(KEY_TRAIN_CUSTOM_ID);
        this.baseTrainType = TrainType.getOrDefault(messagePackHelper.getString(KEY_TRAIN_TYPE));
        this.trainCars = Math.min(this.baseTrainType.transportMode.maxLength, (int)Math.floor(railLength / (float)this.baseTrainType.getSpacing() + 0.01f));
        this.isOnRoute = messagePackHelper.getBoolean(KEY_IS_ON_ROUTE);
        messagePackHelper.iterateArrayValue(KEY_RIDING_ENTITIES, value -> this.ridingEntities.add(UUID.fromString(value.asStringValue().asString())));
        Inventory inventory1 = new Inventory(this.trainCars);
        if (map.containsKey(KEY_CARGO) && !map.get(KEY_CARGO).isNilValue()) {
            byte[] rawNbt = map.get(KEY_CARGO).asBinaryValue().asByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(rawNbt);
            try {
                CompoundNBT compoundTag = CompressedStreamTools.func_74794_a((DataInput)new DataInputStream(inputStream));
                NonNullList stacks = NonNullList.func_191197_a((int)this.trainCars, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundTag.func_74775_l(KEY_CARGO), (NonNullList)stacks);
                inventory1 = new Inventory((ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.inventory = inventory1;
    }

    @Deprecated
    public Train(long sidingId, float railLength, List<PathData> path, List<Float> distances, CompoundNBT compoundTag) {
        super(compoundTag);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.path = path;
        this.distances = distances;
        this.speed = compoundTag.func_74760_g(KEY_SPEED);
        this.accelerationConstant = 0.01f;
        this.railProgress = compoundTag.func_74760_g(KEY_RAIL_PROGRESS);
        this.stopCounter = compoundTag.func_74760_g(KEY_STOP_COUNTER);
        this.nextStoppingIndex = compoundTag.func_74762_e(KEY_NEXT_STOPPING_INDEX);
        this.reversed = compoundTag.func_74767_n(KEY_REVERSED);
        this.trainId = compoundTag.func_74779_i(KEY_TRAIN_CUSTOM_ID);
        this.baseTrainType = TrainType.getOrDefault(compoundTag.func_74779_i(KEY_TRAIN_TYPE));
        this.trainCars = Math.min(this.baseTrainType.transportMode.maxLength, (int)Math.floor(railLength / (float)this.baseTrainType.getSpacing() + 0.01f));
        this.isOnRoute = compoundTag.func_74767_n(KEY_IS_ON_ROUTE);
        CompoundNBT tagRidingEntities = compoundTag.func_74775_l(KEY_RIDING_ENTITIES);
        tagRidingEntities.func_150296_c().forEach(key -> this.ridingEntities.add(tagRidingEntities.func_186857_a(key)));
        NonNullList stacks = NonNullList.func_191197_a((int)this.trainCars, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compoundTag.func_74775_l(KEY_CARGO), (NonNullList)stacks);
        this.inventory = new Inventory((ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
    }

    public Train(PacketBuffer packet) {
        super(packet);
        this.path = new ArrayList<PathData>();
        this.distances = new ArrayList<Float>();
        int pathSize = packet.readInt();
        for (int i = 0; i < pathSize; ++i) {
            this.path.add(new PathData(packet));
            this.distances.add(Float.valueOf(packet.readFloat()));
        }
        this.sidingId = packet.readLong();
        this.railLength = packet.readFloat();
        this.speed = packet.readFloat();
        float tempAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.railProgress = packet.readFloat();
        this.stopCounter = packet.readFloat();
        this.nextStoppingIndex = packet.readInt();
        this.reversed = packet.readBoolean();
        this.trainId = packet.func_150789_c(Short.MAX_VALUE);
        this.baseTrainType = TrainType.values()[packet.readInt()];
        this.trainCars = Math.min(this.baseTrainType.transportMode.maxLength, (int)Math.floor(this.railLength / (float)this.baseTrainType.getSpacing() + 0.01f));
        this.isOnRoute = packet.readBoolean();
        int ridingEntitiesCount = packet.readInt();
        for (int i = 0; i < ridingEntitiesCount; ++i) {
            this.ridingEntities.add(packet.func_179253_g());
        }
        this.inventory = null;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_SPEED).packFloat(this.speed);
        messagePacker.packString(KEY_ACCELERATION_CONSTANT).packFloat(this.accelerationConstant);
        messagePacker.packString(KEY_RAIL_PROGRESS).packFloat(this.railProgress);
        messagePacker.packString(KEY_STOP_COUNTER).packFloat(this.stopCounter);
        messagePacker.packString(KEY_NEXT_STOPPING_INDEX).packInt(this.nextStoppingIndex);
        messagePacker.packString(KEY_REVERSED).packBoolean(this.reversed);
        messagePacker.packString(KEY_TRAIN_CUSTOM_ID).packString(this.trainId);
        messagePacker.packString(KEY_TRAIN_TYPE).packString(this.baseTrainType.toString());
        messagePacker.packString(KEY_IS_ON_ROUTE).packBoolean(this.isOnRoute);
        messagePacker.packString(KEY_RIDING_ENTITIES).packArrayHeader(this.ridingEntities.size());
        for (UUID uuid : this.ridingEntities) {
            messagePacker.packString(uuid.toString());
        }
        messagePacker.packString(KEY_CARGO);
        if (this.inventory != null) {
            NonNullList stacks = NonNullList.func_191197_a((int)this.inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            int totalCount = 0;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                stacks.set(i, (Object)this.inventory.func_70301_a(i));
                totalCount += this.inventory.func_70301_a(i).func_190916_E();
            }
            if (totalCount > 0) {
                CompoundNBT tag = ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), (NonNullList)stacks);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                CompressedStreamTools.func_74800_a((CompoundNBT)tag, (DataOutput)new DataOutputStream(outputStream));
                messagePacker.packBinaryHeader(outputStream.size());
                messagePacker.writePayload(outputStream.toByteArray());
            } else {
                messagePacker.packNil();
            }
        } else {
            messagePacker.packNil();
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 11;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        super.writePacket(packet);
        int pathSize = Math.min(this.path.size(), this.distances.size());
        packet.writeInt(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path.get(i).writePacket(packet);
            packet.writeFloat(this.distances.get(i).floatValue());
        }
        packet.writeLong(this.sidingId);
        packet.writeFloat(this.railLength);
        packet.writeFloat(this.speed);
        packet.writeFloat(this.accelerationConstant);
        packet.writeFloat(this.railProgress);
        packet.writeFloat(this.stopCounter);
        packet.writeInt(this.nextStoppingIndex);
        packet.writeBoolean(this.reversed);
        packet.func_180714_a(this.trainId);
        packet.writeInt(this.baseTrainType.ordinal());
        packet.writeBoolean(this.isOnRoute);
        packet.writeInt(this.ridingEntities.size());
        this.ridingEntities.forEach(arg_0 -> ((PacketBuffer)packet).func_179252_a(arg_0));
    }

    @Override
    protected final boolean hasTransportMode() {
        return false;
    }

    public final boolean getIsOnRoute() {
        return this.isOnRoute;
    }

    public final float getRailProgress() {
        return this.railProgress;
    }

    public final boolean closeToDepot(int trainDistance) {
        return !this.isOnRoute || this.railProgress < (float)trainDistance + this.railLength;
    }

    protected final void simulateTrain(World world, float ticksElapsed, Depot depot) {
        if (world == null) {
            return;
        }
        try {
            float doorValueRaw;
            float oldDoorValue;
            int trainSpacing = this.baseTrainType.getSpacing();
            float oldRailProgress = this.railProgress;
            float oldSpeed = this.speed;
            if (this.nextStoppingIndex >= this.path.size()) {
                return;
            }
            int dwellTicks = this.path.get((int)this.nextStoppingIndex).dwellTime * 10;
            if (!this.isOnRoute) {
                this.railProgress = (this.railLength + (float)(this.trainCars * trainSpacing)) / 2.0f;
                oldDoorValue = 0.0f;
                doorValueRaw = 0.0f;
                this.speed = 0.0f;
                if (this.canDeploy(depot)) {
                    this.startUp(world, this.trainCars, trainSpacing, this.isOppositeRail());
                }
            } else {
                oldDoorValue = Math.abs(this.getDoorValue());
                float newAcceleration = this.accelerationConstant * ticksElapsed;
                if (this.railProgress >= this.distances.get(this.distances.size() - 1).floatValue() - (this.railLength - (float)(this.trainCars * trainSpacing)) / 2.0f) {
                    this.isOnRoute = false;
                    this.ridingEntities.clear();
                    doorValueRaw = 0.0f;
                } else {
                    if (this.speed <= 0.0f) {
                        this.speed = 0.0f;
                        if (dwellTicks == 0) {
                            doorValueRaw = 0.0f;
                        } else {
                            this.stopCounter += ticksElapsed;
                            doorValueRaw = this.getDoorValue();
                        }
                        if (this.stopCounter >= (float)dwellTicks) {
                            boolean isOppositeRail = this.isOppositeRail();
                            if (!this.isRailBlocked(this.getIndex(0, trainSpacing, true) + (isOppositeRail ? 2 : 1))) {
                                this.startUp(world, this.trainCars, trainSpacing, isOppositeRail);
                            }
                        }
                    } else {
                        float stoppingDistance;
                        int checkIndex;
                        if (!world.func_201670_d() && this.isRailBlocked(checkIndex = this.getIndex(0, trainSpacing, true) + 1)) {
                            this.nextStoppingIndex = checkIndex - 1;
                        }
                        if ((stoppingDistance = this.distances.get(this.nextStoppingIndex).floatValue() - this.railProgress) < 0.5f * this.speed * this.speed / this.accelerationConstant) {
                            this.speed = stoppingDistance == 0.0f ? 0.01f : Math.max(this.speed - 0.5f * this.speed * this.speed / stoppingDistance * ticksElapsed, 0.01f);
                        } else {
                            float railSpeed = this.getRailSpeed(this.getIndex(0, trainSpacing, false));
                            if (this.speed < railSpeed) {
                                this.speed = Math.min(this.speed + newAcceleration, railSpeed);
                            } else if (this.speed > railSpeed) {
                                this.speed = Math.max(this.speed - newAcceleration, railSpeed);
                            }
                        }
                        doorValueRaw = 0.0f;
                    }
                    this.railProgress += this.speed * ticksElapsed;
                    if (this.railProgress > this.distances.get(this.nextStoppingIndex).floatValue()) {
                        this.railProgress = this.distances.get(this.nextStoppingIndex).floatValue();
                        this.speed = 0.0f;
                    }
                }
            }
            if (!this.path.isEmpty()) {
                Vector3d[] positions = new Vector3d[this.trainCars + 1];
                for (int i = 0; i <= this.trainCars; ++i) {
                    positions[i] = this.getRoutePosition(this.reversed ? this.trainCars - i : i, trainSpacing);
                }
                if (this.handlePositions(world, positions, ticksElapsed, doorValueRaw, oldDoorValue, oldRailProgress)) {
                    double[] prevX = new double[]{0.0};
                    double[] prevY = new double[]{0.0};
                    double[] prevZ = new double[]{0.0};
                    float[] prevYaw = new float[]{0.0f};
                    float[] prevPitch = new float[]{0.0f};
                    for (int i = 0; i < this.trainCars; ++i) {
                        int ridingCar = i;
                        this.calculateCar(world, positions, i, Math.abs(doorValueRaw), dwellTicks, (x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen) -> {
                            this.simulateCar(world, ridingCar, ticksElapsed, x, y, z, yaw, pitch, prevX[0], prevY[0], prevZ[0], prevYaw[0], prevPitch[0], doorLeftOpen, doorRightOpen, realSpacing, doorValueRaw, oldSpeed, oldDoorValue, oldRailProgress);
                            prevX[0] = x;
                            prevY[0] = y;
                            prevZ[0] = z;
                            prevYaw[0] = yaw;
                            prevPitch[0] = pitch;
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void calculateCar(World world, Vector3d[] positions, int index, float doorValue, int dwellTicks, CalculateCarCallback calculateCarCallback) {
        Vector3d pos1 = positions[index];
        Vector3d pos2 = positions[index + 1];
        if (pos1 != null && pos2 != null) {
            double x = Train.getAverage(pos1.field_72450_a, pos2.field_72450_a);
            double y = Train.getAverage(pos1.field_72448_b, pos2.field_72448_b) + 1.0;
            double z = Train.getAverage(pos1.field_72449_c, pos2.field_72449_c);
            double realSpacing = pos2.func_72438_d(pos1);
            float yaw = (float)MathHelper.func_181159_b((double)(pos2.field_72450_a - pos1.field_72450_a), (double)(pos2.field_72449_c - pos1.field_72449_c));
            float pitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((pos2.field_72448_b - pos1.field_72448_b) / realSpacing);
            boolean doorLeftOpen = this.scanDoors(world, x, y, z, (float)Math.PI + yaw, pitch, realSpacing / 2.0, doorValue, dwellTicks) && doorValue > 0.0f;
            boolean doorRightOpen = this.scanDoors(world, x, y, z, yaw, pitch, realSpacing / 2.0, doorValue, dwellTicks) && doorValue > 0.0f;
            calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen);
        }
    }

    protected final int getIndex(int car, int trainSpacing, boolean roundDown) {
        return this.getIndex(this.getRailProgress(car, trainSpacing), roundDown);
    }

    protected final int getIndex(float tempRailProgress, boolean roundDown) {
        for (int i = 0; i < this.path.size(); ++i) {
            float tempDistance = this.distances.get(i).floatValue();
            if (!(tempRailProgress < tempDistance) && (!roundDown || tempRailProgress != tempDistance)) continue;
            return i;
        }
        return this.path.size() - 1;
    }

    protected final float getRailSpeed(int railIndex) {
        float railSpeed;
        RailType thisRail = this.path.get((int)railIndex).rail.railType;
        if (thisRail.canAccelerate) {
            railSpeed = thisRail.maxBlocksPerTick;
        } else {
            RailType lastRail = railIndex > 0 ? this.path.get((int)(railIndex - 1)).rail.railType : thisRail;
            railSpeed = Math.max(lastRail.canAccelerate ? lastRail.maxBlocksPerTick : RailType.WOODEN.maxBlocksPerTick, this.speed);
        }
        return railSpeed;
    }

    protected void startUp(World world, int trainCars, int trainSpacing, boolean isOppositeRail) {
    }

    protected abstract void simulateCar(World var1, int var2, float var3, double var4, double var6, double var8, float var10, float var11, double var12, double var14, double var16, float var18, float var19, boolean var20, boolean var21, double var22, float var24, float var25, float var26, float var27);

    protected abstract boolean handlePositions(World var1, Vector3d[] var2, float var3, float var4, float var5, float var6);

    protected abstract boolean canDeploy(Depot var1);

    protected abstract boolean isRailBlocked(int var1);

    protected abstract boolean skipScanBlocks(World var1, double var2, double var4, double var6);

    protected abstract boolean openDoors(World var1, Block var2, BlockPos var3, float var4, int var5);

    protected abstract double asin(double var1);

    private boolean isOppositeRail() {
        return this.path.size() > this.nextStoppingIndex + 1 && this.path.get(this.nextStoppingIndex).isOppositeRail(this.path.get(this.nextStoppingIndex + 1));
    }

    private float getRailProgress(int car, int trainSpacing) {
        return this.railProgress - (float)(car * trainSpacing);
    }

    private Vector3d getRoutePosition(int car, int trainSpacing) {
        float tempRailProgress = Math.max(this.getRailProgress(car, trainSpacing) - this.baseTrainType.modelZOffset, 0.0f);
        int index = this.getIndex(tempRailProgress, false);
        return this.path.get((int)index).rail.getPosition(tempRailProgress - (index == 0 ? 0.0f : this.distances.get(index - 1).floatValue()));
    }

    private float getDoorValue() {
        int dwellTicks = this.path.get((int)this.nextStoppingIndex).dwellTime * 10;
        float maxDoorMoveTime = Math.min(64, dwellTicks / 2 - 20);
        float stage1 = 20.0f;
        float stage2 = 20.0f + maxDoorMoveTime;
        float stage3 = (float)(dwellTicks - 20) - maxDoorMoveTime;
        float stage4 = dwellTicks - 20;
        if (this.stopCounter < 20.0f || this.stopCounter >= stage4) {
            return 0.0f;
        }
        if (this.stopCounter >= stage2 && this.stopCounter < stage3) {
            return 1.0f;
        }
        if (this.stopCounter < stage2) {
            return (this.stopCounter - 20.0f) / 64.0f;
        }
        if (this.stopCounter >= stage3) {
            return -(stage4 - this.stopCounter) / 64.0f;
        }
        return 0.0f;
    }

    private boolean scanDoors(World world, double trainX, double trainY, double trainZ, float checkYaw, float pitch, double halfSpacing, float doorValue, int dwellTicks) {
        if (this.skipScanBlocks(world, trainX, trainY, trainZ)) {
            return false;
        }
        boolean hasPlatform = false;
        Vector3d offsetVec = new Vector3d(1.0, 0.0, 0.0).func_178785_b(checkYaw).func_178789_a(pitch);
        Vector3d traverseVec = new Vector3d(0.0, 0.0, 1.0).func_178785_b(checkYaw).func_178789_a(pitch);
        for (int checkX = 1; checkX <= 3; ++checkX) {
            for (int checkY = -2; checkY <= 0; ++checkY) {
                for (double checkZ = -halfSpacing; checkZ <= halfSpacing; checkZ += 1.0) {
                    BlockPos checkPos = new BlockPos(trainX + offsetVec.field_72450_a * (double)checkX + traverseVec.field_72450_a * checkZ, trainY + (double)checkY, trainZ + offsetVec.field_72449_c * (double)checkX + traverseVec.field_72449_c * checkZ);
                    Block block = world.func_180495_p(checkPos).func_177230_c();
                    if (!(block instanceof BlockPlatform) && !(block instanceof BlockPSDAPGBase)) continue;
                    if (this.openDoors(world, block, checkPos, doorValue, dwellTicks)) {
                        return true;
                    }
                    hasPlatform = true;
                }
            }
        }
        return hasPlatform;
    }

    public static double getAverage(double a, double b) {
        return (a + b) / 2.0;
    }

    public static double getValueFromPercentage(double percentage, double total) {
        return (percentage - 0.5) * total;
    }

    @FunctionalInterface
    protected static interface CalculateCarCallback {
        public void calculateCarCallback(double var1, double var3, double var5, float var7, float var8, double var9, boolean var11, boolean var12);
    }
}

