/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.MTRClient;
import mtr.RegistryClient;
import mtr.client.ClientData;
import mtr.client.TrainClientRegistry;
import mtr.data.Depot;
import mtr.data.RailType;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TrainType;
import mtr.mappings.Utilities;
import mtr.path.PathData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class TrainClient
extends Train {
    private float clientPrevYaw;
    private boolean justMounted;
    private int previousInterval;
    private float oldPercentageX;
    private float oldPercentageZ;
    private RenderTrainCallback renderTrainCallback;
    private RenderConnectionCallback renderConnectionCallback;
    private SpeedCallback speedCallback;
    private AnnouncementCallback announcementCallback;
    private AnnouncementCallback lightRailAnnouncementCallback;
    private final Set<Runnable> trainTranslucentRenders = new HashSet<Runnable>();
    private final List<Long> routeIds;
    private final List<Double> offset = new ArrayList<Double>();
    private final Map<UUID, Float> percentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> percentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Vector3d> riderPositions = new HashMap<UUID, Vector3d>();
    private static final float CONNECTION_HEIGHT = 2.25f;
    private static final float CONNECTION_Z_OFFSET = 0.5f;
    private static final float CONNECTION_X_OFFSET = 0.25f;
    private static final float TRAIN_WALKING_SPEED_MULTIPLIER = 0.25f;
    private static final int TRAIN_PERCENTAGE_UPDATE_INTERVAL = 20;
    private static final float VIVECRAFT_EYE_HEIGHT = 1.62f;

    public TrainClient(PacketBuffer packet) {
        super(packet);
        Siding siding = (Siding)ClientData.DATA_CACHE.sidingIdMap.get(this.sidingId);
        Depot depot = siding == null ? null : (Depot)ClientData.DATA_CACHE.sidingIdToDepot.get(siding.id);
        this.routeIds = depot == null ? new ArrayList() : depot.routeIds;
    }

    @Override
    protected void simulateCar(World world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing, float doorValueRaw, float oldSpeed, float oldDoorValue, float oldRailProgress) {
        Map<UUID, Vector3d> riderPositionsOffsets;
        Vector3d playerOffset;
        boolean noOffset;
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return;
        }
        float doorValue = Math.abs(doorValueRaw);
        boolean opening = doorValueRaw > 0.0f;
        BlockPos soundPos = new BlockPos(carX, carY, carZ);
        TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId, this.baseTrainType);
        trainProperties.playSpeedSoundEffect(world, soundPos, oldSpeed, this.speed);
        if (doorLeftOpen || doorRightOpen) {
            trainProperties.playDoorSoundEffect(world, soundPos, oldDoorValue, doorValue);
        }
        double newX = carX - ((noOffset = this.offset.isEmpty()) ? 0.0 : this.offset.get(0));
        double newY = carY - (noOffset ? 0.0 : this.offset.get(1));
        double newZ = carZ - (noOffset ? 0.0 : this.offset.get(2));
        Vector3d vector3d = playerOffset = noOffset ? null : new Vector3d(this.offset.get(3).doubleValue(), this.offset.get(4).doubleValue(), this.offset.get(5).doubleValue());
        if (noOffset) {
            riderPositionsOffsets = this.riderPositions;
        } else {
            riderPositionsOffsets = new HashMap<UUID, Vector3d>();
            this.riderPositions.forEach((uuid, position) -> riderPositionsOffsets.put((UUID)uuid, position.func_178786_a(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue())));
        }
        if (this.renderTrainCallback != null) {
            this.renderTrainCallback.renderTrainCallback(newX, newY, newZ, carYaw, carPitch, this.trainId, this.baseTrainType, ridingCar == 0, ridingCar == this.trainCars - 1, !this.reversed, doorLeftOpen ? doorValue : 0.0f, doorRightOpen ? doorValue : 0.0f, opening, this.isOnRoute, false, playerOffset, riderPositionsOffsets);
        }
        if (this.renderConnectionCallback != null && ridingCar > 0 && trainProperties.baseTrainType.hasGangwayConnection) {
            double newPrevCarX = prevCarX - (noOffset ? 0.0 : this.offset.get(0));
            double newPrevCarY = prevCarY - (noOffset ? 0.0 : this.offset.get(1));
            double newPrevCarZ = prevCarZ - (noOffset ? 0.0 : this.offset.get(2));
            float xStart = (float)this.baseTrainType.width / 2.0f - 0.25f;
            float zStart = (float)this.baseTrainType.getSpacing() / 2.0f - 0.5f;
            Vector3d prevPos1 = new Vector3d((double)xStart, (double)0.003125f, (double)zStart).func_178789_a(prevCarPitch).func_178785_b(prevCarYaw).func_72441_c(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vector3d prevPos2 = new Vector3d((double)xStart, 2.253124952316284, (double)zStart).func_178789_a(prevCarPitch).func_178785_b(prevCarYaw).func_72441_c(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vector3d prevPos3 = new Vector3d((double)(-xStart), 2.253124952316284, (double)zStart).func_178789_a(prevCarPitch).func_178785_b(prevCarYaw).func_72441_c(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vector3d prevPos4 = new Vector3d((double)(-xStart), (double)0.003125f, (double)zStart).func_178789_a(prevCarPitch).func_178785_b(prevCarYaw).func_72441_c(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vector3d thisPos1 = new Vector3d((double)(-xStart), (double)0.003125f, (double)(-zStart)).func_178789_a(carPitch).func_178785_b(carYaw).func_72441_c(newX, newY, newZ);
            Vector3d thisPos2 = new Vector3d((double)(-xStart), 2.253124952316284, (double)(-zStart)).func_178789_a(carPitch).func_178785_b(carYaw).func_72441_c(newX, newY, newZ);
            Vector3d thisPos3 = new Vector3d((double)xStart, 2.253124952316284, (double)(-zStart)).func_178789_a(carPitch).func_178785_b(carYaw).func_72441_c(newX, newY, newZ);
            Vector3d thisPos4 = new Vector3d((double)xStart, (double)0.003125f, (double)(-zStart)).func_178789_a(carPitch).func_178785_b(carYaw).func_72441_c(newX, newY, newZ);
            this.renderConnectionCallback.renderConnectionCallback(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, newX, newY, newZ, carYaw, this.trainId, this.baseTrainType, this.isOnRoute, playerOffset);
        }
    }

    @Override
    protected boolean handlePositions(World world, Vector3d[] positions, float ticksElapsed, float doorValueRaw, float oldDoorValue, float oldRailProgress) {
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return false;
        }
        int interval = (int)Math.floor(MTRClient.getGameTick() / 20.0f);
        if (ticksElapsed > 0.0f) {
            this.offset.clear();
            this.riderPositions.clear();
            if (this.ridingEntities.contains(clientPlayer.func_110124_au())) {
                float targetProgress;
                if (clientPlayer.func_225608_bj_()) {
                    this.ridingEntities.remove(clientPlayer.func_110124_au());
                }
                int trainSpacing = this.baseTrainType.getSpacing();
                int headIndex = this.getIndex(0, trainSpacing, false);
                int stopIndex = ((PathData)this.path.get((int)headIndex)).stopIndex - 1;
                if (this.speedCallback != null) {
                    this.speedCallback.speedCallback(this.speed * 20.0f, stopIndex, this.routeIds);
                }
                if (this.announcementCallback != null && oldRailProgress < (targetProgress = ((Float)this.distances.get(this.getPreviousStoppingIndex(headIndex))).floatValue() + (float)((this.trainCars + 1) * trainSpacing)) && this.railProgress >= targetProgress) {
                    this.announcementCallback.announcementCallback(stopIndex, this.routeIds);
                }
                if (this.lightRailAnnouncementCallback != null && (oldDoorValue <= 0.0f && doorValueRaw != 0.0f || this.justMounted)) {
                    this.lightRailAnnouncementCallback.announcementCallback(stopIndex, this.routeIds);
                }
            }
            this.ridingEntities.forEach(uuid -> {
                boolean isClientPlayer = uuid.equals(clientPlayer.func_110124_au());
                if (!this.percentagesX.containsKey(uuid) || !this.newPercentagesX.containsKey(uuid)) {
                    this.percentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                    this.newPercentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                }
                if (!this.percentagesZ.containsKey(uuid) || !this.newPercentagesZ.containsKey(uuid)) {
                    this.percentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                    this.newPercentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                }
                Train.CalculateCarCallback calculateCarCallback = (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    Vector3d playerOffset = new Vector3d(TrainClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), this.baseTrainType.width), doorLeftOpenRender || doorRightOpenRender ? 0.0 : (double)this.baseTrainType.riderOffset, TrainClient.getValueFromPercentage(MathHelper.func_226164_h_((float)this.percentagesZ.get(uuid).floatValue()), realSpacingRender)).func_178789_a(pitch).func_178785_b(yaw);
                    ClientData.updatePlayerRidingOffset(uuid);
                    this.riderPositions.put((UUID)uuid, playerOffset.func_72441_c(x, y, z));
                    if (isClientPlayer) {
                        clientPlayer.field_70143_R = 0.0f;
                        clientPlayer.func_213293_j(0.0, 0.0, 0.0);
                        clientPlayer.func_70659_e(0.0f);
                        clientPlayer.func_242281_f(x + playerOffset.field_72450_a, y + playerOffset.field_72448_b + (double)(MTRClient.isVivecraft() ? 1.62f : 0.0f), z + playerOffset.field_72449_c);
                        if (this.speed > 0.0f || MTRClient.isVivecraft()) {
                            if (!MTRClient.isVivecraft()) {
                                Utilities.incrementYaw((Entity)clientPlayer, -((float)Math.toDegrees(yaw - this.clientPrevYaw)));
                            }
                            this.offset.add(x);
                            this.offset.add(y);
                            this.offset.add(z);
                            this.offset.add(playerOffset.field_72450_a);
                            this.offset.add(playerOffset.field_72448_b + (double)(MTRClient.isVivecraft() ? 1.62f : clientPlayer.func_70047_e()));
                            this.offset.add(playerOffset.field_72449_c);
                        }
                        this.clientPrevYaw = yaw;
                    }
                };
                int currentRidingCar = MathHelper.func_76125_a((int)((int)Math.floor(this.percentagesZ.get(uuid).floatValue())), (int)0, (int)(positions.length - 2));
                float doorValue = Math.abs(doorValueRaw);
                this.calculateCar(world, positions, currentRidingCar, doorValue, 0, (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    float newPercentageZ;
                    float newPercentageX;
                    boolean hasGangwayConnection = this.baseTrainType.hasGangwayConnection;
                    float speedMultiplier = ticksElapsed * 0.25f;
                    if (isClientPlayer) {
                        Vector3d movement = new Vector3d((double)Math.abs(clientPlayer.field_70702_br) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.field_70702_br) : 0.0, 0.0, (double)Math.abs(clientPlayer.field_191988_bg) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.field_191988_bg) : 0.0).func_178785_b((float)(-Math.toRadians(Utilities.getYaw((Entity)clientPlayer))) - yaw);
                        float tempPercentageX = this.percentagesX.get(uuid).floatValue() + (float)movement.field_72450_a / (float)this.baseTrainType.width;
                        float tempPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(realSpacingRender == 0.0 ? 0.0 : movement.field_72449_c / realSpacingRender);
                        newPercentageX = MathHelper.func_76131_a((float)tempPercentageX, (float)(doorLeftOpenRender ? -3.0f : 0.0f), (float)(doorRightOpenRender ? 4.0f : 1.0f));
                        newPercentageZ = MathHelper.func_76131_a((float)tempPercentageZ, (float)((hasGangwayConnection ? 0.0f : (float)currentRidingCar + 0.05f) + 0.01f), (float)((hasGangwayConnection ? (float)this.trainCars : (float)currentRidingCar + 0.95f) - 0.01f));
                        if (interval != this.previousInterval && (newPercentageX != this.oldPercentageX || newPercentageZ != this.oldPercentageZ)) {
                            PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                            packet.writeLong(this.id);
                            packet.writeFloat(newPercentageX);
                            packet.writeFloat(newPercentageZ);
                            packet.func_179252_a(uuid);
                            RegistryClient.sendToServer(PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packet);
                            this.oldPercentageX = newPercentageX;
                            this.oldPercentageZ = newPercentageZ;
                        }
                    } else {
                        double distanceZ;
                        double distanceX = TrainClient.getValueFromPercentage(this.newPercentagesX.get(uuid).floatValue(), this.baseTrainType.width) - TrainClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), this.baseTrainType.width);
                        double manhattanDistance = Math.abs(distanceX + (distanceZ = TrainClient.getValueFromPercentage(this.newPercentagesZ.get(uuid).floatValue(), realSpacingRender) - TrainClient.getValueFromPercentage(this.percentagesZ.get(uuid).floatValue(), realSpacingRender)));
                        if (manhattanDistance == 0.0 || distanceX * distanceX + distanceZ * distanceZ < (double)(speedMultiplier * speedMultiplier)) {
                            newPercentageX = this.newPercentagesX.get(uuid).floatValue();
                            newPercentageZ = this.newPercentagesZ.get(uuid).floatValue();
                        } else {
                            newPercentageX = this.percentagesX.get(uuid).floatValue() + (float)(distanceX / manhattanDistance * (double)speedMultiplier / (double)this.baseTrainType.width);
                            newPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(realSpacingRender == 0.0 ? 0.0 : distanceZ / manhattanDistance * (double)speedMultiplier / realSpacingRender);
                        }
                    }
                    this.percentagesX.put((UUID)uuid, Float.valueOf(newPercentageX));
                    this.percentagesZ.put((UUID)uuid, Float.valueOf(newPercentageZ));
                    int newRidingCar = MathHelper.func_76125_a((int)((int)Math.floor(newPercentageZ)), (int)0, (int)(positions.length - 2));
                    if (currentRidingCar == newRidingCar) {
                        calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender);
                    } else {
                        this.calculateCar(world, positions, newRidingCar, Math.abs(doorValueRaw), 0, calculateCarCallback);
                    }
                });
            });
        }
        this.previousInterval = interval;
        this.justMounted = false;
        return true;
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        return false;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        return false;
    }

    @Override
    protected boolean skipScanBlocks(World world, double trainX, double trainY, double trainZ) {
        return false;
    }

    @Override
    protected boolean openDoors(World world, Block block, BlockPos checkPos, float doorValue, int dwellTicks) {
        return true;
    }

    @Override
    protected double asin(double value) {
        return Math.asin(value);
    }

    public void simulateTrain(World world, float ticksElapsed, RenderTrainCallback renderTrainCallback, RenderConnectionCallback renderConnectionCallback, SpeedCallback speedCallback, AnnouncementCallback announcementCallback, AnnouncementCallback lightRailAnnouncementCallback) {
        this.trainTranslucentRenders.clear();
        this.renderTrainCallback = (x, y, z, yaw, pitch, customId, baseTrainType1, isEnd1Head, isEnd2Head, head1IsFront, doorLeftValue, doorRightValue, opening, lightsOn, isTranslucent, playerOffset, riderPositions) -> {
            renderTrainCallback.renderTrainCallback(x, y, z, yaw, pitch, customId, baseTrainType1, isEnd1Head, isEnd2Head, head1IsFront, doorLeftValue, doorRightValue, opening, lightsOn, false, playerOffset, riderPositions);
            this.trainTranslucentRenders.add(() -> renderTrainCallback.renderTrainCallback(x, y, z, yaw, pitch, customId, baseTrainType1, isEnd1Head, isEnd2Head, head1IsFront, doorLeftValue, doorRightValue, opening, lightsOn, true, playerOffset, new HashMap<UUID, Vector3d>()));
        };
        this.renderConnectionCallback = renderConnectionCallback;
        this.speedCallback = speedCallback;
        this.announcementCallback = announcementCallback;
        this.lightRailAnnouncementCallback = lightRailAnnouncementCallback;
        this.simulateTrain(world, ticksElapsed, null);
    }

    public void renderTranslucent() {
        this.trainTranslucentRenders.forEach(Runnable::run);
        this.trainTranslucentRenders.clear();
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_110124_au().equals(uuid)) {
            this.justMounted = true;
        }
        this.ridingEntities.add(uuid);
        this.percentagesX.put(uuid, Float.valueOf(percentageX));
        this.percentagesZ.put(uuid, Float.valueOf(percentageZ));
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void copyFromTrain(Train train) {
        this.path.clear();
        this.distances.clear();
        this.ridingEntities.clear();
        this.path.addAll(train.path);
        this.distances.addAll(train.distances);
        this.ridingEntities.addAll(train.ridingEntities);
        this.speed = train.speed;
        this.railProgress = train.railProgress;
        this.stopCounter = train.stopCounter;
        this.nextStoppingIndex = train.nextStoppingIndex;
        this.reversed = train.reversed;
        this.isOnRoute = train.isOnRoute;
    }

    public float getSpeed() {
        return this.speed;
    }

    private int getPreviousStoppingIndex(int headIndex) {
        for (int i = headIndex; i >= 0; --i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0 || ((PathData)this.path.get((int)i)).rail.railType != RailType.PLATFORM) continue;
            return i;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface RenderTrainCallback {
        public void renderTrainCallback(double var1, double var3, double var5, float var7, float var8, String var9, TrainType var10, boolean var11, boolean var12, boolean var13, float var14, float var15, boolean var16, boolean var17, boolean var18, Vector3d var19, Map<UUID, Vector3d> var20);
    }

    @FunctionalInterface
    public static interface RenderConnectionCallback {
        public void renderConnectionCallback(Vector3d var1, Vector3d var2, Vector3d var3, Vector3d var4, Vector3d var5, Vector3d var6, Vector3d var7, Vector3d var8, double var9, double var11, double var13, float var15, String var16, TrainType var17, boolean var18, Vector3d var19);
    }

    @FunctionalInterface
    public static interface SpeedCallback {
        public void speedCallback(float var1, int var2, List<Long> var3);
    }

    @FunctionalInterface
    public static interface AnnouncementCallback {
        public void announcementCallback(int var1, List<Long> var2);
    }
}

