/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.Registry;
import mtr.TrigCache;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockTrainAnnouncer;
import mtr.block.BlockTrainCargoLoader;
import mtr.block.BlockTrainCargoUnloader;
import mtr.block.BlockTrainRedstoneSensor;
import mtr.block.BlockTrainSensorBase;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Train;
import mtr.data.TrainType;
import mtr.mappings.Utilities;
import mtr.path.PathData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.msgpack.value.Value;

public class TrainServer
extends Train {
    private boolean canDeploy;
    private List<Map<UUID, Long>> trainPositions;
    private Map<PlayerEntity, Set<TrainServer>> trainsInPlayerRange = new HashMap<PlayerEntity, Set<TrainServer>>();
    private long routeId;
    private int updateRailProgressCounter;
    private final List<Siding.TimeSegment> timeSegments;
    private static final int TRAIN_UPDATE_DISTANCE = 128;
    private static final float INNER_PADDING = 0.5f;
    private static final int BOX_PADDING = 3;
    private static final int TICKS_TO_SEND_RAIL_PROGRESS = 40;

    public TrainServer(long id, long sidingId, float railLength, String trainId, TrainType baseTrainType, int trainCars, List<PathData> path, List<Float> distances, float accelerationConstant, List<Siding.TimeSegment> timeSegments) {
        super(id, sidingId, railLength, trainId, baseTrainType, trainCars, path, distances, accelerationConstant);
        this.timeSegments = timeSegments;
    }

    public TrainServer(long sidingId, float railLength, List<PathData> path, List<Float> distances, List<Siding.TimeSegment> timeSegments, Map<String, Value> map) {
        super(sidingId, railLength, path, distances, map);
        this.timeSegments = timeSegments;
    }

    @Deprecated
    public TrainServer(long sidingId, float railLength, List<PathData> path, List<Float> distances, List<Siding.TimeSegment> timeSegments, CompoundNBT compoundTag) {
        super(sidingId, railLength, path, distances, compoundTag);
        this.timeSegments = timeSegments;
    }

    @Override
    protected void startUp(World world, int trainCars, int trainSpacing, boolean isOppositeRail) {
        this.canDeploy = false;
        this.isOnRoute = true;
        this.stopCounter = 0.0f;
        this.speed = 0.01f;
        if (isOppositeRail) {
            this.railProgress += (float)(trainCars * trainSpacing);
            this.reversed = !this.reversed;
        }
        this.nextStoppingIndex = this.getNextStoppingIndex();
    }

    @Override
    protected void simulateCar(World world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing, float doorValueRaw, float oldSpeed, float oldDoorValue, float oldRailProgress) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        float halfSpacing = (float)this.baseTrainType.getSpacing() / 2.0f;
        float halfWidth = (float)this.baseTrainType.width / 2.0f;
        if (doorLeftOpen || doorRightOpen) {
            float margin = halfSpacing + 3.0f;
            world.func_175647_a(PlayerEntity.class, new AxisAlignedBB(carX + (double)margin, carY + (double)margin, carZ + (double)margin, carX - (double)margin, carY - (double)margin, carZ - (double)margin), player -> !player.func_175149_v() && !this.ridingEntities.contains(player.func_110124_au()) && railwayData.railwayDataCoolDownModule.canRide((PlayerEntity)player)).forEach(player -> {
                Vector3d positionRotated = player.func_213303_ch().func_178786_a(carX, carY, carZ).func_178785_b(-carYaw).func_178789_a(-carPitch);
                if (Math.abs(positionRotated.field_72450_a) < (double)(halfWidth + 0.5f) && Math.abs(positionRotated.field_72448_b) < 2.5 && Math.abs(positionRotated.field_72449_c) <= (double)halfSpacing) {
                    this.ridingEntities.add(player.func_110124_au());
                    float percentageX = (float)(positionRotated.field_72450_a / (double)this.baseTrainType.width + 0.5);
                    float percentageZ = (float)(realSpacing == 0.0 ? 0.0 : positionRotated.field_72449_c / realSpacing + 0.5) + (float)ridingCar;
                    PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
                    packet.writeLong(this.id);
                    packet.writeFloat(percentageX);
                    packet.writeFloat(percentageZ);
                    packet.func_179252_a(player.func_110124_au());
                    world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_UPDATE_TRAIN_PASSENGERS, packet));
                }
            });
        }
        HashSet ridersToRemove = new HashSet();
        this.ridingEntities.forEach(uuid -> {
            PlayerEntity player = world.func_217371_b(uuid);
            if (player != null) {
                boolean remove;
                if (player.func_175149_v() || player.func_225608_bj_()) {
                    remove = true;
                } else if (doorLeftOpen || doorRightOpen) {
                    Vector3d positionRotated = player.func_213303_ch().func_178786_a(carX, carY, carZ).func_178785_b(-carYaw).func_178789_a(-carPitch);
                    remove = Math.abs(positionRotated.field_72449_c) <= (double)halfSpacing && (Math.abs(positionRotated.field_72450_a) > (double)(halfWidth + 0.5f) || Math.abs(positionRotated.field_72448_b) > 2.0);
                } else {
                    remove = false;
                }
                if (remove) {
                    ridersToRemove.add(uuid);
                }
                railwayData.railwayDataCoolDownModule.updatePlayerRiding(player);
            }
        });
        if (!ridersToRemove.isEmpty()) {
            ridersToRemove.forEach(this.ridingEntities::remove);
        }
    }

    @Override
    protected boolean handlePositions(World world, Vector3d[] positions, float ticksElapsed, float doorValueRaw, float oldDoorValue, float oldRailProgress) {
        AxisAlignedBB trainAABB = new AxisAlignedBB(positions[0], positions[positions.length - 1]).func_186662_g(128.0);
        boolean[] playerNearby = new boolean[]{false};
        world.func_217369_A().forEach(player -> {
            if (this.ridingEntities.contains(player.func_110124_au()) || trainAABB.func_72318_a(player.func_213303_ch())) {
                if (!this.trainsInPlayerRange.containsKey(player)) {
                    this.trainsInPlayerRange.put((PlayerEntity)player, new HashSet());
                }
                this.trainsInPlayerRange.get(player).add(this);
                playerNearby[0] = true;
            }
        });
        BlockPos frontPos = new BlockPos(positions[this.reversed ? positions.length - 1 : 0]);
        if (world.func_217354_b(frontPos.func_177958_n() / 16, frontPos.func_177952_p() / 16)) {
            this.checkBlock(frontPos, checkPos -> {
                BlockState state = world.func_180495_p(checkPos);
                Block block = state.func_177230_c();
                if (block instanceof BlockTrainRedstoneSensor && BlockTrainSensorBase.matchesFilter(world, checkPos, this.routeId, this.speed)) {
                    ((BlockTrainRedstoneSensor)block).power(world, state, (BlockPos)checkPos);
                }
                if ((block instanceof BlockTrainCargoLoader || block instanceof BlockTrainCargoUnloader) && BlockTrainSensorBase.matchesFilter(world, checkPos, this.routeId, this.speed)) {
                    for (Direction direction : Direction.values()) {
                        IInventory nearbyInventory = HopperTileEntity.func_195484_a((World)world, (BlockPos)checkPos.func_177972_a(direction));
                        if (nearbyInventory == null) continue;
                        if (block instanceof BlockTrainCargoLoader) {
                            TrainServer.transferItems(nearbyInventory, (IInventory)this.inventory);
                            continue;
                        }
                        TrainServer.transferItems((IInventory)this.inventory, nearbyInventory);
                    }
                }
            });
        }
        if (!this.ridingEntities.isEmpty()) {
            this.checkBlock(frontPos, checkPos -> {
                TileEntity entity;
                if (world.func_180495_p(checkPos).func_177230_c() instanceof BlockTrainAnnouncer && (entity = world.func_175625_s(checkPos)) instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer && ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).matchesFilter(this.routeId, this.speed)) {
                    this.ridingEntities.forEach(uuid -> ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).announce(world.func_217371_b(uuid)));
                }
            });
        }
        return playerNearby[0];
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        if (this.path.size() > 1 && depot != null) {
            depot.requestDeploy(this.sidingId, this);
        }
        return this.canDeploy;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        if (this.trainPositions != null && checkIndex < this.path.size()) {
            UUID railProduct = ((PathData)this.path.get(checkIndex)).getRailProduct();
            for (Map<UUID, Long> trainPositionsMap : this.trainPositions) {
                if (!trainPositionsMap.containsKey(railProduct) || trainPositionsMap.get(railProduct) == this.id) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean skipScanBlocks(World world, double trainX, double trainY, double trainZ) {
        return world.func_190525_a(trainX, trainY, trainZ, 32.0, entity -> true) == null;
    }

    @Override
    protected boolean openDoors(World world, Block block, BlockPos checkPos, float doorValue, int dwellTicks) {
        if (block instanceof BlockPSDAPGDoorBase) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos doorPos = checkPos.func_177981_b(i);
                BlockState state = world.func_180495_p(doorPos);
                Block doorBlock = state.func_177230_c();
                if (!(doorBlock instanceof BlockPSDAPGDoorBase)) continue;
                int doorStateValue = (int)MathHelper.func_76131_a((float)(doorValue * 64.0f), (float)0.0f, (float)32.0f);
                world.func_175656_a(doorPos, (BlockState)state.func_206870_a((Property)BlockPSDAPGDoorBase.OPEN, (Comparable)Integer.valueOf(doorStateValue)));
                if (doorStateValue <= 0 || world.func_205220_G_().func_205359_a(doorPos, (Object)doorBlock)) continue;
                Utilities.scheduleBlockTick(world, doorPos, doorBlock, dwellTicks);
            }
        }
        return false;
    }

    @Override
    protected double asin(double value) {
        return TrigCache.asin(value);
    }

    public boolean simulateTrain(World world, float ticksElapsed, Depot depot, DataCache dataCache, List<Map<UUID, Long>> trainPositions, Map<PlayerEntity, Set<TrainServer>> trainsInPlayerRange, Map<Long, List<ScheduleEntry>> schedulesForPlatform, boolean isUnlimited) {
        this.trainPositions = trainPositions;
        this.trainsInPlayerRange = trainsInPlayerRange;
        int oldStoppingIndex = this.nextStoppingIndex;
        int oldPassengerCount = this.ridingEntities.size();
        this.simulateTrain(world, ticksElapsed, depot);
        long currentMillis = System.currentTimeMillis() - (long)(this.stopCounter * 50.0f) + (this.isOnRoute ? 0L : (long)Math.max(0, depot.getNextDepartureTicks(Depot.getHour(world))) * 50L);
        float currentTime = -1.0f;
        int startingIndex = 0;
        for (Siding.TimeSegment timeSegment : this.timeSegments) {
            if (RailwayData.isBetween(this.railProgress, timeSegment.startRailProgress, timeSegment.endRailProgress)) {
                currentTime = timeSegment.getTime(this.railProgress);
                break;
            }
            ++startingIndex;
        }
        if (currentTime >= 0.0f) {
            float offsetTime = 0.0f;
            this.routeId = 0L;
            for (int i = startingIndex; i < this.timeSegments.size() + (isUnlimited ? 0 : startingIndex); ++i) {
                Siding.TimeSegment timeSegment = this.timeSegments.get(i % this.timeSegments.size());
                if (timeSegment.savedRailBaseId != 0L) {
                    long platformId;
                    if (timeSegment.routeId == 0L) {
                        RailwayData.useRoutesAndStationsFromIndex(((PathData)this.path.get((int)this.getIndex((float)timeSegment.endRailProgress, (boolean)true))).stopIndex - 1, depot.routeIds, dataCache, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                            timeSegment.routeId = thisRoute == null ? 0L : thisRoute.id;
                            timeSegment.currentStationIndex = currentStationIndex;
                        });
                    }
                    if (!schedulesForPlatform.containsKey(platformId = timeSegment.savedRailBaseId)) {
                        schedulesForPlatform.put(platformId, new ArrayList());
                    }
                    long arrivalMillis = currentMillis + (long)((timeSegment.endTime + offsetTime - currentTime) * 50.0f);
                    schedulesForPlatform.get(platformId).add(new ScheduleEntry(arrivalMillis, this.trainCars, timeSegment.routeId, timeSegment.currentStationIndex));
                }
                if (this.routeId == 0L) {
                    this.routeId = timeSegment.routeId;
                }
                if (i != this.timeSegments.size() - 1) continue;
                offsetTime = timeSegment.endTime;
            }
        }
        ++this.updateRailProgressCounter;
        if (this.updateRailProgressCounter == 40) {
            this.updateRailProgressCounter = 0;
        }
        return oldPassengerCount > this.ridingEntities.size() || oldStoppingIndex != this.nextStoppingIndex;
    }

    public void writeTrainPositions(List<Map<UUID, Long>> trainPositions, SignalBlocks signalBlocks) {
        if (!this.path.isEmpty()) {
            int tailIndex;
            int trainSpacing = this.baseTrainType.getSpacing();
            int headIndex = this.getIndex(0, trainSpacing, true);
            for (int i = tailIndex = this.getIndex(this.trainCars, trainSpacing, false); i <= headIndex; ++i) {
                if (i <= 0 || ((PathData)this.path.get((int)i)).savedRailBaseId == this.sidingId) continue;
                signalBlocks.occupy(((PathData)this.path.get(i)).getRailProduct(), trainPositions, this.id);
            }
        }
    }

    public void deployTrain() {
        this.canDeploy = true;
    }

    private int getNextStoppingIndex() {
        int headIndex;
        for (int i = headIndex = this.getIndex(0, 0, false); i < this.path.size(); ++i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0) continue;
            return i;
        }
        return this.path.size() - 1;
    }

    private void checkBlock(BlockPos pos, Consumer<BlockPos> callback) {
        int checkRadius = (int)Math.floor(this.speed);
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int z = -checkRadius; z <= checkRadius; ++z) {
                for (int y = 0; y <= 3; ++y) {
                    callback.accept(pos.func_177982_a(x, -y, z));
                }
            }
        }
    }

    private static void transferItems(IInventory inventoryFrom, IInventory inventoryTo) {
        for (int i = 0; i < inventoryFrom.func_70302_i_(); ++i) {
            ItemStack insertItem;
            ItemStack remainingStack;
            if (inventoryFrom.func_70301_a(i).func_190926_b() || !(remainingStack = HopperTileEntity.func_174918_a(null, (IInventory)inventoryTo, (ItemStack)(insertItem = new ItemStack((IItemProvider)inventoryFrom.func_70301_a(i).func_77973_b(), 1)), null)).func_190926_b()) continue;
            inventoryFrom.func_70298_a(i, 1);
            return;
        }
    }
}

