/*
 * Decompiled with CFR 0.152.
 */
package mtr.entity;

import java.util.Optional;
import java.util.UUID;
import mtr.EntityTypes;
import mtr.Registry;
import mtr.data.RailwayData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntitySeat
extends Entity {
    private int seatRefresh;
    private PlayerEntity player;
    private PlayerEntity clientPlayer;
    private int clientInterpolationSteps;
    private double clientX;
    private double clientY;
    private double clientZ;
    public static final float SIZE = 0.5f;
    private static final int SEAT_REFRESH = 10;
    private static final DataParameter<Optional<UUID>> PLAYER_ID = EntityDataManager.func_187226_a(EntitySeat.class, (IDataSerializer)DataSerializers.field_187203_m);

    public EntitySeat(EntityType<?> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public EntitySeat(World world, double x, double y, double z) {
        this(EntityTypes.SEAT, world);
        this.func_242281_f(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.clientPlayer == null) {
                PlayerEntity playerEntity = this.clientPlayer = this.field_70180_af == null ? null : (PlayerEntity)((Optional)this.field_70180_af.func_187225_a(PLAYER_ID)).map(value -> this.field_70170_p.func_217371_b(value)).orElse(null);
            }
            if (this.clientPlayer == null) {
                if (this.clientInterpolationSteps > 0) {
                    double x = this.func_226277_ct_() + (this.clientX - this.func_226277_ct_()) / (double)this.clientInterpolationSteps;
                    double y = this.func_226278_cu_() + (this.clientY - this.func_226278_cu_()) / (double)this.clientInterpolationSteps;
                    double z = this.func_226281_cx_() + (this.clientZ - this.func_226281_cx_()) / (double)this.clientInterpolationSteps;
                    --this.clientInterpolationSteps;
                    this.func_242281_f(x, y, z);
                } else {
                    this.func_226264_Z_();
                }
            } else {
                this.func_70107_b(this.clientPlayer.func_226277_ct_(), this.clientPlayer.func_226278_cu_(), this.clientPlayer.func_226281_cx_());
            }
        } else if (this.player == null || this.seatRefresh <= 0) {
            this.func_174812_G();
        } else {
            this.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
            RailwayData railwayData = RailwayData.getInstance(this.field_70170_p);
            if (railwayData != null) {
                railwayData.railwayDataCoolDownModule.updatePlayerSeatCoolDown(this.player);
            }
            --this.seatRefresh;
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientInterpolationSteps = interpolationSteps;
    }

    public IPacket<?> func_213297_N() {
        return Registry.createAddEntityPacket(this);
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PLAYER_ID, Optional.of(new UUID(0L, 0L)));
    }

    protected void func_70037_a(CompoundNBT compoundTag) {
    }

    protected void func_213281_b(CompoundNBT compoundTag) {
    }

    public void initialize(PlayerEntity player) {
        this.field_70180_af.func_187227_b(PLAYER_ID, Optional.of(player.func_110124_au()));
    }

    public void updateSeatByRailwayData(PlayerEntity player) {
        if (player != null) {
            this.seatRefresh = 10;
        }
        this.player = player;
    }
}

