/*
 * Decompiled with CFR 0.152.
 */
package mtr.forge;

import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.ClientData;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.EntityRendererMapper;
import mtr.mappings.NetworkUtilities;
import mtr.mappings.RegistryUtilitiesClient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public class RegistryClientImpl {
    public static void registerBlockRenderType(RenderType type, Block block) {
        RegistryUtilitiesClient.registerRenderType(type, block);
    }

    public static void registerItemModelPredicate(String id, Item item, String tag) {
        RegistryUtilitiesClient.registerItemModelPredicate(id, item, tag);
    }

    public static <T extends BlockEntityMapper> void registerTileEntityRenderer(TileEntityType<T> type, Function<TileEntityRendererDispatcher, BlockEntityRendererMapper<T>> function) {
        RegistryUtilitiesClient.registerTileEntityRenderer(type, function);
    }

    public static <T extends Entity> void registerEntityRenderer(EntityType<T> type, Function<Object, EntityRendererMapper<T>> function) {
        RegistryUtilitiesClient.registerEntityRenderer(type, function::apply);
    }

    public static void registerBlockColors(Block block) {
        RegistryUtilitiesClient.registerBlockColors(new StationColor(), block);
    }

    public static void registerNetworkReceiver(ResourceLocation resourceLocation, Consumer<PacketBuffer> consumer) {
        NetworkUtilities.registerReceiverS2C(resourceLocation, (packet, context) -> consumer.accept(packet));
    }

    public static void registerPlayerJoinEvent(Consumer<ClientPlayerEntity> consumer) {
        RegistryUtilitiesClient.registerPlayerJoinEvent(consumer);
    }

    public static void registerTickEvent(Consumer<Minecraft> consumer) {
        RegistryUtilitiesClient.registerClientTickEvent(consumer);
    }

    public static void sendToServer(ResourceLocation id, PacketBuffer packet) {
        NetworkUtilities.sendToServer(id, packet);
    }

    private static class StationColor
    implements IBlockColor {
        private StationColor() {
        }

        public int getColor(BlockState blockState, IBlockDisplayReader blockAndTintGetter, BlockPos pos, int i) {
            int defaultColor = 0x7F7F7F;
            if (pos != null) {
                try {
                    return ClientData.STATIONS.stream().filter(station1 -> station1.inArea(pos.func_177958_n(), pos.func_177952_p())).findFirst().map(station2 -> station2.color).orElse(0x7F7F7F);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return 0x7F7F7F;
        }
    }
}

