/*
 * Decompiled with CFR 0.152.
 */
package mtr.forge;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.mappings.ForgeUtilities;
import mtr.mappings.NetworkUtilities;
import mtr.mappings.RegistryUtilities;
import mtr.mixin.PlayerTeleportationStateAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public class RegistryImpl {
    public static ItemGroup getItemGroup(ResourceLocation id, Supplier<ItemStack> supplier) {
        return RegistryUtilities.createCreativeTab(id, supplier);
    }

    public static IPacket<?> createAddEntityPacket(Entity entity) {
        return ForgeUtilities.createAddEntityPacket(entity);
    }

    public static void registerNetworkReceiver(ResourceLocation resourceLocation, NetworkUtilities.PacketCallback packetCallback) {
        NetworkUtilities.registerReceiverC2S(resourceLocation, packetCallback);
    }

    public static void registerPlayerJoinEvent(Consumer<ServerPlayerEntity> consumer) {
        RegistryUtilities.registerPlayerJoinEvent(consumer);
        RegistryUtilities.registerPlayerChangeDimensionEvent(consumer);
    }

    public static void registerPlayerQuitEvent(Consumer<ServerPlayerEntity> consumer) {
        RegistryUtilities.registerPlayerQuitEvent(consumer);
    }

    public static void registerServerStartingEvent(Consumer<MinecraftServer> consumer) {
        RegistryUtilities.registerServerStartingEvent(consumer);
    }

    public static void registerServerStoppingEvent(Consumer<MinecraftServer> consumer) {
        RegistryUtilities.registerServerStoppingEvent(consumer);
    }

    public static void registerTickEvent(Consumer<MinecraftServer> consumer) {
        RegistryUtilities.registerTickEvent(consumer);
    }

    public static void sendToPlayer(ServerPlayerEntity player, ResourceLocation id, PacketBuffer packet) {
        NetworkUtilities.sendToPlayer(player, id, packet);
    }

    public static void setInTeleportationState(PlayerEntity player, boolean isRiding) {
        ((PlayerTeleportationStateAccessor)player).setInTeleportationState(isRiding);
    }
}

