/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.ItemGroups;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class ItemNodeModifierBase
extends Item {
    protected final boolean isConnector;
    public static final String TAG_POS = "pos";
    private static final String TAG_TRANSPORT_MODE = "transport_mode";

    public ItemNodeModifierBase(boolean isConnector) {
        super(new Item.Properties().func_200916_a(ItemGroups.CORE).func_200917_a(1));
        this.isConnector = isConnector;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            RailwayData railwayData = RailwayData.getInstance(world);
            BlockPos posStart = context.func_195995_a();
            BlockState stateStart = world.func_180495_p(posStart);
            Block blockStart = stateStart.func_177230_c();
            if (railwayData != null && blockStart instanceof BlockNode) {
                CompoundNBT compoundTag = context.func_195996_i().func_196082_o();
                if (compoundTag.func_74764_b(TAG_POS) && compoundTag.func_74764_b(TAG_TRANSPORT_MODE)) {
                    BlockPos posEnd = BlockPos.func_218283_e((long)compoundTag.func_74763_f(TAG_POS));
                    BlockState stateEnd = world.func_180495_p(posEnd);
                    if (stateEnd.func_177230_c() instanceof BlockNode && ((BlockNode)blockStart).transportMode.toString().equals(compoundTag.func_74779_i(TAG_TRANSPORT_MODE))) {
                        PlayerEntity player = context.func_195999_j();
                        if (this.isConnector) {
                            if (!posStart.equals((Object)posEnd)) {
                                float angle1 = BlockNode.getAngle(stateStart);
                                float angle2 = BlockNode.getAngle(stateEnd);
                                float angleDifference = (float)Math.toDegrees(Math.atan2(posEnd.func_177952_p() - posStart.func_177952_p(), posEnd.func_177958_n() - posStart.func_177958_n()));
                                RailAngle railAngleStart = RailAngle.fromAngle(angle1 + (float)(RailAngle.similarFacing(angleDifference, angle1) ? 0 : 180));
                                RailAngle railAngleEnd = RailAngle.fromAngle(angle2 + (float)(RailAngle.similarFacing(angleDifference, angle2) ? 180 : 0));
                                this.onConnect(world, context.func_195996_i(), ((BlockNode)blockStart).transportMode, stateStart, stateEnd, posStart, posEnd, railAngleStart, railAngleEnd, player, railwayData);
                            }
                        } else {
                            this.onRemove(world, posStart, posEnd, railwayData);
                        }
                    }
                    compoundTag.func_82580_o(TAG_POS);
                    compoundTag.func_82580_o(TAG_TRANSPORT_MODE);
                } else {
                    compoundTag.func_74772_a(TAG_POS, posStart.func_218275_a());
                    compoundTag.func_74778_a(TAG_TRANSPORT_MODE, ((BlockNode)blockStart).transportMode.toString());
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(context);
    }

    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        CompoundNBT compoundTag = stack.func_196082_o();
        long posLong = compoundTag.func_74763_f(TAG_POS);
        if (posLong != 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.selected_block", new Object[]{BlockPos.func_218283_e((long)posLong).func_229422_x_()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)));
        }
    }

    protected abstract void onConnect(World var1, ItemStack var2, TransportMode var3, BlockState var4, BlockState var5, BlockPos var6, BlockPos var7, RailAngle var8, RailAngle var9, PlayerEntity var10, RailwayData var11);

    protected abstract void onRemove(World var1, BlockPos var2, BlockPos var3, RailwayData var4);
}

