/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.Blocks;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class ItemNodeModifierSelectableBlockBase
extends ItemNodeModifierBase {
    private final boolean canSaveBlock;
    private final int height;
    private final int width;
    private final int radius;
    private static final String TAG_BLOCK_ID = "block_id";

    public ItemNodeModifierSelectableBlockBase(boolean canSaveBlock, int height, int width) {
        super(true);
        this.canSaveBlock = canSaveBlock;
        this.height = height;
        this.width = width;
        this.radius = width / 2;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.canSaveBlock) {
            PlayerEntity player;
            World world = context.func_195991_k();
            if (!world.field_72995_K && (player = context.func_195999_j()) != null && player.func_225608_bj_()) {
                BlockState state = world.func_180495_p(context.func_195995_a());
                BlockState newState = state.func_177230_c() instanceof BlockNode ? net.minecraft.block.Blocks.field_150350_a.func_176223_P() : state;
                player.func_146105_b((ITextComponent)new TranslationTextComponent("tooltip.mtr.selected_material", new Object[]{new TranslationTextComponent(newState.func_177230_c().func_149739_a())}), true);
                CompoundNBT compoundTag = context.func_195996_i().func_196082_o();
                compoundTag.func_74768_a(TAG_BLOCK_ID, Block.func_196246_j((BlockState)newState));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }

    @Override
    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        if (this.height > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.rail_action_height", new Object[]{this.height}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.rail_action_width", new Object[]{this.width}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        if (this.canSaveBlock) {
            String[] textSplit;
            BlockState state = this.getSavedState(stack);
            for (String text : textSplit = new TranslationTextComponent(state.func_196958_f() ? "tooltip.mtr.shift_right_click_to_select_material" : "tooltip.mtr.shift_right_click_to_clear", new Object[]{Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_238171_j_(), new TranslationTextComponent(Blocks.RAIL_NODE.func_149739_a())}).getString().split("\\|")) {
                tooltip.add((ITextComponent)new StringTextComponent(text).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY).func_240721_b_(TextFormatting.ITALIC)));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.selected_material", new Object[]{new TranslationTextComponent(state.func_177230_c().func_149739_a())}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)));
        }
        super.func_77624_a(stack, level, tooltip, tooltipFlag);
    }

    @Override
    protected final void onConnect(World world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, PlayerEntity player, RailwayData railwayData) {
        if (player != null && !this.onConnect(player, stack, railwayData, posStart, posEnd, this.radius, this.height)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.rail_not_found_action"), true);
        }
    }

    @Override
    protected final void onRemove(World world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
    }

    protected BlockState getSavedState(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(TAG_BLOCK_ID)) {
            return Block.func_196257_b((int)tag.func_74762_e(TAG_BLOCK_ID));
        }
        return net.minecraft.block.Blocks.field_150350_a.func_176223_P();
    }

    protected abstract boolean onConnect(PlayerEntity var1, ItemStack var2, RailwayData var3, BlockPos var4, BlockPos var5, int var6, int var7);
}

