/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.Blocks;
import mtr.ItemGroups;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemPSDAPGBase
extends Item
implements IBlock {
    private final EnumPSDAPGItem item;
    private final EnumPSDAPGType type;

    public ItemPSDAPGBase(EnumPSDAPGItem item, EnumPSDAPGType type) {
        super(new Item.Properties().func_200916_a(ItemGroups.RAILWAY_FACILITIES));
        this.item = item;
        this.type = type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean isPSD;
        boolean isDoor = this.item == EnumPSDAPGItem.PSD_APG_DOOR;
        if (ItemPSDAPGBase.blocksNotReplaceable(context, isDoor ? 2 : 1, (isPSD = this.type == EnumPSDAPGType.PSD_1 || this.type == EnumPSDAPGType.PSD_2) ? 3 : 2, this.getBlockStateFromItem().func_177230_c())) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        Direction playerFacing = context.func_195992_f();
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
        for (int x = 0; x < (isDoor ? 2 : 1); ++x) {
            BlockPos newPos = pos.func_177967_a(playerFacing.func_176746_e(), x);
            for (int y = 0; y < 2; ++y) {
                IBlock.EnumSide side;
                BlockState state = (BlockState)((BlockState)this.getBlockStateFromItem().func_206870_a((Property)BlockPSDAPGBase.field_185512_D, (Comparable)playerFacing)).func_206870_a((Property)HALF, (Comparable)(y == 1 ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
                if (isDoor) {
                    side = x == 0 ? IBlock.EnumSide.LEFT : IBlock.EnumSide.RIGHT;
                    world.func_175656_a(newPos.func_177981_b(y), (BlockState)state.func_206870_a((Property)SIDE, (Comparable)((Object)side)));
                    continue;
                }
                side = IBlock.EnumSide.SINGLE;
                world.func_175656_a(newPos.func_177981_b(y), (BlockState)state.func_206870_a((Property)SIDE_EXTENDED, (Comparable)((Object)side)));
            }
            if (!isPSD) continue;
            world.func_175656_a(newPos.func_177981_b(2), BlockPSDTop.getActualState((IBlockReader)world, newPos.func_177981_b(2)));
        }
        context.func_195996_i().func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack itemStack, World level, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr." + this.item.func_176610_l()).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
    }

    private BlockState getBlockStateFromItem() {
        switch (this.type) {
            case PSD_1: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.PSD_DOOR_1.func_176223_P();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.PSD_GLASS_1.func_176223_P();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.PSD_GLASS_END_1.func_176223_P();
                    }
                }
            }
            case PSD_2: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.PSD_DOOR_2.func_176223_P();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.PSD_GLASS_2.func_176223_P();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.PSD_GLASS_END_2.func_176223_P();
                    }
                }
            }
            case APG: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.APG_DOOR.func_176223_P();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.APG_GLASS.func_176223_P();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.APG_GLASS_END.func_176223_P();
                    }
                }
            }
        }
        return net.minecraft.block.Blocks.field_150350_a.func_176223_P();
    }

    public static boolean blocksNotReplaceable(ItemUseContext context, int width, int height, Block blacklistBlock) {
        Direction facing = context.func_195992_f();
        World world = context.func_195991_k();
        BlockPos startingPos = context.func_195995_a().func_177972_a(context.func_196000_l());
        for (int x = 0; x < width; ++x) {
            BlockPos offsetPos = startingPos.func_177967_a(facing.func_176746_e(), x);
            if (blacklistBlock != null) {
                boolean isBlacklistedBelow = world.func_180495_p(offsetPos.func_177977_b()).func_203425_a(blacklistBlock);
                boolean isBlacklistedAbove = world.func_180495_p(offsetPos.func_177981_b(height)).func_203425_a(blacklistBlock);
                if (isBlacklistedBelow || isBlacklistedAbove) {
                    return true;
                }
            }
            for (int y = 0; y < height; ++y) {
                if (world.func_180495_p(offsetPos.func_177981_b(y)).func_185904_a().func_76222_j()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum EnumPSDAPGItem implements IStringSerializable
    {
        PSD_APG_DOOR("psd_apg_door"),
        PSD_APG_GLASS("psd_apg_glass"),
        PSD_APG_GLASS_END("psd_apg_glass_end");

        private final String name;

        private EnumPSDAPGItem(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumPSDAPGType {
        PSD_1,
        PSD_2,
        APG;

    }
}

