/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.block.BlockNode;
import mtr.data.Rail;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemRailModifier
extends ItemNodeModifierBase {
    private final boolean isOneWay;
    private final RailType railType;

    public ItemRailModifier() {
        super(false);
        this.isOneWay = false;
        this.railType = null;
    }

    public ItemRailModifier(boolean isOneWay, RailType railType) {
        super(true);
        this.isOneWay = isOneWay;
        this.railType = railType;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World level, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        if (this.isConnector && this.railType != null && this.railType.canAccelerate) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mtr.rail_speed_limit", new Object[]{this.railType.speedLimit}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        }
        super.func_77624_a(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    protected void onConnect(World world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, PlayerEntity player, RailwayData railwayData) {
        if (this.railType.hasSavedRail && (railwayData.hasSavedRail(posStart) || railwayData.hasSavedRail(posEnd))) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.platform_or_siding_exists"), true);
            }
        } else {
            boolean isValid;
            Rail rail1 = new Rail(posStart, facingStart, posEnd, facingEnd, this.isOneWay ? RailType.NONE : this.railType, transportMode);
            Rail rail2 = new Rail(posEnd, facingEnd, posStart, facingStart, this.railType, transportMode);
            boolean goodRadius = rail1.goodRadius() && rail2.goodRadius();
            boolean bl = isValid = rail1.isValid() && rail2.isValid();
            if (goodRadius && isValid) {
                railwayData.addRail(transportMode, posStart, posEnd, rail1, false);
                long newId = railwayData.addRail(transportMode, posEnd, posStart, rail2, true);
                world.func_175656_a(posStart, (BlockState)stateStart.func_206870_a((Property)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                world.func_175656_a(posEnd, (BlockState)stateEnd.func_206870_a((Property)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                PacketTrainDataGuiServer.createRailS2C(world, transportMode, posStart, posEnd, rail1, rail2, newId);
            } else if (player != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(goodRadius ? "gui.mtr.invalid_orientation" : "gui.mtr.radius_too_small"), true);
            }
        }
    }

    @Override
    protected void onRemove(World world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
        railwayData.removeRailConnection(posStart, posEnd);
        PacketTrainDataGuiServer.removeRailConnectionS2C(world, posStart, posEnd);
    }
}

