/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.path.PathData;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemSignalModifier
extends ItemNodeModifierBase {
    private final DyeColor color;

    public ItemSignalModifier(boolean isConnector, DyeColor color) {
        super(isConnector);
        this.color = color;
    }

    @Override
    protected void onConnect(World world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, PlayerEntity player, RailwayData railwayData) {
        if (railwayData.containsRail(posStart, posEnd)) {
            PacketTrainDataGuiServer.createSignalS2C(world, railwayData.addSignal(this.color, posStart, posEnd), this.color, PathData.getRailProduct(posStart, posEnd));
        } else if (player != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.rail_not_found"), true);
        }
    }

    @Override
    protected void onRemove(World world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
        PacketTrainDataGuiServer.removeSignalS2C(world, railwayData.removeSignal(this.color, posStart, posEnd), this.color, PathData.getRailProduct(posStart, posEnd));
    }
}

