/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.registry.CreativeTabs;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;

public interface RegistryUtilities {
    public static <T extends BlockEntityMapper> TileEntityType<T> getBlockEntityType(Utilities.TileEntitySupplier<T> supplier, Block block) {
        return new TileEntityType(() -> supplier.supplier(null, null), Collections.singleton(block), null);
    }

    public static <T extends CommandRegistrationEvent> void registerCommand(T listener) {
        CommandRegistrationEvent.EVENT.register(listener);
    }

    public static void registerPlayerJoinEvent(Consumer<ServerPlayerEntity> consumer) {
        PlayerEvent.PLAYER_JOIN.register(consumer::accept);
    }

    public static void registerPlayerQuitEvent(Consumer<ServerPlayerEntity> consumer) {
        PlayerEvent.PLAYER_QUIT.register(consumer::accept);
    }

    public static void registerPlayerChangeDimensionEvent(Consumer<ServerPlayerEntity> consumer) {
        PlayerEvent.CHANGE_DIMENSION.register((player, oldWorld, newWorld) -> consumer.accept(player));
    }

    public static void registerServerStartingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STARTING.register(consumer::accept);
    }

    public static void registerServerStoppingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STOPPING.register(consumer::accept);
    }

    public static void registerTickEvent(Consumer<MinecraftServer> consumer) {
        TickEvent.SERVER_PRE.register(consumer::accept);
    }

    public static ItemGroup createCreativeTab(ResourceLocation name, Supplier<ItemStack> icon) {
        return CreativeTabs.create((ResourceLocation)name, icon);
    }
}

