/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.architectury.event.events.TextureStitchEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.registry.BlockEntityRenderers;
import me.shedaniel.architectury.registry.ColorHandlers;
import me.shedaniel.architectury.registry.ItemPropertiesRegistry;
import me.shedaniel.architectury.registry.RenderTypes;
import me.shedaniel.architectury.registry.entity.EntityRenderers;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.EntityRendererMapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public interface RegistryUtilitiesClient {
    public static void registerItemModelPredicate(String id, Item item, String tag) {
        ItemPropertiesRegistry.register((IItemProvider)item, (ResourceLocation)new ResourceLocation(id), (itemStack, clientWorld, livingEntity) -> itemStack.func_196082_o().func_74764_b(tag) ? 1.0f : 0.0f);
    }

    public static <T extends BlockEntityMapper> void registerTileEntityRenderer(TileEntityType<T> type, Function<TileEntityRendererDispatcher, BlockEntityRendererMapper<T>> factory) {
        BlockEntityRenderers.registerRenderer(type, context -> (TileEntityRenderer)factory.apply(null));
    }

    public static <T extends Entity> void registerEntityRenderer(EntityType<T> type, Function<EntityRendererManager, EntityRendererMapper<T>> factory) {
        EntityRenderers.register(type, factory::apply);
    }

    public static void registerRenderType(RenderType renderType, Block block) {
        RenderTypes.register((RenderType)renderType, (Block[])new Block[]{block});
    }

    public static void registerBlockColors(IBlockColor blockColor, Block block) {
        ColorHandlers.registerBlockColors((IBlockColor)blockColor, (Block[])new Block[]{block});
    }

    public static void registerPlayerJoinEvent(Consumer<ClientPlayerEntity> consumer) {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(consumer::accept);
    }

    public static void registerClientTickEvent(Consumer<Minecraft> consumer) {
        ClientTickEvent.CLIENT_PRE.register(consumer::accept);
    }

    public static void registerTextureStitchEvent(Consumer<AtlasTexture> consumer) {
        TextureStitchEvent.POST.register(consumer::accept);
    }
}

