/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelTrainBase;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class ModelDoorOverlay
extends EntityModel<Entity> {
    private final ModelMapper door_left_overlay_interior;
    private final ModelMapper door_left_top_r1;
    private final ModelMapper door_right_overlay_interior;
    private final ModelMapper door_right_top_r1;
    private final ModelMapper door_right_bottom_r1;
    private final ModelMapper door_left_overlay_exterior;
    private final ModelMapper door_left_top_r2;
    private final ModelMapper door_right_overlay_exterior;
    private final ModelMapper door_right_top_r2;
    private final ModelMapper wall_1;
    private final ModelMapper upper_wall_1_r1;
    private final ModelMapper wall_2;
    private final ModelMapper upper_wall_2_r1;
    private final ResourceLocation doorOverlayTextureLeft;
    private final ResourceLocation doorOverlayTextureRight;
    private final boolean renderLeft;
    private final boolean renderRight;

    public ModelDoorOverlay(int doorMax, float angle, String overlayLeftTextureName, String overlayRightTextureName) {
        this(doorMax, angle, 14, overlayLeftTextureName, overlayRightTextureName, true, true);
    }

    public ModelDoorOverlay(int doorMax, float angle, int pivotY, String overlayLeftTextureName, String overlayRightTextureName) {
        this(doorMax, angle, pivotY, overlayLeftTextureName, overlayRightTextureName, true, true);
    }

    public ModelDoorOverlay(int doorMax, float angle, int pivotY, String overlayLeftTextureName, String overlayRightTextureName, boolean renderLeft, boolean renderRight) {
        float angleRadians = (float)Math.toRadians(angle);
        this.doorOverlayTextureLeft = new ResourceLocation("mtr:textures/sign/" + overlayLeftTextureName);
        this.doorOverlayTextureRight = new ResourceLocation("mtr:textures/sign/" + overlayRightTextureName);
        this.renderLeft = renderLeft;
        this.renderRight = renderRight;
        int textureWidth = 38;
        int textureHeight = 32;
        ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, 38, 32);
        this.door_left_overlay_interior = new ModelMapper(modelDataWrapper);
        this.door_left_overlay_interior.func_78793_a(0.0f, 24.0f, 0.0f);
        this.door_left_overlay_interior.func_78784_a(3, 3).func_228303_a_(-19.7f, (float)(-pivotY), 0.0f, 0.0f, 13.0f, 16.0f, 0.0f, false);
        this.door_left_top_r1 = new ModelMapper(modelDataWrapper);
        this.door_left_top_r1.func_78793_a(-19.7f, -pivotY, 0.0f);
        this.door_left_overlay_interior.func_78792_a(this.door_left_top_r1);
        ModelTrainBase.setRotationAngle(this.door_left_top_r1, 0.0f, 0.0f, angleRadians);
        this.door_left_top_r1.func_78784_a(3, -16).func_228303_a_(0.0f, -19.0f, 0.0f, 0.0f, 19.0f, 16.0f, 0.0f, false);
        this.door_right_overlay_interior = new ModelMapper(modelDataWrapper);
        this.door_right_overlay_interior.func_78793_a(0.0f, 24.0f, 0.0f);
        this.door_right_top_r1 = new ModelMapper(modelDataWrapper);
        this.door_right_top_r1.func_78793_a(-19.7f, -pivotY, 0.0f);
        this.door_right_overlay_interior.func_78792_a(this.door_right_top_r1);
        ModelTrainBase.setRotationAngle(this.door_right_top_r1, 0.0f, 3.1416f, angleRadians);
        this.door_right_top_r1.func_78784_a(3, -16).func_228303_a_(0.0f, -19.0f, 0.0f, 0.0f, 19.0f, 16.0f, 0.0f, false);
        this.door_right_bottom_r1 = new ModelMapper(modelDataWrapper);
        this.door_right_bottom_r1.func_78793_a(0.0f, 0.0f, 0.0f);
        this.door_right_overlay_interior.func_78792_a(this.door_right_bottom_r1);
        ModelTrainBase.setRotationAngle(this.door_right_bottom_r1, 0.0f, 3.1416f, 0.0f);
        this.door_right_bottom_r1.func_78784_a(3, 3).func_228303_a_(19.7f, (float)(-pivotY), 0.0f, 0.0f, 13.0f, 16.0f, 0.0f, false);
        this.door_left_overlay_exterior = new ModelMapper(modelDataWrapper);
        this.door_left_overlay_exterior.func_78793_a(0.0f, 24.0f, 0.0f);
        this.door_left_top_r2 = new ModelMapper(modelDataWrapper);
        this.door_left_top_r2.func_78793_a(-20.7f, -pivotY, 0.0f);
        this.door_left_overlay_exterior.func_78792_a(this.door_left_top_r2);
        ModelTrainBase.setRotationAngle(this.door_left_top_r2, 0.0f, 0.0f, angleRadians);
        this.door_left_top_r2.func_78784_a(3, -16).func_228303_a_(0.0f, -19.0f, 0.0f, 0.0f, 19.0f, 16.0f, 0.0f, false);
        this.door_right_overlay_exterior = new ModelMapper(modelDataWrapper);
        this.door_right_overlay_exterior.func_78793_a(0.0f, 24.0f, 0.0f);
        this.door_right_top_r2 = new ModelMapper(modelDataWrapper);
        this.door_right_top_r2.func_78793_a(-20.7f, -pivotY, 0.0f);
        this.door_right_overlay_exterior.func_78792_a(this.door_right_top_r2);
        ModelTrainBase.setRotationAngle(this.door_right_top_r2, 0.0f, 3.1416f, angleRadians);
        this.door_right_top_r2.func_78784_a(3, -16).func_228303_a_(0.0f, -19.0f, 0.0f, 0.0f, 19.0f, 16.0f, 0.0f, false);
        this.wall_1 = new ModelMapper(modelDataWrapper);
        this.wall_1.func_78793_a(0.0f, 24.0f, 0.0f);
        this.wall_1.func_78784_a(32, 19).func_228303_a_(-20.0f, (float)(-pivotY), (float)(-doorMax) + 0.1f, 3.0f, 13.0f, 0.0f, 0.0f, false);
        this.upper_wall_1_r1 = new ModelMapper(modelDataWrapper);
        this.upper_wall_1_r1.func_78793_a(-20.0f, -pivotY, 0.0f);
        this.wall_1.func_78792_a(this.upper_wall_1_r1);
        ModelTrainBase.setRotationAngle(this.upper_wall_1_r1, 0.0f, 0.0f, angleRadians);
        this.upper_wall_1_r1.func_78784_a(32, 0).func_228303_a_(0.0f, -19.0f, (float)(-doorMax) + 0.1f, 3.0f, 19.0f, 0.0f, 0.0f, false);
        this.wall_2 = new ModelMapper(modelDataWrapper);
        this.wall_2.func_78793_a(0.0f, 24.0f, 0.0f);
        this.wall_2.func_78784_a(0, 19).func_228303_a_(-20.0f, (float)(-pivotY), (float)doorMax - 0.1f, 3.0f, 13.0f, 0.0f, 0.0f, false);
        this.upper_wall_2_r1 = new ModelMapper(modelDataWrapper);
        this.upper_wall_2_r1.func_78793_a(-20.0f, -pivotY, 0.0f);
        this.wall_2.func_78792_a(this.upper_wall_2_r1);
        ModelTrainBase.setRotationAngle(this.upper_wall_2_r1, 0.0f, 0.0f, angleRadians);
        this.upper_wall_2_r1.func_78784_a(0, 0).func_228303_a_(0.0f, -19.0f, (float)doorMax - 0.1f, 3.0f, 19.0f, 0.0f, 0.0f, false);
        modelDataWrapper.setModelPart(38, 32);
        this.door_left_overlay_interior.setModelPart();
        this.door_right_overlay_interior.setModelPart();
        this.door_left_overlay_exterior.setModelPart();
        this.door_right_overlay_exterior.setModelPart();
        this.wall_1.setModelPart();
        this.wall_2.setModelPart();
    }

    public void render(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, ModelTrainBase.RenderStage renderStage, int light, int position, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean lightsOn) {
        switch (renderStage) {
            case INTERIOR: {
                RenderType renderLayerInteriorRight;
                RenderType renderLayerInteriorLeft = lightsOn ? MoreRenderLayers.getInterior(this.doorOverlayTextureLeft) : MoreRenderLayers.getExterior(this.doorOverlayTextureLeft);
                RenderType renderType = renderLayerInteriorRight = lightsOn ? MoreRenderLayers.getInterior(this.doorOverlayTextureRight) : MoreRenderLayers.getExterior(this.doorOverlayTextureRight);
                if (this.renderRight) {
                    ModelTrainBase.renderOnce(this.door_left_overlay_interior, matrices, vertexConsumers.getBuffer(renderLayerInteriorRight), light, doorRightX, (float)position + doorRightZ);
                    ModelTrainBase.renderOnce(this.door_right_overlay_interior, matrices, vertexConsumers.getBuffer(renderLayerInteriorLeft), light, doorRightX, (float)position - doorRightZ);
                    ModelTrainBase.renderOnce(this.wall_1, matrices, vertexConsumers.getBuffer(renderLayerInteriorLeft), light, position);
                    ModelTrainBase.renderOnce(this.wall_2, matrices, vertexConsumers.getBuffer(renderLayerInteriorRight), light, position);
                }
                if (!this.renderLeft) break;
                ModelTrainBase.renderOnceFlipped(this.door_left_overlay_interior, matrices, vertexConsumers.getBuffer(renderLayerInteriorRight), light, doorLeftX, (float)position - doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.door_right_overlay_interior, matrices, vertexConsumers.getBuffer(renderLayerInteriorLeft), light, doorLeftX, (float)position + doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.wall_1, matrices, vertexConsumers.getBuffer(renderLayerInteriorLeft), light, position);
                ModelTrainBase.renderOnceFlipped(this.wall_2, matrices, vertexConsumers.getBuffer(renderLayerInteriorRight), light, position);
                break;
            }
            case EXTERIOR: {
                if (this.renderRight) {
                    ModelTrainBase.renderOnce(this.door_left_overlay_exterior, matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.doorOverlayTextureLeft)), light / 4 * 3, doorRightX, (float)position + doorRightZ);
                    ModelTrainBase.renderOnce(this.door_right_overlay_exterior, matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.doorOverlayTextureRight)), light / 4 * 3, doorRightX, (float)position - doorRightZ);
                }
                if (!this.renderLeft) break;
                ModelTrainBase.renderOnceFlipped(this.door_left_overlay_exterior, matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.doorOverlayTextureLeft)), light / 4 * 3, doorLeftX, (float)position - doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.door_right_overlay_exterior, matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.doorOverlayTextureRight)), light / 4 * 3, doorLeftX, (float)position + doorLeftZ);
            }
        }
    }

    public void func_225597_a_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public final void func_225598_a_(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
    }
}

