/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.data.IGui;
import mtr.mappings.ModelMapper;
import mtr.model.ModelBogie;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public abstract class ModelTrainBase
extends EntityModel<Entity>
implements IGui {
    private static final ModelBogie MODEL_BOGIE = new ModelBogie();

    public void func_225597_a_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public final void func_225598_a_(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
    }

    public final void render(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, ResourceLocation texture, int light, float doorLeftValue, float doorRightValue, boolean opening, boolean isEnd1Head, boolean isEnd2Head, boolean head1IsFront, boolean lightsOn, boolean isTranslucent, boolean renderDetails) {
        int lightOnGlowingLevel;
        float doorLeftX = this.getDoorAnimationX(doorLeftValue, opening);
        float doorRightX = this.getDoorAnimationX(doorRightValue, opening);
        float doorLeftZ = this.getDoorAnimationZ(doorLeftValue, opening);
        float doorRightZ = this.getDoorAnimationZ(doorRightValue, opening);
        int lightOnInteriorLevel = lightsOn ? 0xF000B0 : light;
        int n = lightOnGlowingLevel = lightsOn ? 0xF000F0 : light;
        if (isTranslucent) {
            if (renderDetails) {
                RenderType renderLayerInteriorTranslucent = lightsOn ? MoreRenderLayers.getInteriorTranslucent(texture) : MoreRenderLayers.getExteriorTranslucent(texture);
                this.render(matrices, vertexConsumers.getBuffer(renderLayerInteriorTranslucent), RenderStage.INTERIOR_TRANSLUCENT, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head, head1IsFront, renderDetails);
            }
        } else {
            RenderType renderLayerLight = lightsOn ? MoreRenderLayers.getLight(texture, false) : MoreRenderLayers.getExterior(texture);
            RenderType renderLayerInterior = lightsOn ? MoreRenderLayers.getInterior(texture) : MoreRenderLayers.getExterior(texture);
            this.render(matrices, vertexConsumers.getBuffer(renderLayerLight), RenderStage.LIGHTS, lightOnGlowingLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.getBuffer(renderLayerInterior), RenderStage.INTERIOR, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head, head1IsFront, renderDetails);
            if (renderDetails) {
                for (int position : this.getDoorPositions()) {
                    ModelDoorOverlayTopBase modelDoorOverlayTop;
                    ModelDoorOverlay modelDoorOverlay = this.getModelDoorOverlay();
                    if (modelDoorOverlay != null) {
                        modelDoorOverlay.render(matrices, vertexConsumers, RenderStage.INTERIOR, lightOnInteriorLevel, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
                        modelDoorOverlay.render(matrices, vertexConsumers, RenderStage.EXTERIOR, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
                    }
                    if ((modelDoorOverlayTop = this.getModelDoorOverlayTop()) == null) continue;
                    modelDoorOverlayTop.render(matrices, vertexConsumers, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
                }
            }
            for (int position : this.getBogiePositions()) {
                MODEL_BOGIE.render(matrices, vertexConsumers, light, position);
            }
            this.render(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(texture)), RenderStage.EXTERIOR, light, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(texture, true)), RenderStage.ALWAYS_ON_LIGHTS, 0xF000F0, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head, head1IsFront, renderDetails);
        }
    }

    private void render(MatrixStack matrices, IVertexBuilder vertices, RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean isEnd1Head, boolean isEnd2Head, boolean head1IsFront, boolean renderDetails) {
        for (int position : this.getWindowPositions()) {
            this.renderWindowPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        for (int position : this.getDoorPositions()) {
            this.renderDoorPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        if (isEnd1Head) {
            this.renderHeadPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, head1IsFront);
        } else {
            this.renderEndPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
        if (isEnd2Head) {
            this.renderHeadPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, !head1IsFront);
        } else {
            this.renderEndPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    protected abstract void renderWindowPositions(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderDoorPositions(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderHeadPosition1(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderHeadPosition2(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderEndPosition1(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract void renderEndPosition2(MatrixStack var1, IVertexBuilder var2, RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract ModelDoorOverlay getModelDoorOverlay();

    protected abstract ModelDoorOverlayTopBase getModelDoorOverlayTop();

    protected abstract int[] getWindowPositions();

    protected abstract int[] getDoorPositions();

    protected abstract int[] getEndPositions();

    protected abstract int[] getBogiePositions();

    protected abstract float getDoorAnimationX(float var1, boolean var2);

    protected abstract float getDoorAnimationZ(float var1, boolean var2);

    protected static void setRotationAngle(ModelMapper bone, float x, float y, float z) {
        bone.setRotationAngle(x, y, z);
    }

    protected static void renderMirror(ModelMapper bone, MatrixStack matrices, IVertexBuilder vertices, int light, float position) {
        ModelTrainBase.renderOnce(bone, matrices, vertices, light, position);
        ModelTrainBase.renderOnceFlipped(bone, matrices, vertices, light, position);
    }

    protected static void renderOnce(ModelMapper bone, MatrixStack matrices, IVertexBuilder vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, 0.0f, light, OverlayTexture.field_229196_a_);
    }

    protected static void renderOnce(ModelMapper bone, MatrixStack matrices, IVertexBuilder vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, positionX, positionZ, 0.0f, light, OverlayTexture.field_229196_a_);
    }

    protected static void renderOnceFlipped(ModelMapper bone, MatrixStack matrices, IVertexBuilder vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, (float)Math.PI, light, OverlayTexture.field_229196_a_);
    }

    protected static void renderOnceFlipped(ModelMapper bone, MatrixStack matrices, IVertexBuilder vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, -positionX, positionZ, (float)Math.PI, light, OverlayTexture.field_229196_a_);
    }

    protected static boolean isIndex(int index, int value, int[] array) {
        int finalIndex = index < 0 ? array.length + index : index;
        return finalIndex < array.length && finalIndex >= 0 && array[finalIndex] == value;
    }

    protected static float smoothEnds(float startValue, float endValue, float startTime, float endTime, float time) {
        if (time < startTime) {
            return startValue;
        }
        if (time > endTime) {
            return endValue;
        }
        float timeChange = endTime - startTime;
        float valueChange = endValue - startValue;
        return valueChange * (float)(1.0 - Math.cos(Math.PI * (double)(time - startTime) / (double)timeChange)) / 2.0f + startValue;
    }

    protected static enum RenderStage {
        LIGHTS,
        ALWAYS_ON_LIGHTS,
        INTERIOR,
        INTERIOR_TRANSLUCENT,
        EXTERIOR;

    }
}

